/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PortPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static int MAX_HOSTNAME_LENGTH = 5;
    JLabel ipLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PortPane.label.port"));
    JTextField nameField = new JTextField();
    JLabel exampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PortPane.label.portExample"));
    String disallowCharacters = "`~!@#$^&()[]{}\\+=|:;\"'/<>,";
    RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(MAX_HOSTNAME_LENGTH, this.disallowCharacters.replace(".", ""), false);

    public PortPane(int padCharCount) {
        try {
            this.jbInit(padCharCount);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit(int padCount) throws Exception {
        this.ipLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PortPane.label.port"));
        this.nameField.setPreferredSize(new Dimension(165, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.exampleLabel.setPreferredSize(new Dimension(165, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.nameField.setDocument(this.nameDoc);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0 + padCount), 0, 0));
        this.add((Component)this.exampleLabel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 25, 0, 0), 0, 0));
        this.add((Component)this.ipLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, padCount), 0, 0));
        this.add((Component)this.nameField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
    }

    public String getText() {
        return this.nameField.getText();
    }

    public void setText(String text) {
        this.nameField.setText(text);
    }

    public boolean isValidValue() {
        String port = this.nameField.getText();
        if (port == null || port.trim().length() == 0) {
            return false;
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return Utility.isValidPort((String)port);
        }
        return this.nameField.isValid() && Utility.isValidPort((String)port);
    }

    @Override
    public void requestFocus() {
        this.nameField.requestFocus();
    }
}

