/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.configobject.schema.OS;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.OSInfoDropdownItemLoader;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SearchableComboBox;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OSPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    JTextField buildNumberField = new JTextField(20);
    JTextField versionFilterField = new JTextField(20);
    JLabel nameLabelBuildNumber;
    SearchableComboBox<DropdownItem> osTypeField = new SearchableComboBox<DropdownItem>(new Vector<DropdownItem>(Arrays.asList(OSInfoDropdownItemLoader.getInstance().loadValues())), false, true);
    ArchTypeComboBoxModel archComboModel = new ArchTypeComboBoxModel();
    JComboBox<?> archField = new JComboBox<ArchTypeComboBoxModel.ArchTypeComboBoxItem>(this.archComboModel);

    public OSPanel() {
        this.jbInit();
    }

    void jbInit() {
        RestrictedPlainDocument numberDoc = new RestrictedPlainDocument(255);
        numberDoc.setValidator("0123456789", true);
        this.buildNumberField.setDocument(numberDoc);
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        int rowIndex = 0;
        JLabel nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "OsVersionPane.label.OSName"));
        this.add((Component)nameLabel, new GridBagConstraints(0, rowIndex, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.osTypeField, new GridBagConstraints(1, rowIndex, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 22, 0));
        this.nameLabelBuildNumber = new JLabel(MSGRES.getString(POLICYDIALOG, "OsVersionPane.label.BuildNumber"));
        this.add((Component)this.nameLabelBuildNumber, new GridBagConstraints(0, ++rowIndex, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.buildNumberField, new GridBagConstraints(1, rowIndex, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 10, 0, 0), 22, 0));
        nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "OsVersionPane.label.Arch"));
        this.add((Component)nameLabel, new GridBagConstraints(0, ++rowIndex, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.archField, new GridBagConstraints(1, rowIndex, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 22, 0));
    }

    public OS getOS() {
        OS os = new OS();
        os.setOptArch(this.archComboModel.getSelectedArch());
        Integer n = this.getNumber(this.buildNumberField.getText());
        if (n != null) {
            os.setOptBuildNumber(n);
        }
        if (this.osTypeField.getSelectedItem() instanceof DropdownItem) {
            DropdownItem selectedOS = (DropdownItem)this.osTypeField.getSelectedItem();
            os.setOptName((String)selectedOS.getValue());
            return os;
        }
        return null;
    }

    private Integer getNumber(String v) {
        if (v == null || v.length() < 1) {
            return null;
        }
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void setOS(OS os) {
        Integer n = os.getOptArch();
        if (n != null) {
            this.archComboModel.setSelectedArch(n);
        } else {
            this.archComboModel.setSelectedArch(OS.ALL);
        }
        n = os.getOptBuildNumber();
        if (n != null) {
            this.buildNumberField.setText(n.toString());
        } else {
            this.buildNumberField.setText("");
        }
        this.updateOSName(os);
    }

    private void updateOSName(OS os) {
        String selectedOS = os.getOptName();
        if (selectedOS != null) {
            this.osTypeField.resetFilter();
            int count = this.osTypeField.getItemCount();
            for (int i = 0; i < count; ++i) {
                DropdownItem item = (DropdownItem)this.osTypeField.getItemAt(i);
                if (!selectedOS.equals(item.getValue())) continue;
                this.osTypeField.setSelectedIndex(i);
                break;
            }
        }
    }

    private static class ArchTypeComboBoxModel
    extends DefaultComboBoxModel<ArchTypeComboBoxItem> {
        private static final long serialVersionUID = 1L;
        private static final ArchTypeComboBoxItem[] USAGE = new ArchTypeComboBoxItem[]{new ArchTypeComboBoxItem(OS.ALL, MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "OsVersionPane.Arch.All")), new ArchTypeComboBoxItem(OS.X86, MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "OsVersionPane.Arch.X86")), new ArchTypeComboBoxItem(OS.X64, MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "OsVersionPane.Arch.X64"))};

        public ArchTypeComboBoxModel() {
            super(USAGE);
        }

        public Integer getSelectedArch() {
            return ((ArchTypeComboBoxItem)super.getSelectedItem()).type();
        }

        public void setSelectedArch(Integer n) {
            for (ArchTypeComboBoxItem item : USAGE) {
                if (!item.archType.equals(n)) continue;
                this.setSelectedItem(item);
                break;
            }
        }

        public static class ArchTypeComboBoxItem {
            private Integer archType;
            private String desc;

            public ArchTypeComboBoxItem(Integer usageType, String desc) {
                this.archType = usageType;
                this.desc = desc;
            }

            public String toString() {
                return this.desc;
            }

            public Integer type() {
                return this.archType;
            }
        }
    }
}

