/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.MacField;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MacPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    JLabel ipLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "MACPane.label.MacAddress"));
    JLabel exampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "MACPane.label.macExample"));
    JLabel vlanLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "MACPane.label.VLAN"));
    MacField macField;
    JTextField vlanField;

    public MacPane() {
        this(false, false);
    }

    public MacPane(boolean acceptWildChar, boolean isMab) {
        this.macField = new MacField(acceptWildChar);
        this.vlanField = new JTextField(10);
        try {
            this.jbInit(isMab);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit(boolean isMab) throws Exception {
        this.macField.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        if (isMab) {
            this.add((Component)this.exampleLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 20), 0, 0));
            this.add((Component)this.vlanLabel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 40, 0, 0), 0, 0));
            this.add((Component)this.macField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 22), 0, 0));
            this.add((Component)this.vlanField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 0), 0, 0));
        } else {
            this.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 20), 0, 0));
            this.add((Component)this.exampleLabel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 40, 0, 0), 0, 0));
            this.add((Component)this.macField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 0), 0, 0));
        }
    }

    public String getText() {
        return this.macField.getText();
    }

    public void setText(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.macField.setText(text);
    }

    public boolean isValidValue() {
        return this.macField.isValid();
    }

    @Override
    public void requestFocus() {
        this.macField.requestFocus();
    }

    public String getVLanText() {
        return this.vlanField.getText();
    }

    public void setVLanText(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.vlanField.setText(text);
    }

    public JTextField getVlanField() {
        return this.vlanField;
    }

    public void setVlanField(JTextField vlanField) {
        this.vlanField = vlanField;
    }
}

