/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LocationObject;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class LocListCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private static final long serialVersionUID = 1L;
    private Font normalFont;

    public LocListCellRenderer() {
        this.setOpaque(true);
        this.normalFont = this.getFont();
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        LocationObject locObj = (LocationObject)value;
        this.setText(locObj.getName());
        if (isSelected) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
            this.setForeground(UIManager.getColor("List.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("List.background"));
            this.setForeground(UIManager.getColor("List.foreground"));
        }
        if (locObj.isDefault()) {
            this.setText(locObj.getName() + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.defaultLocationIdentifier"));
        } else {
            this.setFont(this.normalFont);
        }
        return this;
    }
}

