/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.validator.routines.InetAddressValidator;

public class IpPaneGeneric
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(IpPaneGeneric.class.getName());
    JLabel ipLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.IPAddress"));
    JTextField ipField = new JTextField();
    JLabel exampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IpRangePane.label.ipExample"));
    private InetAddressValidator validator = InetAddressValidator.getInstance();

    public IpPaneGeneric() {
        try {
            this.jbInit(0);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "IpPaneGeneric -> IpPaneGeneric() : Exception occured while initilsing the panel");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public IpPaneGeneric(int padingCount, String exampleString) {
        this(padingCount);
        if (!StringUtilities.isEmpty((String)exampleString)) {
            this.exampleLabel.setText(exampleString);
        }
    }

    public IpPaneGeneric(int padingCount) {
        try {
            this.jbInit(padingCount);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit(int padingCount) throws Exception {
        this.ipField.setPreferredSize(new Dimension(165, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.exampleLabel.setPreferredSize(new Dimension(165, 22));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 20 + padingCount), 0, 0));
        this.add((Component)this.exampleLabel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 30, 0, 0), 0, 0));
        this.add((Component)this.ipLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 20 + padingCount), 0, 0));
        this.add((Component)this.ipField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
    }

    public String getText() {
        return this.ipField.getText();
    }

    public void setText(String text) {
        this.ipField.setText(text);
    }

    public boolean isValidValue() {
        return this.validator.isValid(this.ipField.getText());
    }

    @Override
    public void requestFocus() {
        this.ipField.requestFocus();
    }

    public void setLabel(String label) {
        this.ipLabel.setText(label);
    }

    @Override
    public void setEnabled(boolean flag) {
        this.ipField.setEnabled(flag);
        if (flag) {
            this.ipField.setBackground(UIColorUtilities.DEFAULT_BACKGROUND);
        } else {
            this.ipField.setBackground(UIColorUtilities.CONTROL_DISABLED_GRAYOUT_BACKGROUND);
        }
    }
}

