/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HostNamePane
extends JPanel {
    private static final long serialVersionUID = -8131039971366066792L;
    private static final int MAX_HOSTNAME_LENGTH = 255;
    private static final int DEFAULT_PREFERRED_WIDTH = 120;
    private boolean wildcardsAllowed = false;
    JLabel ipLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "HostNamePane.label.hostName"));
    JTextField nameField = new JTextField();
    JLabel exampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "HostNamePanel.label.hostNameExample"));
    String disallowCharacters = "`~!@#$^&()[]{}\\+=|:;\"'/<>,";
    RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(255, this.disallowCharacters.replace(".", ""), false);

    public HostNamePane() {
        try {
            this.jbInit(0, 0, 0, 120);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public HostNamePane(int labelPadingCount, int padingCount) {
        this.jbInit(this.ipLabel.getPreferredSize().width, labelPadingCount, padingCount, 120);
    }

    public HostNamePane(int preferredLabelWidth, int labelPadingCount, int padingCount, int preferredWidth, boolean wildcardsAllowed) {
        this.jbInit(preferredLabelWidth, labelPadingCount, padingCount, preferredWidth);
        this.wildcardsAllowed = wildcardsAllowed;
    }

    void jbInit(int preferredLabelWidth, int labelPadingCount, int padingCount, int preferredWidth) {
        if (preferredLabelWidth > 0) {
            this.ipLabel.setPreferredSize(new Dimension(preferredLabelWidth, this.ipLabel.getPreferredSize().height));
        }
        this.nameField.setPreferredSize(new Dimension(preferredWidth, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.nameField.setDocument(this.nameDoc);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 20 + labelPadingCount), 0, 0));
        this.add((Component)this.exampleLabel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 30 + padingCount, 0, 0), 0, 0));
        this.add((Component)this.ipLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 20 + labelPadingCount), 0, 0));
        this.add((Component)this.nameField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 30 + padingCount, 0, 0), 0, 0));
    }

    public String getText() {
        return this.nameField.getText();
    }

    public void setText(String text) {
        this.nameField.setText(text);
    }

    public boolean isValidValue() {
        String hostname = this.nameField.getText();
        if (hostname == null || hostname.trim().length() == 0) {
            return false;
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return Utility.isValidIPAddressOrHostName((String)hostname, (boolean)this.wildcardsAllowed);
        }
        return this.nameField.isValid() && Utility.isValidIPAddressOrHostName((String)hostname, (boolean)this.wildcardsAllowed);
    }

    @Override
    public void requestFocus() {
        this.nameField.requestFocus();
    }

    public void setPreferredFieldSize(int height, int width) {
        this.nameField.setPreferredSize(new Dimension(height, width));
        this.exampleLabel.setPreferredSize(new Dimension(height, width));
    }
}

