/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.HostGroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class HostGroupLinkPane
extends JPanel {
    private static final long serialVersionUID = 7909366770082889466L;
    private ArrayList<HostGroupObject> hostGroupList;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.common.common");
    private JComboBox<HostGroupObject> hostGroupSelector;
    private JTextPane hostGroupContent;

    public HostGroupLinkPane() {
        this.initUI();
        this.initData();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JLabel jl_hostGroup = new JLabel(this.res.getString("HostGroupLinkPane.lable_hostGroup"));
        this.hostGroupSelector = new JComboBox();
        this.hostGroupContent = new JTextPane();
        this.hostGroupSelector.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.hostGroupSelector.setRenderer(new ToolTipComboBoxRenderer());
        this.hostGroupSelector.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 5302974018516159578L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean size;
                StringBuffer buffer = new StringBuffer("");
                HostGroupObject item = (HostGroupObject)HostGroupLinkPane.this.hostGroupSelector.getSelectedItem();
                buffer.append("");
                boolean bl = size = item.getHostObjects().size() > 1;
                if (!size) {
                    for (HostObject s : item.getHostObjects()) {
                        buffer.append(s.getType() + ":\n  " + s.getContent());
                    }
                } else {
                    for (HostObject s : item.getHostObjects()) {
                        buffer.append(s.getType() + ":\n  " + s.getContent());
                        buffer.append("\n");
                    }
                }
                buffer.append("");
                HostGroupLinkPane.this.hostGroupContent.setText(buffer.toString());
            }
        });
        this.add((Component)jl_hostGroup, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add(this.hostGroupSelector, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 13, 2, new Insets(10, 40, 0, 0), 0, 0));
        JScrollPane jsp = new JScrollPane(this.hostGroupContent);
        jsp.setPreferredSize(new Dimension(120, 60));
        this.hostGroupContent.setBackground(this.getBackground());
        this.hostGroupContent.setOpaque(true);
        this.hostGroupContent.setFocusable(true);
        this.hostGroupContent.setEditable(false);
        this.hostGroupContent.setFont(jl_hostGroup.getFont());
        this.add((Component)new JLabel(this.res.getString("HostGroupLinkPane.lable_hostGroupContent")), new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 16, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)jsp, new GridBagConstraints(0, 3, 0, 2, 1.0, 0.0, 16, 2, new Insets(5, 15, 0, 0), 0, 0));
    }

    private void initData() {
        List<HostGroupObject> groups = this.getHostGroup();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.hostGroupSelector.getModel();
        for (HostGroupObject group : groups) {
            model.addElement(group);
        }
    }

    public HostGroupObject getSelectedHostGroup() {
        return (HostGroupObject)this.hostGroupSelector.getSelectedItem();
    }

    private List<HostGroupObject> getHostGroup() {
        if (this.hostGroupList == null) {
            this.hostGroupList = new ArrayList();
        } else {
            this.hostGroupList.clear();
        }
        try {
            ArrayList<HostGroupObject> list = HostGroupHandler.getInstance().getHostGroupsFromDB();
            for (int i = 0; i < list.size(); ++i) {
                HostGroupObject obj = list.get(i);
                this.hostGroupList.add(obj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.hostGroupList;
    }

    public boolean isValidValue() {
        return this.hostGroupSelector.getSelectedItem() != null;
    }

    public void setValue(FwNetworkHostGroup hostGroup) {
        for (HostGroupObject hostGroupObject : this.hostGroupList) {
            if (!hostGroupObject.getHostGroup().getName().equals(hostGroup.getName())) continue;
            this.hostGroupSelector.setSelectedItem(hostGroupObject);
            break;
        }
    }
}

