/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class FolderPrefixPanel
extends JPanel {
    private static final long serialVersionUID = 8305187497702832380L;
    private static final String scanAllDirsDisplay = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.text.scanDirsDisplay");
    private boolean isGlossaryMode;
    private JTable directoriesTable;
    private JTextArea selectedDirectories;
    private SortableTableModel model;
    private Hashtable<String, FolderData> directoryData;
    private boolean isSelectionEnabled = true;
    private String[] dirKeys;

    public FolderPrefixPanel(boolean isGlossaryMode) {
        this.isGlossaryMode = isGlossaryMode;
        this.dirKeys = ConstantValue.getDirKeys();
        this.createGUI();
    }

    public FolderPrefixPanel(boolean isGlossaryMode, String[] dirKeys) {
        this.isGlossaryMode = isGlossaryMode;
        this.dirKeys = dirKeys == null ? null : (String[])dirKeys.clone();
        this.createGUI();
    }

    public void setObject(String dirs) {
        String[] dirArray = dirs.split(";");
        this.updatePanel(dirArray);
        this.model.sortTable(1, true);
    }

    public String getObject() {
        StringBuffer selections = new StringBuffer();
        Enumeration<FolderData> elements = this.directoryData.elements();
        while (elements.hasMoreElements()) {
            FolderData data = elements.nextElement();
            if (!data.isSelected()) continue;
            selections.append(data.getName()).append(";");
        }
        return selections.toString();
    }

    public void enableFolderSelection(boolean isEnable) {
        this.isSelectionEnabled = isEnable;
        this.directoriesTable.setEnabled(this.isSelectionEnabled);
        if (isEnable) {
            this.updateSelectionsTextArea();
        } else {
            this.directoriesTable.clearSelection();
            this.selectedDirectories.setText(scanAllDirsDisplay);
        }
    }

    private void createGUI() {
        int tableHt;
        float[] fArray;
        this.directoryData = new Hashtable();
        for (int index = 1; index < this.dirKeys.length; ++index) {
            if (this.isGlossaryMode && StringUtilities.isEqual((String)this.dirKeys[index], (String)"[USER_PROFILE]")) {
                this.directoryData.put(this.dirKeys[index], new FolderData(false, this.dirKeys[index], this.getRes("USER_PROFILE_EXCEPTION")));
                continue;
            }
            this.directoryData.put(this.dirKeys[index], new FolderData(false, this.dirKeys[index], this.getRes(this.dirKeys[index].substring(1, this.dirKeys[index].length() - 1))));
        }
        this.model = new FolderTableModel();
        this.model.setColumnNames(new String[]{"", this.getRes("table.dirHeading"), this.getRes("table.descHeading")});
        this.model.setDataVector(new Vector<TableRow>(this.directoryData.values()));
        this.directoriesTable = new StripesTable(this.model, false, false);
        this.directoriesTable.getTableHeader().setReorderingAllowed(false);
        this.directoriesTable.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.directoriesTable.setDefaultRenderer(Object.class, new CellRenderer());
        this.directoriesTable.setDefaultRenderer(Boolean.class, new CellRenderer());
        JCheckBox firstCellEditor = new JCheckBox();
        firstCellEditor.setVerticalAlignment(1);
        this.directoriesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(firstCellEditor));
        this.model.addMouseListenerToHeaderInTable(this.directoriesTable);
        this.directoriesTable.getSelectionModel().setSelectionMode(0);
        if (this.isGlossaryMode) {
            float[] fArray2 = new float[2];
            fArray2[0] = 0.25f;
            fArray = fArray2;
            fArray2[1] = 0.75f;
        } else {
            float[] fArray3 = new float[3];
            fArray3[0] = 0.05f;
            fArray3[1] = 0.25f;
            fArray = fArray3;
            fArray3[2] = 0.7f;
        }
        float[] colWidth = fArray;
        UIUtilities.setTableColumnWidth(this.directoriesTable, colWidth, 800);
        if (this.isGlossaryMode) {
            this.directoriesTable.getTableHeader().setVisible(false);
        } else {
            this.selectedDirectories = new MultiLineLabel("");
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        if (!this.isGlossaryMode) {
            c.insets = new Insets(5, 10, 0, 0);
        }
        c.weightx = 1.0;
        c.weighty = 0.9;
        this.add((Component)new JScrollPane(this.directoriesTable), c);
        if (!this.isGlossaryMode) {
            c.fill = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.1;
            c.anchor = 18;
            this.add((Component)new JLabel(this.getRes("label.selectedDirs")), c);
            c.fill = 1;
            c.gridx = 1;
            c.weightx = 1.0;
            JScrollPane jSelectedDirectoriesPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)jSelectedDirectoriesPane, (JTextArea)this.selectedDirectories);
            this.add((Component)jSelectedDirectoriesPane, c);
        }
        tableHt = (tableHt = 42 * this.dirKeys.length) > 375 ? 375 : tableHt;
        this.setPreferredSize(new Dimension(800, tableHt));
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().appendJavaScript("setTimeout(function(){ $('." + this.getClass().getSimpleName() + "').click()}, 0)"));
    }

    private void updatePanel(String[] dirs) {
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].equals("[AllDrives]")) {
                return;
            }
            FolderData data = this.directoryData.get(dirs[i]);
            if (data == null) continue;
            data.setSelected(true);
        }
    }

    private void updateSelectionsTextArea() {
        this.selectedDirectories.setText(this.getObject());
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "DirectoryEditDialog." + key);
    }

    private class FolderData
    implements TableRow {
        private boolean isSelected;
        private String name;
        private String description;

        FolderData(boolean isSelected, String name, String description) {
            this.isSelected = isSelected;
            this.name = name;
            this.description = description;
        }

        boolean isSelected() {
            return this.isSelected;
        }

        void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        String getName() {
            return this.name;
        }

        @Override
        public Object getValueAt(int index) {
            Object value = null;
            switch (index) {
                case 0: {
                    value = FolderPrefixPanel.this.isGlossaryMode ? this.name : Boolean.valueOf(this.isSelected);
                    break;
                }
                case 1: {
                    value = FolderPrefixPanel.this.isGlossaryMode ? this.description : this.name;
                    break;
                }
                default: {
                    value = this.description;
                }
            }
            return value;
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int index) {
            if (index == 0) {
                this.setSelected((Boolean)value);
                FolderPrefixPanel.this.updateSelectionsTextArea();
            }
        }
    }

    private class CellRenderer
    implements TableCellRenderer {
        private JCheckBox checkBox = new JCheckBox();
        private MultiLineLabel multiLabel;
        private JLabel label;

        CellRenderer() {
            this.checkBox.setVerticalAlignment(1);
            this.multiLabel = new MultiLineLabel("");
            this.multiLabel.setEditable(false);
            this.multiLabel.setOpaque(true);
            this.label = new JLabel();
            this.label.setVerticalAlignment(1);
            this.label.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = null;
            component = column == 0 ? (FolderPrefixPanel.this.isGlossaryMode ? this.getLabel(value, table) : this.getCheckBox(value)) : (column == 1 ? (FolderPrefixPanel.this.isGlossaryMode ? this.getMultiLabel(value, table, row, column) : this.getLabel(value, table)) : this.getMultiLabel(value, table, row, column));
            if (isSelected) {
                component.setForeground(table.getSelectionForeground());
                component.setBackground(table.getSelectionBackground());
            } else {
                component.setForeground(table.getForeground());
                component.setBackground(table.getBackground());
            }
            component.setEnabled(FolderPrefixPanel.this.isSelectionEnabled);
            return component;
        }

        private Component getCheckBox(Object value) {
            this.checkBox.setSelected((Boolean)value);
            this.checkBox.putClientProperty("dynamicEventsEnabled", Boolean.TRUE);
            return this.checkBox;
        }

        private Component getLabel(Object value, JTable table) {
            String dirName = (String)value;
            this.label.setText(dirName.substring(1, dirName.length() - 1));
            Font font = table.getFont();
            int style = font.getStyle();
            float size = font.getSize();
            this.label.setFont(font.deriveFont(style | 1, size));
            return this.label;
        }

        private Component getMultiLabel(Object value, JTable table, int row, int column) {
            this.multiLabel.setText((String)value);
            this.multiLabel.setFont(table.getFont());
            int width = table.getColumnModel().getColumn(column).getWidth();
            this.multiLabel.setSize(width, (int)this.multiLabel.getPreferredSize().getHeight());
            int prefsize = (int)this.multiLabel.getPreferredSize().getHeight() + 10;
            if (prefsize != table.getRowHeight(row)) {
                table.setRowHeight(row, prefsize);
            }
            return this.multiLabel;
        }
    }

    private class FolderTableModel
    extends SortableTableModel {
        private static final long serialVersionUID = -7827055509947808514L;

        private FolderTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && !FolderPrefixPanel.this.isGlossaryMode;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 && !FolderPrefixPanel.this.isGlossaryMode ? Boolean.class : Object.class;
        }

        @Override
        public int getColumnCount() {
            return FolderPrefixPanel.this.isGlossaryMode ? 2 : 3;
        }
    }
}

