/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.LearnedAppTakerInt;
import com.sygate.scm.console.ui.policy.dialog.FindApplicationDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class FilePanelUIBase
extends JPanel
implements LearnedAppTakerInt {
    private static final long serialVersionUID = -1L;
    private static final String WIN_NAME_PATH = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.label.windows.FileNameAndPath");
    private static final String MAC_NAME_PATH = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.label.mac.FileNameAndPath");
    private JTextField jTFName = new JTextField(10);
    private JButton jBLearn = new JButton(UIText.get(2816));
    private boolean allowWildChar = false;

    public FilePanelUIBase(boolean allowWildChar) {
        this.allowWildChar = allowWildChar;
    }

    @Override
    public int addLearnedApplication(LearnedApplicationObject[] allApps) {
        int length = allApps.length;
        if (length > 0) {
            String fileName = allApps[length - 1].getAppName();
            String filePath = (String)allApps[length - 1].getValueAt(1);
            this.jTFName.setText(this.getFileFullName(fileName, filePath));
            this.setFileFeature(allApps[length - 1]);
        }
        return length;
    }

    protected abstract String getFilePanelDesc();

    protected abstract JComponent getFeaturePanel();

    protected abstract void updatePanel();

    protected abstract void validateFeaturePanel() throws GUICheckException;

    protected abstract void saveFileName(String var1);

    protected abstract void setFileFeature(LearnedApplicationObject var1);

    protected void initialize(String clientType) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(clientType), "North");
    }

    protected void learnApplication() {
        FindApplicationDlg dlg = new FindApplicationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.title.Application.Filter"), true);
        dlg.setLearnedAppTaker(this);
        dlg.main.setButtonsEnabled(false);
        dlg.setVisible(true);
    }

    protected void updateFileName(String fileName) {
        this.jTFName.setText(fileName);
    }

    public boolean validateInput() throws GUICheckException {
        String fileName = this.getSafeText(this.jTFName);
        if (fileName.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.error.EmptyFileName"), this.jTFName);
        }
        try {
            File f = new File(fileName);
            f.getCanonicalPath();
        }
        catch (IOException ioe) {
            ConsoleLogger.log("The file path [" + fileName + "] in " + this.getClass().getName() + " cannot be validated. Make sure it's a valid file path.");
        }
        if (!Utility.isValidEnvVariableOrRegValueInput((String)fileName, (boolean)false) || !this.isValidRegistryValue(fileName)) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.error.InvalidEnvVarsOrRegVals"), this.jTFName);
        }
        this.validateFeaturePanel();
        this.saveFileName(fileName);
        return true;
    }

    private JPanel getInnerPanel(String clientType) {
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(256);
        nameDoc.setValidator(this.allowWildChar ? "\"<>|" : "\"<>*?|", false);
        this.jTFName.setDocument(nameDoc);
        this.jBLearn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePanelUIBase.this.learnApplication();
            }
        });
        DescriptionTextArea desc = null;
        AttributedTextArea aTextArea1 = null;
        AttributedTextArea aTextArea2 = null;
        JPanel panel = new JPanel(new GridBagLayout());
        if (!clientType.equalsIgnoreCase("Mac")) {
            desc = new DescriptionTextArea(WIN_NAME_PATH);
            aTextArea1 = new AttributedTextArea("%WINDIR%\\cmd.exe ", MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.ExplainPath"));
            aTextArea2 = new AttributedTextArea("#HKEY_LOCAL_MACHINE\\Software\\Symantec\\\\AppPath#\\sem.exe ", MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.ExplainValue"));
            if (LicenseObject.getInstance().isFirewallPolicy()) {
                panel.add((Component)this.jBLearn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            panel.add((Component)this.getLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.Example1")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)aTextArea1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FilePanelBase.Example2")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)aTextArea2, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            desc = new DescriptionTextArea(MAC_NAME_PATH);
        }
        desc.setPreferredSize(desc.getPreferredSize());
        JComponent featurePanel = this.getFeaturePanel();
        panel.add((Component)new JLabel(this.getFilePanelDesc()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)desc, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (featurePanel != null) {
            panel.add((Component)featurePanel, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    private String getFileFullName(String fileName, String filePath) {
        Object fullName = "";
        if (filePath != null && filePath.length() != 0) {
            fullName = filePath + "\\";
        }
        if (fileName != null && fileName.length() != 0) {
            fullName = (String)fullName + fileName;
        }
        return fullName;
    }

    protected boolean isValidRegistryValue(String fileName) {
        String[] regStrings;
        while ((regStrings = fileName.split("#", 3)).length == 3) {
            String[] regs = regStrings[1].split("\\\\");
            if (regs.length == 0) {
                return false;
            }
            if (!regs[regs.length - 2].equals("") && !regStrings[1].endsWith("\\\\")) {
                return false;
            }
            fileName = regStrings[2];
        }
        return true;
    }

    private String getSafeText(JTextField field) {
        String txt = field.getText();
        return txt == null ? "" : txt.trim();
    }

    private class AttributedTextArea
    extends JTextPane {
        private static final long serialVersionUID = 6900598111368647767L;
        private DefaultStyledDocument document = new DefaultStyledDocument();
        private DescriptionTextArea textArea;

        public AttributedTextArea(String blueText, String blackText) {
            this.textArea = new DescriptionTextArea(blueText + blackText);
            this.setDocument(this.document);
            this.setEditable(false);
            this.setBackground(FilePanelUIBase.this.getBackground());
            this.append(blueText, Color.BLUE);
            this.append(blackText, Color.BLACK);
        }

        private void append(String string, Color color) {
            try {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, color);
                this.document.insertString(this.document.getLength(), string, attr);
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.textArea.getPreferredSize();
        }
    }
}

