/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileLastModifiedPanel
extends JPanel {
    private static final long serialVersionUID = -2750354930328717893L;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.common.common");
    private JLabel yearLabel = new JLabel(this.res.getString("FileLastModifiedPanel.Label.year"));
    private JTextField yearField = new JTextField();
    private JLabel monLabel = new JLabel(this.res.getString("FileLastModifiedPanel.Label.month"));
    private JTextField monField = new JTextField();
    private JLabel dayLabel = new JLabel(this.res.getString("FileLastModifiedPanel.Label.day"));
    private JTextField dayField = new JTextField();
    private String lastModifyText = "";

    public FileLastModifiedPanel() {
        this.setLayout(new BoxLayout(this, 2));
        int height = this.yearField.getPreferredSize().height;
        RestrictedPlainDocument yearDoc = new RestrictedPlainDocument(4);
        yearDoc.setValidator("0123456789*", true);
        this.yearField.setDocument(yearDoc);
        this.yearField.setPreferredSize(new Dimension(60, height));
        RestrictedPlainDocument monDoc = new RestrictedPlainDocument(2);
        monDoc.setValidator("0123456789*", true);
        this.monField.setDocument(monDoc);
        this.monField.setPreferredSize(new Dimension(30, height));
        RestrictedPlainDocument dayDoc = new RestrictedPlainDocument(2);
        dayDoc.setValidator("0123456789*", true);
        this.dayField.setDocument(dayDoc);
        this.dayField.setPreferredSize(new Dimension(30, height));
        JPanel yearPanel = new JPanel(new GridBagLayout());
        yearPanel.add((Component)this.yearLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        yearPanel.add((Component)this.yearField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 2), 0, 0));
        this.add(yearPanel);
        JPanel monPanel = new JPanel(new GridBagLayout());
        monPanel.add((Component)this.monLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        monPanel.add((Component)this.monField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 2), 0, 0));
        this.add(monPanel);
        JPanel dayPanel = new JPanel(new GridBagLayout());
        dayPanel.add((Component)this.dayLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        dayPanel.add((Component)this.dayField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(dayPanel);
    }

    public String getLastModifiedDate() {
        return this.lastModifyText;
    }

    public void checkLastModifiedDate() throws GUICheckException {
        String year = this.yearField.getText();
        String mon = this.monField.getText();
        String day = this.dayField.getText();
        boolean isYearInput = true;
        boolean isMonInput = true;
        boolean isDayInput = true;
        if (year != null && year.trim().equals("*") && mon != null && mon.trim().equals("*") && day != null && day.trim().equals("*")) {
            throw new GUICheckException(this.res.getString("FileLastModifiedPanel.Error.inputAllorNothing"), this.yearField);
        }
        if (year == null || year.trim().equals("")) {
            isYearInput = false;
        }
        if (mon == null || mon.trim().equals("")) {
            isMonInput = false;
        }
        if (day == null || day.trim().equals("")) {
            isDayInput = false;
        }
        if (isYearInput && !isMonInput && !isDayInput) {
            mon = "*";
            day = "*";
            isMonInput = true;
            isDayInput = true;
        } else if (!isYearInput && isMonInput && !isDayInput) {
            year = "*";
            day = "*";
            isYearInput = true;
            isDayInput = true;
        } else if (!isYearInput && !isMonInput && isDayInput) {
            year = "*";
            mon = "*";
            isYearInput = true;
            isMonInput = true;
        }
        if (isYearInput) {
            if (isMonInput && isDayInput) {
                try {
                    int y;
                    if (!(year.trim().equals("*") || (y = Integer.parseInt(year)) >= 1000 && y <= 9999)) {
                        String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationYear"), year);
                        throw new GUICheckException(error, this.yearField);
                    }
                }
                catch (NumberFormatException ex) {
                    String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationYear"), year);
                    throw new GUICheckException(error, this.yearField);
                }
                try {
                    int m;
                    if (!(mon.trim().equals("*") || (m = Integer.parseInt(mon)) >= 1 && m <= 12)) {
                        String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationMonth"), mon);
                        throw new GUICheckException(error, this.monField);
                    }
                }
                catch (NumberFormatException ex) {
                    String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationMonth"), mon);
                    throw new GUICheckException(error, this.monField);
                }
                try {
                    int d;
                    if (!(day.trim().equals("*") || (d = Integer.parseInt(day)) >= 1 && d <= 31)) {
                        String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationDay"), day);
                        throw new GUICheckException(error, this.dayField);
                    }
                }
                catch (NumberFormatException ex) {
                    String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationDay"), day);
                    throw new GUICheckException(error, this.dayField);
                }
                GregorianCalendar gcDate = new GregorianCalendar();
                if (!(year.trim().equals("*") || mon.trim().equals("*") || day.trim().equals("*"))) {
                    gcDate.clear();
                    gcDate.set(Integer.parseInt(year), Integer.parseInt(mon) - 1, Integer.parseInt(day));
                    gcDate.setLenient(false);
                    try {
                        gcDate.get(5);
                    }
                    catch (Exception e) {
                        String error = MessageFormat.format(this.res.getString("FileLastModifiedPanel.Error.ValidationDate"), day);
                        throw new GUICheckException(error, this.dayField);
                    }
                }
                this.lastModifyText = new StringBuffer().append(mon).append("/").append(day).append("/").append(year).toString();
                return;
            }
            throw new GUICheckException(this.res.getString("FileLastModifiedPanel.Error.inputAllorNothing"), this.yearField);
        }
        if (isMonInput || isDayInput) {
            throw new GUICheckException(this.res.getString("FileLastModifiedPanel.Error.inputAllorNothing"), this.yearField);
        }
    }

    public void setLastModifiedDate(String date) {
        if (date == null || "".equals(date)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(date, "/");
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i == 0) {
                this.monField.setText(st.nextToken());
            } else if (i == 1) {
                this.dayField.setText(st.nextToken());
            } else if (i == 2) {
                this.yearField.setText(st.nextToken());
            }
            ++i;
        }
    }
}

