/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIFontUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ExpandingTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String text;
    private boolean selected;
    private static final int YPAD = 5;
    private static final int XPAD = 20;
    private boolean visible = false;
    private boolean isExpanded = false;

    public ExpandingTabPanel(String text, MouseListener ml, Boolean isVisible, boolean isExpanded) {
        this.text = text;
        this.visible = isVisible;
        this.isExpanded = isExpanded;
        this.addMouseListener(ml);
        this.selected = false;
        this.setPreferredSize(new Dimension(200, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.putClientProperty("cssClass", "expandingTabPanel");
        this.setRequestFocusEnabled(true);
    }

    public void toggleSelection() {
        this.selected = !this.selected;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int h = this.getHeight();
        if (this.selected) {
            g2.drawImage(CustomLookAndFeel.UP_ARROW_IMAGE, this.getWidth() - 20, 5, this);
        } else {
            g2.drawImage(CustomLookAndFeel.DOWN_ARROW_IMAGE, this.getWidth() - 20, 5, this);
        }
        g2.setFont(UIFontUtilities.TITLE_FONT);
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lm = UIFontUtilities.TITLE_FONT.getLineMetrics(this.text, frc);
        float height = lm.getAscent() + lm.getDescent();
        float y = ((float)h + height) / 2.0f - lm.getDescent();
        g2.drawString(this.text, 0.0f, y);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }
}

