/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.util.LoggerUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    JButton[] buttonList;
    int alignment;
    boolean isVertical;
    boolean isLeadPaddingRequired = true;
    private int hspacing = 3;

    public ButtonPane(JButton[] buttons, int align) {
        try {
            this.buttonList = buttons == null ? null : (JButton[])buttons.clone();
            this.alignment = align;
            this.isVertical = false;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public ButtonPane(JButton[] buttons, int align, int hspacing) {
        try {
            this.buttonList = buttons == null ? null : (JButton[])buttons.clone();
            this.alignment = align;
            this.isVertical = false;
            this.hspacing = hspacing;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public ButtonPane(JButton[] buttons, boolean isVertical) {
        try {
            this.buttonList = buttons == null ? null : (JButton[])buttons.clone();
            this.alignment = -1;
            this.isVertical = isVertical;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public ButtonPane(JButton[] buttons, boolean isVertical, boolean isLeadPaddingRequired) {
        try {
            this.buttonList = buttons == null ? null : (JButton[])buttons.clone();
            this.alignment = -1;
            this.isVertical = isVertical;
            this.isLeadPaddingRequired = isLeadPaddingRequired;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public ButtonPane(JButton[] buttons, boolean isVertical, int align) {
        try {
            this.buttonList = buttons == null ? null : (JButton[])buttons.clone();
            this.alignment = align;
            this.isVertical = isVertical;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit() throws Exception {
        if (this.isVertical) {
            this.setLayout(new BoxLayout(this, 1));
        } else if (this.alignment == 2) {
            this.setLayout(new BoxLayout(this, 0));
        } else if (this.alignment != -1) {
            FlowLayout f = (FlowLayout)this.getLayout();
            f.setAlignment(this.alignment);
        }
        double maxLen = 0.0;
        double maxHeight = 0.0;
        Dimension vertical_space = new Dimension(0, 10);
        if (this.isVertical && this.isLeadPaddingRequired) {
            this.add(Box.createRigidArea(vertical_space));
        }
        for (int i = 0; i < this.buttonList.length; ++i) {
            if (i > 0) {
                if (!this.isVertical) {
                    if (this.hspacing != 0) {
                        this.add(Box.createRigidArea(new Dimension(this.hspacing, 0)));
                    }
                } else {
                    this.add(Box.createRigidArea(vertical_space));
                }
            }
            this.add(this.buttonList[i]);
            Dimension pDem = this.buttonList[i].getPreferredSize();
            maxLen = Math.max(maxLen, pDem.getWidth());
            maxHeight = Math.max(maxHeight, pDem.getHeight());
        }
        if (this.isVertical) {
            this.add(Box.createRigidArea(vertical_space));
        }
        Dimension newDem = new Dimension((int)maxLen, (int)maxHeight);
        for (int i = 0; i < this.buttonList.length; ++i) {
            this.buttonList[i].setPreferredSize(newDem);
            this.buttonList[i].setMaximumSize(newDem);
            this.buttonList[i].setMinimumSize(newDem);
        }
    }
}

