/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.explorer.common.LocationCheckBoxTree;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ApplyToDialog
extends DialogBase
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private LocationCheckBoxTree locationTree;

    public ApplyToDialog(String title, LocationCheckBoxTree locTree) {
        super(Manager.getFrame(), title, true);
        this.getGroupsAndLocations(locTree);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_private_copy";
    }

    @Override
    protected String getOkButtonText() {
        return UIText.get(3584);
    }

    private void initialize() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.getTreePanel(), "Center");
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JPanel getTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane jsPane = new JScrollPane(this.locationTree);
        jsPane.setPreferredSize(new Dimension(400, 200));
        panel.add((Component)jsPane, "Center");
        return panel;
    }

    private void getGroupsAndLocations(LocationCheckBoxTree locTree) {
        this.locationTree = locTree;
        String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.loadingMsg");
        this.locationTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(text)));
        SwingWorker worker = new SwingWorker(){
            private Exception exception = null;
            private TreeModel treeModel = null;

            public Object construct() {
                try {
                    this.treeModel = ApplyToDialog.this.getLocationTreeModel();
                }
                catch (Exception e) {
                    ConsoleLogger.log(e);
                    this.exception = e;
                }
                return null;
            }

            public void finished() {
                if (this.exception != null) {
                    LoggerUtilities.logException((Throwable)this.exception);
                    return;
                }
                ApplyToDialog.this.locationTree.setModel(this.treeModel);
                ApplyToDialog.this.locationTree.setShowsRootHandles(true);
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
            }
        };
        worker.start();
    }

    private TreeModel getLocationTreeModel() {
        try {
            DefaultMutableTreeNode parentNode = null;
            parentNode = PolicyHandler.getGroupLocationTree(true);
            return new DefaultTreeModel(parentNode);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
            return null;
        }
    }
}

