/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.submission;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class QuarantineItemSubmissionPanel
extends AvTemplatePane {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String SUBMISSION = "com.sygate.scm.console.ui.policy.av.submission.avsubmission";
    private static final String[] PROTOCOLS = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.av.submission.avsubmission", "SubmissionPane.combobox.ip"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.submission.avsubmission", "SubmissionPane.combobox.spx")};
    public static final String title = MSGRES.getString("com.sygate.scm.console.ui.policy.av.submission.avsubmission", "SubmissionPane.label.quarantineTitle");
    public static final String desc = MSGRES.getString("com.sygate.scm.console.ui.policy.av.submission.avsubmission", "SubmissionPane.label.quarantineDesc");
    private JPanel quarantinePane;
    private JCheckBox jCbxQServer;
    private JTextField jTFServer;
    private JTextField jTFPort;
    private JSpinner jSpnRetry;
    private JComboBox<String> jCmbProtocol;
    private JLabel jLServer;
    private JLabel jLPort;
    private JLabel jLRetry;
    private JLabel jLSecond;
    private JLabel jLProtocol;

    public QuarantineItemSubmissionPanel() {
        super(title, desc);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.getQuarantinePane());
        this.add(panel);
    }

    private JPanel getQuarantinePane() {
        if (this.quarantinePane == null) {
            this.jCbxQServer = new JCheckBox(MSGRES.getString(SUBMISSION, "SubmissionPane.checkbox.qserver"));
            this.jCbxQServer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuarantineItemSubmissionPanel.this.quarantineServerChanged();
                }
            });
            this.jLServer = new JLabel(MSGRES.getString(SUBMISSION, "SubmissionPane.label.server"));
            this.jLPort = new JLabel(MSGRES.getString(SUBMISSION, "SubmissionPane.label.port"));
            this.jLRetry = new JLabel(MSGRES.getString(SUBMISSION, "SubmissionPane.label.retry"));
            this.jLSecond = new JLabel(MSGRES.getString(SUBMISSION, "SubmissionPane.label.seconds"));
            this.jLProtocol = new JLabel(MSGRES.getString(SUBMISSION, "SubmissionPane.label.protocol"));
            this.jTFServer = new JTextField(40);
            this.jTFPort = new JTextField(6);
            this.jTFPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jSpnRetry = new JSpinner(new SpinnerNumberModel(600, 100, 600, 10));
            UIUtilities.enableOnlyValidEdits(this.jSpnRetry);
            this.jCmbProtocol = new JComboBox<String>(new DefaultComboBoxModel<String>(PROTOCOLS));
            Dimension size = this.jCmbProtocol.getPreferredSize();
            this.jCmbProtocol.setPreferredSize(new Dimension(size.width + 20, size.height));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.jCbxQServer, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)this.jLServer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 25, 0, 0), 0, 0));
            panel.add((Component)this.jTFServer, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
            panel.add((Component)this.jLPort, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
            panel.add((Component)this.jTFPort, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
            panel.add((Component)this.jLRetry, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 25, 0, 0), 0, 0));
            panel.add((Component)this.jSpnRetry, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
            panel.add((Component)this.jLSecond, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
            this.quarantinePane = new JPanel(new FlowLayout(0));
            this.quarantinePane.add(panel);
        }
        return this.quarantinePane;
    }

    private void quarantineServerChanged() {
        boolean enable = this.jCbxQServer.isSelected();
        this.jTFServer.setEnabled(enable);
        this.jTFPort.setEnabled(enable);
        this.jSpnRetry.setEnabled(enable);
        this.jCmbProtocol.setEnabled(enable);
        this.jLServer.setEnabled(enable);
        this.jLPort.setEnabled(enable);
        this.jLRetry.setEnabled(enable);
        this.jLSecond.setEnabled(enable);
        this.jLProtocol.setEnabled(enable);
    }

    public boolean valuesValid() {
        if (this.jCbxQServer.isSelected()) {
            if (this.jTFServer.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.serverName.msg"), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.title"), 0);
                return false;
            }
            if (this.jTFServer.getText().indexOf("\\n") > -1 || this.jTFServer.getText().indexOf("\\r") > -1) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.serverName.invalid"), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.title"), 0);
                return false;
            }
            String port = this.jTFPort.getText().trim();
            if (port.length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.port.msg"), MSGRES.getString(SUBMISSION, "SubmissionPane.dialog.error.title"), 0);
                return false;
            }
        }
        return true;
    }

    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_submission";
    }
}

