/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.quarantine;

import com.sygate.scm.common.configobject.schema.AvQuarantine;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.FolderFilter;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.AvQuarantineObject;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class QuarantinePane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String QUARANTINE = "com.sygate.scm.console.ui.policy.av.quarantine.avquarantine";
    private AvTemplatePane optionsPane;
    private AvTemplatePane directoryPane;
    private AvTemplatePane managementPane;
    private JRadioButton autoRepairRBtn;
    private JRadioButton repairWithoutRestoreRBtn;
    private JRadioButton promptRBtn;
    private JRadioButton doNothingRBtn;
    private JRadioButton jRBDefaultDirectory;
    private JRadioButton jRBLocalDirectory;
    private JTextField jTFDirectory;
    private JButton jBBrowse;
    private JCheckBox allowUserManageQuarantinedFilesChk;
    private AvQuarantineObject avQuarantineObj;

    public QuarantinePane() {
        this.initGUI();
    }

    public void setQuarantineObject(AvQuarantine avQ) {
        this.avQuarantineObj = new AvQuarantineObject(avQ);
        this.updatePanel();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_quarantine";
    }

    public boolean valuesValid() {
        if (this.jRBLocalDirectory.isSelected() && this.jTFDirectory.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.error.msg"), MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.error.title"), 0);
            return false;
        }
        return true;
    }

    private void initGUI() {
        VerticalFlowLayout layout = new VerticalFlowLayout();
        this.setLayout(layout);
        JPanel optPane = this.getOptionsPane();
        optPane.addHierarchyListener(new HierarchyListenerImpl());
        this.add(optPane);
        this.add(this.getDirectoryPane());
        this.managementPane = this.getManagementPane();
        this.add(this.managementPane);
    }

    private JPanel getOptionsPane() {
        if (this.optionsPane == null) {
            String title = MSGRES.getString(QUARANTINE, "QuarantineTab.label.options");
            String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.label.optionsDesc");
            this.optionsPane = new AvTemplatePane(title, desc);
            this.autoRepairRBtn = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.autoRepairSilently"));
            this.autoRepairRBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    QuarantinePane.this.autoRepairRBtn.setFocusPainted(true);
                }
            });
            this.repairWithoutRestoreRBtn = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.repairWithoutRestore"));
            this.promptRBtn = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.promptUser"));
            this.doNothingRBtn = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.doNothing"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.autoRepairRBtn);
            group.add(this.repairWithoutRestoreRBtn);
            group.add(this.promptRBtn);
            group.add(this.doNothingRBtn);
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)this.autoRepairRBtn, c);
            c.gridx = 0;
            c.gridy = 1;
            pane.add((Component)this.repairWithoutRestoreRBtn, c);
            c.gridx = 0;
            c.gridy = 2;
            pane.add((Component)this.promptRBtn, c);
            c.gridx = 0;
            c.gridy = 3;
            pane.add((Component)this.doNothingRBtn, c);
            pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)pane, "Before");
            this.optionsPane.add(p);
        }
        return this.optionsPane;
    }

    private JPanel getDirectoryPane() {
        if (this.directoryPane == null) {
            String title = MSGRES.getString(QUARANTINE, "QuarantineTab.label.directory");
            String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.label.directoryDesc");
            this.directoryPane = new AvTemplatePane(title, desc);
            this.jRBDefaultDirectory = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.defaultDirectory"));
            this.jRBLocalDirectory = new JRadioButton(MSGRES.getString(QUARANTINE, "QuarantineTab.radio.localDirectory"));
            this.jRBLocalDirectory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        QuarantinePane.this.jBBrowse.setEnabled(false);
                        QuarantinePane.this.jTFDirectory.setEnabled(false);
                    }
                    if (e.getStateChange() == 1) {
                        QuarantinePane.this.jBBrowse.setEnabled(true);
                        QuarantinePane.this.jTFDirectory.setEnabled(true);
                    }
                }
            });
            this.jTFDirectory = new JTextField(40);
            this.jBBrowse = new JButton(UIText.get(257));
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.putClientProperty("ajaxswing.browseClient", false);
                    fc.setApproveButtonText(UIText.get(3584));
                    fc.setDialogTitle(MSGRES.getString(QuarantinePane.QUARANTINE, "QuarantineTab.selectDirectory"));
                    fc.setFileFilter((FileFilter)new FolderFilter());
                    fc.setFileSelectionMode(2);
                    ((BasicFileChooserUI)fc.getUI()).setFileName(fc.getCurrentDirectory().getAbsolutePath());
                    fc.setAcceptAllFileFilterUsed(false);
                    if (0 != fc.showOpenDialog(Manager.getFrame())) {
                        return;
                    }
                    if (fc.getSelectedFile() == null) {
                        return;
                    }
                    QuarantinePane.this.jTFDirectory.setText(fc.getSelectedFile().getAbsolutePath());
                }
            });
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.jBBrowse.setVisible(false));
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRBDefaultDirectory);
            group.add(this.jRBLocalDirectory);
            this.allowUserManageQuarantinedFilesChk = new JCheckBox(MSGRES.getString(QUARANTINE, "QuarantineTab.checkbox.allowUserManageQuarantinedFiles"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.jRBDefaultDirectory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBLocalDirectory, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            JPanel browsePanel = new JPanel();
            browsePanel.add(this.jTFDirectory);
            browsePanel.add(this.jBBrowse);
            panel.add((Component)browsePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)panel, "Before");
            this.directoryPane.add(p);
        }
        return this.directoryPane;
    }

    private AvTemplatePane getManagementPane() {
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.label.management");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.label.managementDesc");
        AvTemplatePane pane = new AvTemplatePane(title, desc);
        this.allowUserManageQuarantinedFilesChk = new JCheckBox(MSGRES.getString(QUARANTINE, "QuarantineTab.checkbox.allowUserManageQuarantinedFiles"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.allowUserManageQuarantinedFilesChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)panel, "Before");
        pane.add(p);
        return pane;
    }

    private void updatePanel() {
        int arriveAction = this.avQuarantineObj.getNewVirusDefArriveAction();
        if (arriveAction == AvQuarantine.REPAIR_WITHOUT_RESTORE) {
            this.repairWithoutRestoreRBtn.setSelected(true);
        } else if (arriveAction == AvQuarantine.PROMPT) {
            this.promptRBtn.setSelected(true);
        } else if (arriveAction == AvQuarantine.DO_NOTHING) {
            this.doNothingRBtn.setSelected(true);
        } else {
            this.autoRepairRBtn.setSelected(true);
        }
        boolean isUseDefaultDir = this.avQuarantineObj.isUseDefaultDirectory();
        this.jRBDefaultDirectory.setSelected(isUseDefaultDir);
        this.jRBLocalDirectory.setSelected(!isUseDefaultDir);
        this.jTFDirectory.setText(this.avQuarantineObj.getQuarantineDirectory());
        this.jTFDirectory.setEnabled(!isUseDefaultDir);
        this.jBBrowse.setEnabled(!isUseDefaultDir);
        this.allowUserManageQuarantinedFilesChk.setSelected(this.avQuarantineObj.isUserAllowedManageQuarantinedFiles());
    }

    public void save() {
        int newDefAction = AvQuarantine.REPAIR_AND_RESTORE;
        if (this.repairWithoutRestoreRBtn.isSelected()) {
            newDefAction = AvQuarantine.REPAIR_WITHOUT_RESTORE;
        } else if (this.promptRBtn.isSelected()) {
            newDefAction = AvQuarantine.PROMPT;
        } else if (this.doNothingRBtn.isSelected()) {
            newDefAction = AvQuarantine.DO_NOTHING;
        }
        this.avQuarantineObj.setNewVirusDefArriveAction(newDefAction);
        this.avQuarantineObj.setUseDefaultDirectory(this.jRBDefaultDirectory.isSelected());
        this.avQuarantineObj.setQuarantineDirectory(this.jTFDirectory.getText().trim());
        this.avQuarantineObj.setAllowUserManageQuarantinedFiles(this.allowUserManageQuarantinedFilesChk.isSelected());
    }
}

