/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.quarantine;

import com.sygate.scm.common.configobject.schema.AvQuarantine;
import com.sygate.scm.common.configobject.schema.CleanupOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.logicobject.AvQuarantineObject;
import com.sygate.scm.console.ui.policy.av.quarantine.CleanupPane;
import com.sygate.scm.console.ui.policy.av.quarantine.QuarantinePane;
import com.sygate.scm.console.ui.util.UIUtilities;
import javax.swing.JTabbedPane;

public class QuarantineInfoPane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private QuarantinePane quarantinePane;
    private CleanupPane cleanupPane;
    private AvQuarantine avQuarantine;
    private AvQuarantineObject avQuarantineObj;

    public QuarantineInfoPane() {
        this.init();
    }

    public void setQuarantineObject(AvQuarantine avQurt) {
        if (avQurt == null) {
            avQurt = new AvQuarantine();
            avQurt.setOptCleanupOptions(new CleanupOptions());
        }
        this.avQuarantine = avQurt;
        this.avQuarantineObj = new AvQuarantineObject(this.avQuarantine);
        this.updateValues();
    }

    public void save() {
        this.quarantinePane.save();
        this.cleanupPane.save();
        this.avQuarantine.setOptCleanupOptions(this.cleanupPane.getCleanupOptions());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    public boolean valuesValid() {
        return this.quarantinePane.valuesValid();
    }

    private void init() {
        this.quarantinePane = new QuarantinePane();
        this.cleanupPane = new CleanupPane();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.quarantine.avquarantine", "QuarantineTab.title.quarantine"), UIUtilities.createScrollPaneWithoutBoard(this.quarantinePane));
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.quarantine.avquarantine", "QuarantineTab.title.cleanup"), UIUtilities.createScrollPaneWithoutBoard(this.cleanupPane));
    }

    private void updateValues() {
        this.quarantinePane.setQuarantineObject(this.avQuarantine);
        this.cleanupPane.setObject(this.avQuarantineObj.getCleanupOptions());
    }
}

