/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.quarantine;

import com.sygate.scm.common.configobject.schema.CleanupOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.NumberPlainDocument;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.CleanupOptionsObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Document;

public class CleanupPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String QUARANTINE = "com.sygate.scm.console.ui.policy.av.quarantine.avquarantine";
    private PurgePanel jPRepair;
    private PurgePanel jPBackup;
    private PurgePanel jPQuarantine;
    private CleanupOptionsObject optionsObj;

    public CleanupPane() {
        this.initGUI();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_quarantine_clean_up";
    }

    private void initGUI() {
        this.setLayout(new VerticalFlowLayout());
        this.add(this.createRepairPane());
        this.add(this.createBackupPane());
        this.add(this.createQuarantinePane());
    }

    private JPanel createRepairPane() {
        this.jPRepair = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.repairedEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.repaired");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.repairedDesc");
        this.jPRepair.addHierarchyListener(new HierarchyListenerImpl());
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPRepair);
        return panel;
    }

    private JPanel createBackupPane() {
        this.jPBackup = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.backedupEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.backedup");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.backedupDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPBackup);
        return panel;
    }

    private JPanel createQuarantinePane() {
        this.jPQuarantine = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.quarantineEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.quarantine");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.quarantineDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPQuarantine);
        return panel;
    }

    private void updatePanel() {
        this.jPRepair.setValue(this.optionsObj.getAutoPurgeRepairedFiles(), this.optionsObj.getPurgeRepairFilesAfter(), this.optionsObj.isEnablePurgeRepairedFilesSize(), this.optionsObj.getPurgeRepairedFilesSize());
        this.jPBackup.setValue(this.optionsObj.getAutoPurgeBackupFiles(), this.optionsObj.getPurgeBackupFilesAfter(), this.optionsObj.isEnablePurgeBackupFilesSize(), this.optionsObj.getPurgeBackupFilesSize());
        this.jPQuarantine.setValue(this.optionsObj.getAutoPurgeQuarantinedFiles(), this.optionsObj.getPurgeQuarantinedFilesAfter(), this.optionsObj.isEnablePurgeQuarantinedFilesSize(), this.optionsObj.getPurgeQuarantinedFilesSize());
    }

    public CleanupOptions getCleanupOptions() {
        return this.optionsObj.getSchemaObject();
    }

    public void setObject(CleanupOptions cleanupOptions) {
        if (cleanupOptions == null) {
            cleanupOptions = new CleanupOptions();
        }
        this.optionsObj = new CleanupOptionsObject(cleanupOptions);
        this.updatePanel();
    }

    public void save() {
        if (this.jPRepair.getFolderSize().length() <= 0 || this.jPBackup.getFolderSize().length() <= 0 || this.jPQuarantine.getFolderSize().length() <= 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.size.errormessage"), MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.error.title"), 0);
            throw new NumberFormatException("");
        }
        this.optionsObj.setAutoPurgeRepairedFiles(this.jPRepair.isEnable());
        this.optionsObj.setPurgeRepairedFilesAfter(this.jPRepair.getDay());
        this.optionsObj.setEnablePurgeRepairedFilesSize(this.jPRepair.isEnableSize());
        this.optionsObj.setPurgeRepairedFilesSize(this.jPRepair.getFolderSize());
        this.optionsObj.setAutoPurgeBackupFiles(this.jPBackup.isEnable());
        this.optionsObj.setPurgeBackupFilesAfter(this.jPBackup.getDay());
        this.optionsObj.setEnablePurgeBackupFilesSize(this.jPBackup.isEnableSize());
        this.optionsObj.setPurgeBackupFilesSize(this.jPBackup.getFolderSize());
        this.optionsObj.setAutoPurgeQuarantinedFiles(this.jPQuarantine.isEnable());
        this.optionsObj.setPurgeQuarantinedFilesAfter(this.jPQuarantine.getDay());
        this.optionsObj.setEnablePurgeQuarantinedFilesSize(this.jPQuarantine.isEnableSize());
        this.optionsObj.setPurgeQuarantinedFilesSize(this.jPQuarantine.getFolderSize());
    }

    private static class PurgePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox jChkEnable;
        private JSpinner jSpnDay;
        private JCheckBox jChkSize;
        private JTextField jTFSize;
        private JPanel dayPanel;
        private JPanel sizePanel;
        private JLabel mbLabel;

        public PurgePanel(String enableText) {
            this.jChkEnable = new JCheckBox(enableText);
            this.jChkEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableChanged();
                }
            });
            SpinnerNumberModel model = new SpinnerNumberModel(30, 1, 9999, 1);
            this.jSpnDay = new JSpinner(model);
            UIUtilities.enableOnlyValidEdits(this.jSpnDay);
            this.jChkSize = new JCheckBox(MSGRES.getString(CleanupPane.QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.size"));
            this.jChkSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableSizeChanged();
                }
            });
            this.jTFSize = new JTextField((Document)new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
            this.dayPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 23;
            gc.insets = new Insets(10, 0, 0, 0);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 1;
            this.dayPanel.add((Component)new JLabel(MSGRES.getString(CleanupPane.QUARANTINE, "QuarantineTab.dialog.cleanUp.label.day")), gc);
            gc.insets = new Insets(5, 5, 0, 0);
            gc.gridx = 1;
            gc.gridy = 0;
            this.dayPanel.add((Component)this.jSpnDay, gc);
            gc.insets = new Insets(10, 5, 0, 0);
            gc.gridx = 2;
            gc.gridy = 0;
            gc.ipadx = 5;
            this.dayPanel.add((Component)new JLabel(MSGRES.getString(CleanupPane.QUARANTINE, "QuarantineTab.dialog.cleanUp.combobox.item.days")), gc);
            this.sizePanel = new JPanel(new GridBagLayout());
            gc.anchor = 23;
            gc.insets = new Insets(5, 0, 0, 0);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.ipadx = 0;
            this.sizePanel.add((Component)this.jChkSize, gc);
            gc.insets = new Insets(5, 5, 0, 0);
            gc.gridx = 1;
            gc.gridy = 0;
            this.sizePanel.add((Component)this.jTFSize, gc);
            gc.insets = new Insets(8, 5, 0, 0);
            gc.gridx = 2;
            gc.gridy = 0;
            gc.ipadx = 5;
            this.mbLabel = new JLabel(MSGRES.getString(CleanupPane.QUARANTINE, "QuarantineTab.label.mb"));
            this.sizePanel.add((Component)this.mbLabel, gc);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.jChkEnable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.dayPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
            this.add((Component)this.sizePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        }

        public void setValue(boolean isEnable, Integer day, boolean isEnableSize, String size) {
            this.jChkEnable.setSelected(isEnable);
            this.jSpnDay.setValue(day);
            this.jChkSize.setSelected(isEnableSize);
            this.jTFSize.setText(size);
            this.enableChanged();
        }

        public boolean isEnable() {
            return this.jChkEnable.isSelected();
        }

        public Integer getDay() {
            return (Integer)this.jSpnDay.getValue();
        }

        public boolean isEnableSize() {
            return this.jChkSize.isSelected();
        }

        public String getFolderSize() {
            return this.jTFSize.getText().trim();
        }

        private void enableChanged() {
            this.jChkEnable.setFocusPainted(true);
            boolean enable = this.jChkEnable.isSelected();
            UIUtilities.setContainerStatus(this.dayPanel, enable);
            UIUtilities.setContainerStatus(this.sizePanel, enable);
            this.jChkSize.setEnabled(enable);
            this.enableSizeChanged();
        }

        private void enableSizeChanged() {
            boolean enabled = this.jChkSize.isEnabled() && this.jChkSize.isSelected();
            this.jTFSize.setEnabled(enabled);
        }
    }
}

