/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.quarantine;

import com.sygate.scm.common.configobject.schema.CleanupOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.NumberPlainDocument;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.CleanupOptionsObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Document;

public class CleanupDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String QUARANTINE = "com.sygate.scm.console.ui.policy.av.quarantine.avquarantine";
    private JPanel contentPane;
    private PurgePanel jPRepair;
    private PurgePanel jPBackup;
    private PurgePanel jPQuarantine;
    private CleanupOptionsObject optionsObj;

    public CleanupDialog(String title) {
        super(title, true, true);
    }

    public void setObject(CleanupOptions cleanupOptions) {
        if (cleanupOptions == null) {
            cleanupOptions = new CleanupOptions();
        }
        this.optionsObj = new CleanupOptionsObject(cleanupOptions);
        this.updatePanel();
    }

    @Override
    public void commit() {
        this.saveData();
    }

    @Override
    protected JPanel getContentPanel() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
            this.contentPane.add(this.createRepairPane());
            this.contentPane.add(this.createBackupPane());
            this.contentPane.add(this.createQuarantinePane());
            this.contentPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        }
        return this.contentPane;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_quarantine_clean_up";
    }

    private JPanel createRepairPane() {
        this.jPRepair = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.repairedEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.repaired");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.repairedDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPRepair);
        return panel;
    }

    private JPanel createBackupPane() {
        this.jPBackup = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.backedupEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.backedup");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.backedupDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPBackup);
        return panel;
    }

    private JPanel createQuarantinePane() {
        this.jPQuarantine = new PurgePanel(MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.quarantineEnable"));
        String title = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.quarantine");
        String desc = MSGRES.getString(QUARANTINE, "QuarantineTab.dialog.cleanUp.label.quarantineDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.jPQuarantine);
        return panel;
    }

    private void updatePanel() {
        this.jPRepair.setValue(this.optionsObj.getAutoPurgeRepairedFiles(), this.optionsObj.getPurgeRepairFilesAfter(), this.optionsObj.isEnablePurgeRepairedFilesSize(), this.optionsObj.getPurgeRepairedFilesSize());
        this.jPBackup.setValue(this.optionsObj.getAutoPurgeBackupFiles(), this.optionsObj.getPurgeBackupFilesAfter(), this.optionsObj.isEnablePurgeBackupFilesSize(), this.optionsObj.getPurgeBackupFilesSize());
        this.jPQuarantine.setValue(this.optionsObj.getAutoPurgeQuarantinedFiles(), this.optionsObj.getPurgeQuarantinedFilesAfter(), this.optionsObj.isEnablePurgeQuarantinedFilesSize(), this.optionsObj.getPurgeQuarantinedFilesSize());
    }

    public CleanupOptions getCleanupOptions() {
        return this.optionsObj.getSchemaObject();
    }

    private void saveData() {
        this.optionsObj.setAutoPurgeRepairedFiles(this.jPRepair.isEnable());
        this.optionsObj.setPurgeRepairedFilesAfter(this.jPRepair.getDay());
        this.optionsObj.setEnablePurgeRepairedFilesSize(this.jPRepair.isEnableSize());
        this.optionsObj.setPurgeRepairedFilesSize(this.jPRepair.getFolderSize());
        this.optionsObj.setAutoPurgeBackupFiles(this.jPBackup.isEnable());
        this.optionsObj.setPurgeBackupFilesAfter(this.jPBackup.getDay());
        this.optionsObj.setEnablePurgeBackupFilesSize(this.jPBackup.isEnableSize());
        this.optionsObj.setPurgeBackupFilesSize(this.jPBackup.getFolderSize());
        this.optionsObj.setAutoPurgeQuarantinedFiles(this.jPQuarantine.isEnable());
        this.optionsObj.setPurgeQuarantinedFilesAfter(this.jPQuarantine.getDay());
        this.optionsObj.setEnablePurgeQuarantinedFilesSize(this.jPQuarantine.isEnableSize());
        this.optionsObj.setPurgeQuarantinedFilesSize(this.jPQuarantine.getFolderSize());
    }

    private static class PurgePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox jChkEnable;
        private JSpinner jSpnDay;
        private JCheckBox jChkSize;
        private JTextField jTFSize;
        private JPanel dayPanel;

        public PurgePanel(String enableText) {
            this.jChkEnable = new JCheckBox(enableText);
            this.jChkEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableChanged();
                }
            });
            SpinnerNumberModel model = new SpinnerNumberModel(30, 1, 30, 1);
            this.jSpnDay = new JSpinner(model);
            UIUtilities.enableOnlyValidEdits(this.jSpnDay);
            this.jChkSize = new JCheckBox(MSGRES.getString(CleanupDialog.QUARANTINE, "QuarantineTab.dialog.cleanUp.checkbox.size"));
            this.jChkSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableSizeChanged();
                }
            });
            this.jTFSize = new JTextField((Document)new NumberPlainDocument(Integer.MAX_VALUE, true), "", 10);
            this.dayPanel = new JPanel(new FlowLayout(3));
            this.dayPanel.add(new JLabel(MSGRES.getString(CleanupDialog.QUARANTINE, "QuarantineTab.dialog.cleanUp.label.day")));
            this.dayPanel.add(this.jSpnDay);
            JPanel sizePanel = new JPanel(new FlowLayout(3));
            sizePanel.add(this.jChkSize);
            sizePanel.add(this.jTFSize);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.jChkEnable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.dayPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.add((Component)sizePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        }

        public void setValue(boolean isEnable, Integer day, boolean isEnableSize, String size) {
            this.jChkEnable.setSelected(isEnable);
            this.jSpnDay.setValue(day);
            this.jChkSize.setSelected(isEnableSize);
            this.jTFSize.setText(size);
            this.enableChanged();
        }

        public boolean isEnable() {
            return this.jChkEnable.isSelected();
        }

        public Integer getDay() {
            return (Integer)this.jSpnDay.getValue();
        }

        public boolean isEnableSize() {
            return this.jChkSize.isSelected();
        }

        public String getFolderSize() {
            return this.jTFSize.getText().trim();
        }

        private void enableChanged() {
            boolean enable = this.jChkEnable.isSelected();
            UIUtilities.setContainerStatus(this.dayPanel, enable);
            this.jChkSize.setEnabled(enable);
            this.enableSizeChanged();
        }

        private void enableSizeChanged() {
            this.jTFSize.setEnabled(this.jChkSize.isEnabled() && this.jChkSize.isSelected());
        }
    }
}

