/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AdminDefinedScanPool;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScanPool;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScanPool;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ScheduledScanObjInfoObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ScheduleScanPoolObject
extends AppliablePolicyPool {
    private HashMap<Integer, ConfigObject> objMap = new HashMap();
    private HashMap<Integer, AppliablePolicyPool> poolObjMap = new HashMap();
    private Integer[] listOSBasedScans = new Integer[]{129, 400, 406};

    public ScheduleScanPoolObject(SemDomain domain) throws ConsoleException {
        super(domain);
        this.initialize();
        this.poolObjMap.put(this.listOSBasedScans[0], AdminDefinedScanPoolObject.getPolicyPool());
        this.poolObjMap.put(this.listOSBasedScans[1], MacAdminDefinedScanPoolObject.getPolicyPool());
        this.poolObjMap.put(this.listOSBasedScans[2], LinuxAdminDefinedScanPoolObject.getPolicyPool());
    }

    @Override
    protected void initialize() throws ConsoleException {
        ConfigObject tempCO = null;
        this.clearObjectList();
        for (int platformCount = 0; platformCount < this.listOSBasedScans.length; ++platformCount) {
            tempCO = this.initialize(this.listOSBasedScans[platformCount]);
            this.objMap.put(this.listOSBasedScans[platformCount], tempCO);
            this.initObjInfo(this.listOSBasedScans[platformCount]);
        }
    }

    @Override
    public boolean updatePolicyObject(PolicyObjectBase policyObj) throws ConsoleException {
        Integer appPolicypoolType = null;
        if (policyObj instanceof AdminDefinedScanObject) {
            appPolicypoolType = this.listOSBasedScans[0];
        } else if (policyObj instanceof MacAdminDefinedScanObject) {
            appPolicypoolType = this.listOSBasedScans[1];
        } else if (policyObj instanceof LinuxAdminDefinedScanObject) {
            appPolicypoolType = this.listOSBasedScans[2];
        }
        return this.poolObjMap.get(appPolicypoolType).updatePolicyObject(policyObj);
    }

    public static ScheduleScanPoolObject getPolicyPool() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        return new ScheduleScanPoolObject(domain);
    }

    @Override
    protected void addPolicyPoolReference(ConfigObject policyPool, ObjReference objRef) throws ConsoleException {
        if (objRef != null && AdminDefinedScan.class.getSimpleName().equals(objRef.getTargetType())) {
            ((AdminDefinedScanPool)this.objMap.get(this.listOSBasedScans[0])).addObjReference(objRef);
        } else if (objRef != null && MacAdminDefinedScan.class.getSimpleName().equals(objRef.getTargetType())) {
            ((MacAdminDefinedScanPool)this.objMap.get(this.listOSBasedScans[1])).addObjReference(objRef);
        } else if (objRef != null && LinuxAdminDefinedScan.class.getSimpleName().equals(objRef.getTargetType())) {
            ((LinuxAdminDefinedScanPool)this.objMap.get(this.listOSBasedScans[2])).addObjReference(objRef);
        } else {
            throw new ConsoleException(302645248, 32);
        }
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences(Integer keyType) {
        Vector policyPoolReference = new Vector();
        ConfigObject co = this.objMap.get(keyType);
        switch (keyType) {
            case 129: {
                policyPoolReference = ((AdminDefinedScanPool)co).getObjReference();
                break;
            }
            case 400: {
                if (co != null) {
                    policyPoolReference = ((MacAdminDefinedScanPool)co).getObjReference();
                    break;
                }
                policyPoolReference = new Vector(0);
                break;
            }
            case 406: {
                if (co != null) {
                    policyPoolReference = ((LinuxAdminDefinedScanPool)co).getObjReference();
                    break;
                }
                policyPoolReference = new Vector(0);
                break;
            }
        }
        return policyPoolReference;
    }

    @Override
    protected String getPolicyStr(PolicyObjectBase policyObj) {
        String policyStr = "";
        if (policyObj instanceof AdminDefinedScanObject) {
            policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.adminDefinedScan");
        } else if (policyObj instanceof MacAdminDefinedScanObject) {
            policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.macAdminDefinedScan");
        } else if (policyObj instanceof LinuxAdminDefinedScanObject) {
            policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.linuxAdminDefinedScan");
        }
        return policyStr;
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences() {
        return this.getPolicyPoolReferences(129);
    }

    public AppliablePolicyPool getConfigObjectPool(Integer key) {
        return this.poolObjMap.get(key);
    }

    @Override
    protected void createSemPolicyPool() {
        Set<Map.Entry<Integer, ConfigObject>> entrySet = this.objMap.entrySet();
        ConfigObject co = null;
        boolean isDomainChange = false;
        for (Map.Entry<Integer, ConfigObject> entry : entrySet) {
            Integer mapKey = entry.getKey();
            co = entry.getValue();
            if (co != null) continue;
            switch (mapKey) {
                case 129: {
                    co = new AdminDefinedScanPool();
                    this.domainObjPool.setOptAdminDefinedScanPool((AdminDefinedScanPool)co);
                    break;
                }
                case 400: {
                    co = new MacAdminDefinedScanPool();
                    this.domainObjPool.setOptMacAdminDefinedScanPool((MacAdminDefinedScanPool)co);
                    break;
                }
                case 406: {
                    co = new LinuxAdminDefinedScanPool();
                    this.domainObjPool.setOptLinuxAdminDefinedScanPool((LinuxAdminDefinedScanPool)co);
                    break;
                }
            }
            isDomainChange = true;
        }
        if (isDomainChange) {
            this.updateObjSet.put(this.domain.getId(), this.domain);
        }
    }

    @Override
    protected boolean isPolicyPoolNull() {
        Set<Map.Entry<Integer, ConfigObject>> entrySet = this.objMap.entrySet();
        ConfigObject co = null;
        boolean result = false;
        for (Map.Entry<Integer, ConfigObject> entry : entrySet) {
            co = entry.getValue();
            if (co != null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected ObjInfoObject createInfoObject(int itemType, ObjInfo info, String id) {
        ScheduledScanObjInfoObject ids = new ScheduledScanObjInfoObject(itemType, info);
        ids.initType();
        return ids;
    }

    @Override
    public Integer getPlatFormConstant(PolicyObjectBase policy) {
        if (policy instanceof AdminDefinedScanObject) {
            return 1;
        }
        if (policy instanceof MacAdminDefinedScanObject) {
            return 2;
        }
        if (policy instanceof LinuxAdminDefinedScanObject) {
            return 3;
        }
        return 0;
    }

    @Override
    public List<String> getAllName(PolicyObjectBase policy) {
        ArrayList<String> names = new ArrayList<String>();
        ObjInfoObject[] objInfo = this.getInfoObjectList();
        for (int i = 0; i < objInfo.length; ++i) {
            if (objInfo[i].getItemType() != policy.getItemType()) continue;
            names.add(objInfo[i].getName());
        }
        return names;
    }
}

