/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.logicobject;

import com.sygate.scm.common.configobject.schema.SafeProcessExclusionList;
import com.sygate.scm.common.configobject.schema.SafeProcessName;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.av.logicobject.SafeProcessNameObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class SafeProcessExclusionObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, SafeProcessName> objMap = new HashMap();

    public SafeProcessExclusionObject(Vector<SafeProcessName> list) {
        this.objMap.clear();
        if (list != null) {
            for (SafeProcessName item : list) {
                this.objMap.put(item.getFileName(), item);
            }
        }
    }

    public SafeProcessExclusionList getCustomProcessList() {
        SafeProcessExclusionList spel = new SafeProcessExclusionList();
        for (SafeProcessName item : this.objMap.values()) {
            spel.addSafeProcessName(item);
        }
        return spel;
    }

    public Vector<TableRow> getRows() {
        Vector<TableRow> rows = new Vector<TableRow>();
        if (!this.objMap.isEmpty()) {
            for (SafeProcessName item : this.objMap.values()) {
                rows.add(new SafeProcessNameObject(item));
            }
        }
        return rows;
    }

    public SafeProcessNameObject addSafeProcessName(String filename) throws DuplicateObjectException, IllegalArgumentException {
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("Filename is null or empty");
        }
        if (this.objMap.get(filename) != null) {
            throw new DuplicateObjectException();
        }
        SafeProcessName safeProcessName = new SafeProcessName();
        safeProcessName.setFileName(filename);
        this.objMap.put(filename, safeProcessName);
        return new SafeProcessNameObject(safeProcessName);
    }

    public void editSafeProcessName(SafeProcessName current, String filename) throws DuplicateObjectException, IllegalArgumentException {
        if (current == null || filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("Filename is null or empty");
        }
        SafeProcessName safeProcessName = this.objMap.get(filename);
        if (safeProcessName != null) {
            if (safeProcessName == current) {
                return;
            }
            throw new DuplicateObjectException();
        }
        this.objMap.remove(current.getFileName());
        current.setFileName(filename);
        this.objMap.put(filename, current);
    }

    public void deleteSafeProcessName(String filename) {
        if (filename != null) {
            this.objMap.remove(filename);
        }
    }

    public static class DuplicateObjectException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DuplicateObjectException() {
        }

        public DuplicateObjectException(String desc) {
            super(desc);
        }

        public DuplicateObjectException(Throwable t) {
            super(t);
        }
    }
}

