/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.CommandScan;
import com.sygate.scm.common.configobject.schema.ElamDriverOptions;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

public class AvPolicyObject
extends PolicyIntObjectBase {
    public AvPolicyObject() {
    }

    public AvPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public AvPolicyObject(TopLevelObject policy) {
        super(policy);
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof AvPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new AvPolicyObject(policyObj);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.logicobject.avlogicobject", "AvPolicyObject.AV_TYPE_DESCRIPTION");
    }

    @Override
    public String getTargetType() {
        return "AvPolicy";
    }

    @Override
    public String getTargetName() {
        return "AvPolicyApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedAvPolicyLink";
    }

    @Override
    public int getItemType() {
        return 134;
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalAvPolicy";
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((AvPolicy)this.policy).getOptEnable(), (Boolean)((AvPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((AvPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((AvPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((AvPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            TopLevelObject newAl = (TopLevelObject)washer.duplicateObject((ConfigObject)this.policy, createdObj);
            Iterator j = createdObj.values().iterator();
            while (j.hasNext()) {
                DataobjectManager.getInstance().addObject((TopLevelObject)j.next());
            }
            return this.createPolicyObject(newAl);
        }
        catch (SAXException saxe) {
            throw new ConsoleException(saxe);
        }
        catch (ValidationException ve) {
            throw new ConsoleException(ve);
        }
        catch (IOException ioe) {
            throw new ConsoleException(ioe);
        }
    }

    @Override
    public List<TopLevelObject> getPrivateObjectList() {
        List<TopLevelObject> combinedList = this.getWinPrivateObjectList();
        if (combinedList == null) {
            combinedList = this.getMacPrivateObjectList();
        } else {
            List<TopLevelObject> macPrivateObjectList = this.getMacPrivateObjectList();
            if (macPrivateObjectList != null) {
                combinedList.addAll(macPrivateObjectList);
            }
        }
        return combinedList;
    }

    private List<TopLevelObject> getWinPrivateObjectList() {
        AvScanPolicy scanPolicy = ((AvPolicy)this.policy).getOptAvScanPolicy();
        if (scanPolicy != null) {
            TopLevelObject scan;
            ArrayList<TopLevelObject> privList = new ArrayList<TopLevelObject>();
            CommandScan cmdScan = scanPolicy.getCommandScan();
            ObjReference objRef = cmdScan.getObjReference();
            try {
                scan = PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
                privList.add(scan);
            }
            catch (ConsoleException ex1) {
                LoggerUtilities.logException((Throwable)ex1);
            }
            for (int i = 0; i < scanPolicy.getObjReferenceCount(); ++i) {
                objRef = scanPolicy.getObjReference(i);
                try {
                    scan = PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
                    privList.add(scan);
                    continue;
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
            return privList;
        }
        return null;
    }

    private List<TopLevelObject> getMacPrivateObjectList() {
        MacAvScanPolicy scanPolicy = ((AvPolicy)this.policy).getOptMacAvScanPolicy();
        if (scanPolicy != null) {
            ArrayList<TopLevelObject> privList = new ArrayList<TopLevelObject>();
            ObjReference objRef = null;
            TopLevelObject scan = null;
            MacCommandScan cmdScan = scanPolicy.getOptMacCommandScan();
            if (cmdScan != null && (objRef = cmdScan.getOptObjReference()) != null) {
                try {
                    scan = PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
                    privList.add(scan);
                }
                catch (ConsoleException ex1) {
                    LoggerUtilities.logException((Throwable)ex1);
                }
            }
            for (int i = 0; i < scanPolicy.getObjReferenceCount(); ++i) {
                objRef = scanPolicy.getObjReference(i);
                try {
                    scan = PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
                    privList.add(scan);
                    continue;
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
            return privList;
        }
        return null;
    }

    public boolean getEnableElamDriver() {
        ElamDriverOptions elamOptions = ((AvPolicy)this.policy).getOptElamDriverOptions();
        if (elamOptions.getOptEnableElamDriver() == null) {
            return elamOptions.getDefEnableElamDriver();
        }
        return elamOptions.getOptEnableElamDriver();
    }

    public void setEnableElamDriver(boolean isEnabled) {
        ((AvPolicy)this.policy).getOptElamDriverOptions().setOptEnableElamDriver(Boolean.valueOf(isEnabled));
    }

    public boolean getLockEnableElamDriver() {
        ElamDriverOptions elamOptions = ((AvPolicy)this.policy).getOptElamDriverOptions();
        if (elamOptions.getOptLockEnableElamDriver() == null) {
            return elamOptions.getDefLockEnableElamDriver();
        }
        return elamOptions.getOptLockEnableElamDriver();
    }

    public void setLockEnableElamDriver(boolean isEnabled) {
        ((AvPolicy)this.policy).getOptElamDriverOptions().setOptLockEnableElamDriver(Boolean.valueOf(isEnabled));
    }

    public int getAlterElamDriverResult() {
        ElamDriverOptions elamOptions = ((AvPolicy)this.policy).getOptElamDriverOptions();
        if (elamOptions.getOptAlterElamDriverResult() == null) {
            return elamOptions.getDefAlterElamDriverResult();
        }
        return elamOptions.getOptAlterElamDriverResult();
    }

    public void setAlterElamDriverResult(Integer value) {
        ((AvPolicy)this.policy).getOptElamDriverOptions().setOptAlterElamDriverResult(value);
    }
}

