/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ApAdvancedScanSettings;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import com.sygate.scm.common.configobject.schema.FileScanningOptions;
import com.sygate.scm.common.configobject.schema.HeuristicsOptions;
import com.sygate.scm.common.configobject.schema.SafeProcessExclusionList;
import com.sygate.scm.common.configobject.schema.VirusLikeActivityOptions;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;

public class AdvancedScanSettingsObject
extends AbstractUIObject {
    private ApAdvancedScanSettings advancedScanSettingsObj;
    private FileScanningOptions fOptions;
    private HeuristicsOptions hOptions;
    private CompressedFiles cOptions;
    private VirusLikeActivityOptions vOptions;

    public AdvancedScanSettingsObject(ApAdvancedScanSettings advancedScanSettingsObj) {
        this.advancedScanSettingsObj = advancedScanSettingsObj;
        this.fOptions = advancedScanSettingsObj.getFileScanningOptions();
        this.hOptions = advancedScanSettingsObj.getHeuristicsOptions();
        this.cOptions = advancedScanSettingsObj.getOptCompressedFiles();
        this.vOptions = advancedScanSettingsObj.getVirusLikeActivityOptions();
        if (this.fOptions == null || this.hOptions == null || this.vOptions == null || this.cOptions == null) {
            try {
                AvPolicy defaultAvPolicy = PolicyHandler.getDefaultAvPolicy(new HashMap<String, TopLevelObject>());
                if (this.fOptions == null && defaultAvPolicy != null) {
                    this.fOptions = defaultAvPolicy.getOptAvAutoProtect().getOptAvFileAp().getOptApFileScanDetails().getOptApAdvancedScanSettings().getFileScanningOptions();
                    advancedScanSettingsObj.setFileScanningOptions(this.fOptions);
                }
                if (this.hOptions == null && defaultAvPolicy != null) {
                    this.hOptions = defaultAvPolicy.getOptAvAutoProtect().getOptAvFileAp().getOptApFileScanDetails().getOptApAdvancedScanSettings().getHeuristicsOptions();
                    advancedScanSettingsObj.setHeuristicsOptions(this.hOptions);
                }
                if (this.vOptions == null && defaultAvPolicy != null) {
                    this.vOptions = defaultAvPolicy.getOptAvAutoProtect().getOptAvFileAp().getOptApFileScanDetails().getOptApAdvancedScanSettings().getVirusLikeActivityOptions();
                    advancedScanSettingsObj.setVirusLikeActivityOptions(this.vOptions);
                }
                if (this.cOptions == null) {
                    this.cOptions = new CompressedFiles(false);
                    advancedScanSettingsObj.setOptCompressedFiles(this.cOptions);
                }
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
    }

    public ApAdvancedScanSettings getSchemaObject() {
        this.advancedScanSettingsObj.setFileScanningOptions(this.fOptions);
        this.advancedScanSettingsObj.setHeuristicsOptions(this.hOptions);
        this.advancedScanSettingsObj.setVirusLikeActivityOptions(this.vOptions);
        return this.advancedScanSettingsObj;
    }

    public boolean getLockScanFilesOpenedForBackup() {
        if (this.fOptions.getOptLockScanFilesOpenedForBackup() == null) {
            return this.fOptions.getDefLockScanFilesOpenedForBackup();
        }
        return this.fOptions.getOptLockScanFilesOpenedForBackup();
    }

    public void setLockScanFilesOpenedForBackup(boolean isLocked) {
        this.fOptions.setOptLockScanFilesOpenedForBackup(Boolean.valueOf(isLocked));
    }

    public boolean getLockWhenToScanFiles() {
        if (this.fOptions.getOptLockWhenToScanFiles() == null) {
            return this.fOptions.getDefLockWhenToScanFiles();
        }
        return this.fOptions.getOptLockWhenToScanFiles();
    }

    public void setLockWhenToScanFiles(boolean isLocked) {
        this.fOptions.setOptLockWhenToScanFiles(Boolean.valueOf(isLocked));
    }

    public void setLockSafeProcessExclusion(boolean isLocked) {
        this.fOptions.setOptLockEnableSafeProcessExclusion(Boolean.valueOf(isLocked));
        this.fOptions.setOptLockEnableSafeProcessExclusionList(Boolean.valueOf(isLocked));
    }

    public boolean getLockSafeProcessExclusion() {
        if (this.fOptions.getOptLockEnableSafeProcessExclusion() == null) {
            return this.fOptions.getDefLockEnableSafeProcessExclusion();
        }
        return this.fOptions.getOptLockEnableSafeProcessExclusion();
    }

    public void setSafeProcessExclusion(boolean isLocked) {
        this.fOptions.setOptEnableSafeProcessExclusion(Boolean.valueOf(isLocked));
    }

    public Boolean getSafeProcessExclusion() {
        if (this.fOptions.getOptEnableSafeProcessExclusion() == null) {
            return this.fOptions.getDefEnableSafeProcessExclusion();
        }
        return this.fOptions.getOptEnableSafeProcessExclusion();
    }

    public void setEnableCustomProcessList(boolean isEnabled) {
        this.fOptions.setOptEnableSafeProcessExclusionList(Boolean.valueOf(isEnabled));
    }

    public Boolean getEnableCustomProcessList() {
        if (this.fOptions.getOptEnableSafeProcessExclusionList() == null) {
            return this.fOptions.getDefEnableSafeProcessExclusionList();
        }
        return this.fOptions.getOptEnableSafeProcessExclusionList();
    }

    public void setCustomProcessList(SafeProcessExclusionList list) {
        if (list == null || list.getSafeProcessNameCount() == 0) {
            this.fOptions.setOptSafeProcessExclusionList(null);
        } else {
            this.fOptions.setOptSafeProcessExclusionList(list);
        }
    }

    public SafeProcessExclusionList getCustomProcessList() {
        return this.fOptions.getOptSafeProcessExclusionList();
    }

    public Integer getWhenToScanFiles() {
        return this.fOptions.getWhenToScanFiles();
    }

    public void setWhenToScanFiles(Integer when) {
        this.fOptions.setWhenToScanFiles(when);
    }

    public boolean getScanFilesOpenedForBackup() {
        if (this.fOptions.getOptScanFilesOpenedForBackup() == null) {
            return this.fOptions.getDefScanFilesOpenedForBackup();
        }
        return this.fOptions.getOptScanFilesOpenedForBackup();
    }

    public void setScanFilesOpenedForBackup(boolean isSelected) {
        this.fOptions.setOptScanFilesOpenedForBackup(Boolean.valueOf(isSelected));
    }

    public CompressedFiles getCompressedFiles() {
        return this.cOptions;
    }

    public boolean getLockScanInsideCompressedFiles() {
        if (this.cOptions.getOptLockScanInsideCompressedFiles() == null) {
            return this.cOptions.getDefLockScanInsideCompressedFiles();
        }
        return this.cOptions.getOptLockScanInsideCompressedFiles();
    }

    public void setLockScanInsideCompressedFiles(boolean isLocked) {
        this.cOptions.setOptLockScanInsideCompressedFiles(Boolean.valueOf(isLocked));
    }

    public boolean getScanInsideCompressedFiles() {
        if (this.cOptions.getOptScanInsideCompressedFiles() == null) {
            return this.cOptions.getDefScanInsideCompressedFiles();
        }
        return this.cOptions.getOptScanInsideCompressedFiles();
    }

    public void setScanInsideCompressedFiles(boolean isLocked) {
        this.cOptions.setOptScanInsideCompressedFiles(Boolean.valueOf(isLocked));
    }

    public int getExpandLevels() {
        if (this.cOptions.getOptExpandLevels() == null) {
            return this.cOptions.getDefExpandLevels();
        }
        return this.cOptions.getOptExpandLevels();
    }

    public void setExpandLevels(int level) {
        this.cOptions.setOptExpandLevels(Integer.valueOf(level));
    }

    public boolean getLockBloodhoundOptions() {
        if (this.hOptions.getOptLockBloodhoundOptions() == null) {
            return this.hOptions.getDefLockBloodhoundOptions();
        }
        return this.hOptions.getOptLockBloodhoundOptions();
    }

    public void setLockBloodhoundOptions(boolean isLocked) {
        this.hOptions.setOptLockBloodhoundOptions(Boolean.valueOf(isLocked));
    }

    public boolean getEnableBloodhound() {
        if (this.hOptions.getOptEnableBloodhound() == null) {
            return this.hOptions.getDefEnableBloodhound();
        }
        return this.hOptions.getOptEnableBloodhound();
    }

    public void setEnableBloodhound(boolean isEnabled) {
        this.hOptions.setOptEnableBloodhound(Boolean.valueOf(isEnabled));
    }

    public int getBloodhoundLevel() {
        if (this.hOptions.getOptBloodhoundLevel() == null) {
            return this.hOptions.getDefBloodhoundLevel();
        }
        return this.hOptions.getOptBloodhoundLevel();
    }

    public void setBloodhoundLevel(int level) {
        this.hOptions.setOptBloodhoundLevel(Integer.valueOf(level));
    }

    public boolean getLockLowLevelFormatOfHardDiskAction() {
        if (this.vOptions.getOptLockLowLevelFormatOfHardDiskAction() == null) {
            return this.vOptions.getDefLockLowLevelFormatOfHardDiskAction();
        }
        return this.vOptions.getOptLockLowLevelFormatOfHardDiskAction();
    }

    public void setLockLowLevelFormatOfHardDiskAction(boolean isLocked) {
        this.vOptions.setOptLockLowLevelFormatOfHardDiskAction(Boolean.valueOf(isLocked));
    }

    public boolean getLockWriteToFloppyDiskBootRecordsAction() {
        if (this.vOptions.getOptLockWriteToFloppyDiskBootRecordsAction() == null) {
            return this.vOptions.getDefLockWriteToFloppyDiskBootRecordsAction();
        }
        return this.vOptions.getOptLockWriteToFloppyDiskBootRecordsAction();
    }

    public void setLockWriteToFloppyDiskBootRecordsAction(boolean isLocked) {
        this.vOptions.setOptLockWriteToFloppyDiskBootRecordsAction(Boolean.valueOf(isLocked));
    }

    public boolean getLockWriteToHardDiskBootRecordsAction() {
        if (this.vOptions.getOptLockWriteToHardDiskBootRecordsAction() == null) {
            return this.vOptions.getDefLockWriteToHardDiskBootRecordsAction();
        }
        return this.vOptions.getOptLockWriteToHardDiskBootRecordsAction();
    }

    public void setLockWriteToHardDiskBootRecordsAction(boolean isLocked) {
        this.vOptions.setOptLockWriteToHardDiskBootRecordsAction(Boolean.valueOf(isLocked));
    }

    public int getLowLevelFormatOfHardDiskAction() {
        if (this.vOptions.getOptLowLevelFormatOfHardDiskAction() == null) {
            return this.vOptions.getDefLowLevelFormatOfHardDiskAction();
        }
        return this.vOptions.getOptLowLevelFormatOfHardDiskAction();
    }

    public void setLowLevelFormatOfHardDiskAction(int level) {
        this.vOptions.setOptLowLevelFormatOfHardDiskAction(Integer.valueOf(level));
    }

    public int getWriteToFloppyDiskBootRecordsAction() {
        if (this.vOptions.getOptWriteToFloppyDiskBootRecordsAction() == null) {
            return this.vOptions.getDefWriteToFloppyDiskBootRecordsAction();
        }
        return this.vOptions.getOptWriteToFloppyDiskBootRecordsAction();
    }

    public void setWriteToFloppyDiskBootRecordsAction(int level) {
        this.vOptions.setOptWriteToFloppyDiskBootRecordsAction(Integer.valueOf(level));
    }

    public int getWriteToHardDiskBootRecordsAction() {
        if (this.vOptions.getOptWriteToHardDiskBootRecordsAction() == null) {
            return this.vOptions.getDefWriteToHardDiskBootRecordsAction();
        }
        return this.vOptions.getOptWriteToHardDiskBootRecordsAction();
    }

    public void setWriteToHardDiskBootRecordsAction(int level) {
        this.vOptions.setOptLowLevelFormatOfHardDiskAction(Integer.valueOf(level));
    }

    public void setLockForLeaveAloneDeleteInfectedOnCreate(boolean isLocked) {
        this.fOptions.setOptLockForLeaveAloneDeleteInfectedOnCreate(Boolean.valueOf(isLocked));
    }

    public void setPreserveFileTimes(boolean isEnabled) {
        this.fOptions.setOptPreserveFileTimes(Boolean.valueOf(isEnabled));
    }

    public void setLockPreserveFileTimes(boolean isEnabled) {
        this.fOptions.setOptLockPreserveFileTimes(Boolean.valueOf(isEnabled));
    }

    public void setForLeaveAloneDeleteInfectedOnCreate(boolean isEnabled) {
        this.fOptions.setOptForLeaveAloneDeleteInfectedOnCreate(Boolean.valueOf(isEnabled));
    }

    public void setForLeaveAloneDeleteInfectedOnCreateSRT(boolean isEnabled) {
        this.fOptions.setOptForLeaveAloneDeleteInfectedOnCreateSRT(Boolean.valueOf(isEnabled));
    }

    public boolean getLockForLeaveAloneDeleteInfectedOnCreate() {
        return this.fOptions.getOptLockForLeaveAloneDeleteInfectedOnCreate() != null ? this.fOptions.getOptLockForLeaveAloneDeleteInfectedOnCreate() : this.fOptions.getDefLockForLeaveAloneDeleteInfectedOnCreate();
    }

    public boolean getPreserveFileTimes() {
        return this.fOptions.getOptPreserveFileTimes() != null ? this.fOptions.getOptPreserveFileTimes() : this.fOptions.getDefPreserveFileTimes();
    }

    public boolean getForLeaveAloneDeleteInfectedOnCreate() {
        return this.fOptions.getOptForLeaveAloneDeleteInfectedOnCreate() != null ? this.fOptions.getOptForLeaveAloneDeleteInfectedOnCreate() : this.fOptions.getDefForLeaveAloneDeleteInfectedOnCreate();
    }

    public boolean getForLeaveAloneDeleteInfectedOnCreateSRT() {
        return this.fOptions.getOptForLeaveAloneDeleteInfectedOnCreateSRT() != null ? this.fOptions.getOptForLeaveAloneDeleteInfectedOnCreateSRT() : this.fOptions.getDefForLeaveAloneDeleteInfectedOnCreateSRT();
    }

    public boolean getLockPreserveFileTimes() {
        return this.fOptions.getOptLockPreserveFileTimes() != null ? this.fOptions.getOptLockPreserveFileTimes() : this.fOptions.getDefLockPreserveFileTimes();
    }

    public HeuristicsOptions getHeuristicsOptions() {
        return this.hOptions;
    }

    public void setHeuristicsOptions(HeuristicsOptions hOptions) {
        this.hOptions = hOptions;
    }
}

