/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.hpp;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.BASHSystemChangesObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HppSystemChangesPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane systemChangesPane;
    private JComboBox<String> jCmbDNSChangeActionList;
    private JComboBox<String> jCmbFileChangeActionList;
    private LockCheckBox dnsChangeLock;
    private LockCheckBox fileChangeLock;
    private BASHSystemChangesObject objSystemChanges;
    private static final int IGNORE_INDEX = 0;
    private static final int PROMPT_INDEX = 1;
    private static final int BLOCK_INDEX = 2;
    private static final int LOG_INDEX = 3;

    public HppSystemChangesPane() {
        this.init();
    }

    private void init() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppSystemChangesPane.systemChangeEvent");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppSystemChangesPane.systemChangeEventDesc");
        this.objSystemChanges = new BASHSystemChangesObject();
        this.systemChangesPane = new AvTemplatePane(title, desc);
        this.systemChangesPane.add(this.getHppSystemChangesPane());
        this.setLayout(new BorderLayout());
        this.add((Component)this.systemChangesPane, "Center");
    }

    public void setObject(BASHSystemChangesObject systemChanges) throws ConsoleException {
        if (systemChanges == null) {
            return;
        }
        this.objSystemChanges = systemChanges;
        this.updateControls();
    }

    private JPanel getHppSystemChangesPane() {
        JLabel jLblDNSChange = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppSystemChangesPane.DNSChangeDetected"));
        JLabel jLblHostFileChange = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppSystemChangesPane.fileChangeDetected"));
        JPanel hppSystemChangesPane = new JPanel();
        hppSystemChangesPane.setLayout(new BorderLayout());
        this.createControls();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraint = new GridBagConstraints();
        gbConstraint.anchor = 23;
        this.addComponent(panel, this.dnsChangeLock, gbConstraint, 0, 0, new Insets(10, 10, 0, 0));
        this.addComponent(panel, jLblDNSChange, gbConstraint, 1, 0, new Insets(15, 10, 0, 0));
        this.addComponent(panel, this.jCmbDNSChangeActionList, gbConstraint, 2, 0, new Insets(10, 48, 0, 0));
        this.addComponent(panel, this.fileChangeLock, gbConstraint, 0, 1, new Insets(10, 10, 0, 0));
        this.addComponent(panel, jLblHostFileChange, gbConstraint, 1, 1, new Insets(15, 10, 0, 0));
        this.addComponent(panel, this.jCmbFileChangeActionList, gbConstraint, 2, 1, new Insets(10, 48, 0, 0));
        hppSystemChangesPane.add((Component)panel, "West");
        return hppSystemChangesPane;
    }

    private void addComponent(Container container, JComponent comp, GridBagConstraints gbConstraint, int xPos, int yPos, Insets inset) {
        if (gbConstraint == null) {
            gbConstraint = new GridBagConstraints();
        }
        gbConstraint.anchor = 23;
        gbConstraint.gridx = xPos;
        gbConstraint.gridy = yPos;
        gbConstraint.insets = inset == null ? new Insets(0, 0, 0, 0) : inset;
        container.add((Component)comp, gbConstraint);
    }

    public void saveObject() throws ConsoleException {
        this.objSystemChanges.setLockDNSChangeDetectAction(this.dnsChangeLock.isSelected());
        this.objSystemChanges.setDNSChangeDetectAction(this.getActionFromIndex(this.jCmbDNSChangeActionList.getSelectedIndex()));
        this.objSystemChanges.setLockHostFileChangeDetectAction(this.fileChangeLock.isSelected());
        this.objSystemChanges.setHostFileChangeDetectAction(this.getActionFromIndex(this.jCmbFileChangeActionList.getSelectedIndex()));
    }

    public BASHSystemChangesObject getModelObject() {
        return this.objSystemChanges;
    }

    private void createControls() {
        this.dnsChangeLock = new LockCheckBox(Boolean.FALSE);
        this.dnsChangeLock.setSelectedIcon(AvConstants.lockIcon);
        this.fileChangeLock = new LockCheckBox(Boolean.FALSE);
        this.fileChangeLock.setSelectedIcon(AvConstants.lockIcon);
        String strPromptAction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.list.action.promptAction");
        String strIgnoreAction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.list.action.ignoreAction");
        String strBlockAction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.list.action.blockAction");
        String strLogAction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.list.action.logAction");
        this.jCmbDNSChangeActionList = new JComboBox<String>(new String[]{strIgnoreAction, strPromptAction, strBlockAction, strLogAction});
        this.jCmbFileChangeActionList = new JComboBox<String>(new String[]{strIgnoreAction, strPromptAction, strBlockAction, strLogAction});
    }

    public void updateControls() {
        Boolean lockDNSChange = this.objSystemChanges.getLockDNSChangeDetectAction();
        this.dnsChangeLock.setSelected(lockDNSChange);
        Integer dnsChangeAction = this.objSystemChanges.getDNSChangeDetectAction();
        this.jCmbDNSChangeActionList.setSelectedIndex(this.getIndexFromAction(dnsChangeAction));
        Boolean lockHostFileChange = this.objSystemChanges.getLockHostFileChangeDetectAction();
        this.fileChangeLock.setSelected(lockHostFileChange);
        Integer hostFileChangeAction = this.objSystemChanges.getHostFileChangeDetectAction();
        this.jCmbFileChangeActionList.setSelectedIndex(this.getIndexFromAction(hostFileChangeAction));
    }

    private Integer getActionFromIndex(int actionIndex) {
        Integer actionIdx = null;
        switch (actionIndex) {
            case 0: {
                actionIdx = 0;
                break;
            }
            case 1: {
                actionIdx = 1;
                break;
            }
            case 2: {
                actionIdx = 2;
                break;
            }
            case 3: {
                actionIdx = 3;
                break;
            }
        }
        return actionIdx;
    }

    private int getIndexFromAction(Integer actionInt) {
        if (actionInt == null) {
            return 0;
        }
        int actionIndex = 0;
        if (actionInt.equals(0)) {
            actionIndex = 0;
        } else if (actionInt.equals(1)) {
            actionIndex = 1;
        } else if (actionInt.equals(2)) {
            actionIndex = 2;
        } else if (actionInt.equals(3)) {
            actionIndex = 3;
        }
        return actionIndex;
    }

    public void setPanelEnabled(boolean enabled) {
        this.jCmbDNSChangeActionList.setEnabled(enabled);
        this.jCmbFileChangeActionList.setEnabled(enabled);
        this.dnsChangeLock.setEnabled(enabled);
        this.fileChangeLock.setEnabled(enabled);
    }
}

