/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.hpp;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.BASHNetworkSettingsObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class HppNetworkSettingsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane networkSettingsPane;
    private JCheckBox jCbNetworkFileMonitoring;
    private LockCheckBox networkFileMonitoringLock;
    private BASHNetworkSettingsObject objNetworkSettings;

    public HppNetworkSettingsPane() {
        this.init();
    }

    public void init() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppNetworkSettingsPane.networkTitle");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppNetworkSettingsPane.networkDesc");
        this.objNetworkSettings = new BASHNetworkSettingsObject();
        this.networkSettingsPane = new AvTemplatePane(title, desc);
        this.networkSettingsPane.add(this.getHppNetworkSettingsPane());
        this.setLayout(new BorderLayout());
        this.add((Component)this.networkSettingsPane, "Center");
    }

    public void setObject(BASHNetworkSettingsObject networkSettings) throws ConsoleException {
        if (networkSettings == null) {
            return;
        }
        this.objNetworkSettings = networkSettings;
        this.updateControls();
    }

    public BASHNetworkSettingsObject getModelObject() {
        return this.objNetworkSettings;
    }

    private JPanel getHppNetworkSettingsPane() {
        JPanel hppNetworkSettingsPane = new JPanel();
        hppNetworkSettingsPane.setLayout(new BorderLayout());
        this.createControls();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraint = new GridBagConstraints();
        gbConstraint.anchor = 23;
        gbConstraint.gridx = 0;
        gbConstraint.gridy = 0;
        gbConstraint.insets = new Insets(10, 10, 0, 0);
        panel.add((Component)this.networkFileMonitoringLock, gbConstraint);
        gbConstraint.gridx = 1;
        gbConstraint.gridy = 0;
        gbConstraint.insets = new Insets(15, 10, 0, 0);
        panel.add((Component)this.jCbNetworkFileMonitoring, gbConstraint);
        hppNetworkSettingsPane.add((Component)panel, "West");
        return hppNetworkSettingsPane;
    }

    public void saveObject() throws ConsoleException {
        this.objNetworkSettings.setLocEnableNetworkFileMonitoring(this.networkFileMonitoringLock.isSelected());
        this.objNetworkSettings.setEnableNetworkFileMonitoring(this.jCbNetworkFileMonitoring.isSelected());
    }

    private void createControls() {
        this.networkFileMonitoringLock = new LockCheckBox(Boolean.FALSE);
        this.networkFileMonitoringLock.setSelectedIcon(AvConstants.lockIcon);
        this.jCbNetworkFileMonitoring = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppNetworkSettingsPane.networkFileMonitor"));
    }

    public void updateControls() {
        Boolean networkMonitoringLock = this.objNetworkSettings.getLockEnableNetworkFileMonitoring();
        this.networkFileMonitoringLock.setSelected(networkMonitoringLock);
        Boolean networkFileMonitoring = this.objNetworkSettings.getEnableNetworkFileMonitoring();
        this.jCbNetworkFileMonitoring.setSelected(networkFileMonitoring);
    }

    public void setPanelEnabled(boolean enabled) {
        this.jCbNetworkFileMonitoring.setEnabled(enabled);
        this.networkFileMonitoringLock.setEnabled(enabled);
    }
}

