/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.hpp;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.BASHConfidenceObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CloudLockPanel;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.BooleanWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HppConfidenceSettingsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String HPP = "com.sygate.scm.console.ui.policy.av.hpp.hpp";
    private AvTemplatePane confidenceSettingsPane;
    private JComboBox<String> jCmbHighConfidenceActionList;
    private JComboBox<String> jCmbLowConfidenceActionList;
    private LockCheckBox highConfidenceLock;
    private LockCheckBox lowConfidenceLock;
    private transient BASHConfidenceObject objConfidenceSettings;
    protected static final int LOG_INDEX = 0;
    protected static final int QUARANTINE_INDEX = 1;
    protected static final int DISABLED_INDEX = 2;

    public HppConfidenceSettingsPane() {
        this.init();
    }

    private void init() {
        this.objConfidenceSettings = new BASHConfidenceObject();
        this.createControls();
        String title = MSGRES.getString(HPP, "HppConfidenceSettingsPane.confidenceTitle");
        String desc = MSGRES.getString(HPP, "HppConfidenceSettingsPane.confidenceDesc");
        this.confidenceSettingsPane = new AvTemplatePane(title, desc);
        this.confidenceSettingsPane.add(this.getHppConfidenceSettingsPane());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.confidenceSettingsPane);
    }

    public void setObject(BASHConfidenceObject confidenceSettings) throws ConsoleException {
        if (confidenceSettings == null) {
            return;
        }
        this.objConfidenceSettings = confidenceSettings;
        this.updateControls();
    }

    private JPanel getHppConfidenceSettingsPane() {
        JLabel jLblHighConfidence = new JLabel(MSGRES.getString(HPP, "HppConfidenceSettingsPane.highConfidence"));
        JLabel jLblLowConfidence = new JLabel(MSGRES.getString(HPP, "HppConfidenceSettingsPane.lowConfidence"));
        JPanel hppConfidenceSettingsPane = new JPanel();
        hppConfidenceSettingsPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraint = new GridBagConstraints();
        gbConstraint.anchor = 23;
        this.addComponent(panel, new CloudLockPanel(this.highConfidenceLock), gbConstraint, 0, 1, 1, 0.0, 0, new Insets(0, 0, 0, 0));
        this.addComponent(panel, jLblHighConfidence, gbConstraint, 1, 1, 2, 1.0, 2, new Insets(5, 5, 0, 40));
        if (this.isCloudEnrolled()) {
            jLblHighConfidence.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        this.addComponent(panel, this.jCmbHighConfidenceActionList, gbConstraint, 3, 1, 1, 0.0, 0, new Insets(5, 5, 0, 0));
        if (this.isCloudEnrolled()) {
            this.jCmbHighConfidenceActionList.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        this.addComponent(panel, new CloudLockPanel(this.lowConfidenceLock), gbConstraint, 0, 2, 1, 0.0, 0, new Insets(0, 0, 0, 0));
        this.addComponent(panel, jLblLowConfidence, gbConstraint, 1, 2, 2, 1.0, 2, new Insets(5, 5, 0, 40));
        if (this.isCloudEnrolled()) {
            jLblLowConfidence.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        this.addComponent(panel, this.jCmbLowConfidenceActionList, gbConstraint, 3, 2, 1, 0.0, 0, new Insets(5, 5, 0, 0));
        if (this.isCloudEnrolled()) {
            this.jCmbLowConfidenceActionList.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        hppConfidenceSettingsPane.add((Component)panel, "West");
        return hppConfidenceSettingsPane;
    }

    private boolean isCloudEnrolled() {
        return CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    }

    private void addComponent(Container container, Component comp, GridBagConstraints gbConstraint, int xPos, int yPos, int width, double weightX, int fill, Insets inset) {
        if (gbConstraint == null) {
            gbConstraint = new GridBagConstraints();
        }
        gbConstraint.gridx = xPos;
        gbConstraint.gridy = yPos;
        gbConstraint.gridwidth = width;
        gbConstraint.weightx = weightX;
        gbConstraint.fill = fill;
        gbConstraint.insets = inset == null ? new Insets(0, 0, 0, 0) : inset;
        container.add(comp, gbConstraint);
    }

    public void saveObject() throws ConsoleException {
        this.objConfidenceSettings.setLockedHighConfidenceAction(this.highConfidenceLock.isSelected());
        this.objConfidenceSettings.setLockedLowConfidenceAction(this.lowConfidenceLock.isSelected());
        this.objConfidenceSettings.setHighConfidenceAction(this.getHighActionFromIndex(this.jCmbHighConfidenceActionList.getSelectedIndex()));
        this.objConfidenceSettings.setLowConfidenceAction(this.getLowActionFromIndex(this.jCmbLowConfidenceActionList.getSelectedIndex()));
    }

    public BASHConfidenceObject getModelObject() {
        return this.objConfidenceSettings;
    }

    private void createControls() {
        this.highConfidenceLock = new LockCheckBox(Boolean.FALSE);
        this.highConfidenceLock.setSelectedIcon(AvConstants.lockIcon);
        this.lowConfidenceLock = new LockCheckBox(Boolean.FALSE);
        this.lowConfidenceLock.setSelectedIcon(AvConstants.lockIcon);
        String strLogAction = MSGRES.getString(HPP, "HppConfidenceSettingsPane.list.action.logAction");
        String strQuarantineAction = MSGRES.getString(HPP, "HppConfidenceSettingsPane.list.action.quarantineAction");
        String strDisabledAction = MSGRES.getString(HPP, "HppConfidenceSettingsPane.list.action.disabledAction");
        this.jCmbHighConfidenceActionList = new JComboBox<String>(new String[]{strLogAction, strQuarantineAction});
        this.jCmbLowConfidenceActionList = new JComboBox<String>(new String[]{strLogAction, strQuarantineAction, strDisabledAction});
        this.jCmbHighConfidenceActionList.addItemListener(event -> {
            if (this.jCmbHighConfidenceActionList.getSelectedIndex() == 2) {
                this.jCmbLowConfidenceActionList.setSelectedIndex(2);
                return;
            }
            if (this.jCmbHighConfidenceActionList.getSelectedIndex() == 0) {
                this.jCmbLowConfidenceActionList.setSelectedIndex(0);
            }
        });
        this.jCmbLowConfidenceActionList.addItemListener(event -> {
            if (this.jCmbLowConfidenceActionList.getSelectedIndex() == 1) {
                this.jCmbHighConfidenceActionList.setSelectedIndex(1);
            }
        });
    }

    private void updateControls() {
        BooleanWrapper lockHighConfidence = this.objConfidenceSettings.getLockedHighConfidenceAction();
        if (lockHighConfidence != null && !lockHighConfidence.isNull()) {
            this.highConfidenceLock.setSelected(lockHighConfidence.booleanValue());
        }
        Integer highConfidenceAction = this.objConfidenceSettings.getHighConfidenceAction();
        this.jCmbHighConfidenceActionList.setSelectedIndex(this.getIndexFromHighAction(highConfidenceAction));
        BooleanWrapper lockLowConfidence = this.objConfidenceSettings.getLockedLowConfidenceAction();
        if (lockLowConfidence != null && !lockLowConfidence.isNull()) {
            this.lowConfidenceLock.setSelected(lockLowConfidence.booleanValue());
        }
        Integer lowConfidenceAction = this.objConfidenceSettings.getLowConfidenceAction();
        this.jCmbLowConfidenceActionList.setSelectedIndex(this.getIndexFromLowAction(lowConfidenceAction));
    }

    private Integer getHighActionFromIndex(int actionIndex) {
        Integer actionInt = null;
        switch (actionIndex) {
            case 0: {
                actionInt = 0;
                break;
            }
            case 1: {
                actionInt = 1;
                break;
            }
        }
        return actionInt;
    }

    private int getIndexFromHighAction(Integer actionInt) {
        int actionIndex = 1;
        if (actionInt != null && actionInt.equals(0)) {
            actionIndex = 0;
        }
        return actionIndex;
    }

    private Integer getLowActionFromIndex(int actionIndex) {
        Integer actionInt = null;
        switch (actionIndex) {
            case 0: {
                actionInt = 0;
                break;
            }
            case 1: {
                actionInt = 1;
                break;
            }
            case 2: {
                actionInt = 3;
                break;
            }
        }
        return actionInt;
    }

    private int getIndexFromLowAction(Integer actionInt) {
        if (actionInt == null) {
            return 1;
        }
        int actionIndex = 1;
        if (actionInt.equals(0)) {
            actionIndex = 0;
        } else if (actionInt.equals(3)) {
            actionIndex = 2;
        }
        return actionIndex;
    }

    public void setPanelEnabled(boolean enabled) {
        this.highConfidenceLock.setEnabled(enabled);
        this.jCmbHighConfidenceActionList.setEnabled(enabled);
        this.lowConfidenceLock.setEnabled(enabled);
        this.jCmbLowConfidenceActionList.setEnabled(enabled);
    }
}

