/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.hpp;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.BASHNotificationsObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HppBASHNotificationsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LockCheckBox displayResultsLock;
    private JCheckBox displayResultsChk;
    private LockCheckBox terminateProcessLock;
    private JCheckBox terminateProcessChk;
    private LockCheckBox stopServiceLock;
    private JCheckBox stopServiceChk;
    private BASHNotificationsObject hppNotifications;

    public HppBASHNotificationsPane() {
        this.init();
    }

    public void setObject(BASHNotificationsObject hppNotifications) throws ConsoleException {
        if (hppNotifications == null) {
            return;
        }
        this.hppNotifications = hppNotifications;
        this.updateControls();
    }

    private void init() {
        this.hppNotifications = new BASHNotificationsObject();
        this.createControls();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHppBASHNotificationsPane(), "Center");
    }

    public void updateControls() {
        if (this.hppNotifications == null) {
            return;
        }
        Boolean enableDisplayResults = this.hppNotifications.getDisplayAlert();
        this.displayResultsChk.setSelected(enableDisplayResults);
        Boolean enableDisplayLock = this.hppNotifications.getLockDisplayAlert();
        this.displayResultsLock.setSelected(enableDisplayLock);
        Boolean enableTerminateProc = this.hppNotifications.getPromptTerminateProcess();
        this.terminateProcessChk.setSelected(enableTerminateProc);
        Boolean enableTerminateLock = this.hppNotifications.getLockPromptTerminateProcess();
        this.terminateProcessLock.setSelected(enableTerminateLock);
        Boolean enableStopService = this.hppNotifications.getPromptStopService();
        this.stopServiceChk.setSelected(enableStopService);
        Boolean enableStopServiceLock = this.hppNotifications.getLockPromptStopService();
        this.stopServiceLock.setSelected(enableStopServiceLock);
    }

    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_hpp_notifications";
    }

    private void createControls() {
        this.displayResultsLock = new LockCheckBox(Boolean.FALSE);
        this.displayResultsLock.setSelectedIcon(AvConstants.lockIcon);
        this.terminateProcessLock = new LockCheckBox(Boolean.FALSE);
        this.terminateProcessLock.setSelectedIcon(AvConstants.lockIcon);
        this.stopServiceLock = new LockCheckBox(Boolean.FALSE);
        this.stopServiceLock.setSelectedIcon(AvConstants.lockIcon);
        this.displayResultsChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBASHNotificationsPane.displayResults"));
        this.terminateProcessChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBASHNotificationsPane.promptTerminateProcess"));
        this.stopServiceChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBASHNotificationsPane.promptStopService"));
    }

    private JPanel getHppBASHNotificationsPane() {
        JLabel jLblNotifications = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBASHNotificationsPane.whenDetectionFound"));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        this.addComponent(contentPanel, jLblNotifications, constraints, 0, 0, 0.0, 0, new Insets(0, 50, 0, 0));
        this.addComponent(contentPanel, this.displayResultsLock, constraints, 1, 0, 0.0, 0, new Insets(0, 30, 0, 0));
        this.addComponent(contentPanel, this.displayResultsChk, constraints, 2, 0, 1.0, 2, new Insets(0, 5, 0, 0));
        this.addComponent(contentPanel, this.terminateProcessLock, constraints, 1, 1, 0.0, 0, new Insets(0, 30, 0, 0));
        this.addComponent(contentPanel, this.terminateProcessChk, constraints, 2, 1, 1.0, 2, new Insets(0, 5, 0, 0));
        this.addComponent(contentPanel, this.stopServiceLock, constraints, 1, 2, 0.0, 0, new Insets(0, 30, 0, 0));
        this.addComponent(contentPanel, this.stopServiceChk, constraints, 2, 2, 1.0, 2, new Insets(0, 5, 0, 0));
        return contentPanel;
    }

    private void addComponent(Container container, JComponent comp, GridBagConstraints gbConstraint, int xPos, int yPos, double weightX, int fill, Insets inset) {
        if (gbConstraint == null) {
            gbConstraint = new GridBagConstraints();
        }
        gbConstraint.anchor = 23;
        gbConstraint.gridx = xPos;
        gbConstraint.gridy = yPos;
        gbConstraint.weightx = weightX;
        gbConstraint.fill = fill;
        gbConstraint.insets = inset == null ? new Insets(0, 0, 0, 0) : inset;
        container.add((Component)comp, gbConstraint);
    }

    public BASHNotificationsObject getModelObject() {
        return this.hppNotifications;
    }

    public void saveObject() {
        if (this.hppNotifications == null) {
            return;
        }
        this.hppNotifications.setLockDisplayAlert(this.displayResultsLock.isSelected());
        this.hppNotifications.setDisplayAlert(this.displayResultsChk.isSelected());
        this.hppNotifications.setLockPromptTerminateProcess(this.terminateProcessLock.isSelected());
        this.hppNotifications.setPromptTerminateProcess(this.terminateProcessChk.isSelected());
        this.hppNotifications.setLockPromptStopService(this.stopServiceLock.isSelected());
        this.hppNotifications.setPromptStopService(this.stopServiceChk.isSelected());
    }

    public void setPanelEnabled(boolean enabled) {
        this.displayResultsLock.setEnabled(enabled);
        this.displayResultsChk.setEnabled(enabled);
        this.terminateProcessLock.setEnabled(enabled);
        this.terminateProcessChk.setEnabled(enabled);
        this.stopServiceLock.setEnabled(enabled);
        this.stopServiceChk.setEnabled(enabled);
    }
}

