/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.hpp;

import com.sygate.scm.common.configobject.schema.BASHPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.BASHNetworkSettingsObject;
import com.sygate.scm.console.logicobject.BASHPolicyObject;
import com.sygate.scm.console.logicobject.BASHSystemChangesObject;
import com.sygate.scm.console.ui.policy.av.hpp.HppBASHNotificationsPane;
import com.sygate.scm.console.ui.policy.av.hpp.HppConfidenceSettingsPane;
import com.sygate.scm.console.ui.policy.av.hpp.HppNetworkSettingsPane;
import com.sygate.scm.console.ui.policy.av.hpp.HppSystemChangesPane;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;

public class HppBASHConfigPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private HppConfidenceSettingsPane hppConfidenceSettingsPane;
    private HppBASHNotificationsPane hppBASHNotificationsPane;
    private HppSystemChangesPane hppSystemChangesPane;
    private HppNetworkSettingsPane hppNetworkSettingsPane;
    private transient BASHPolicyObject objBASHPolicy;

    public HppBASHConfigPane() {
        this.init();
    }

    public void setObject(BASHPolicy bashPolicy) throws ConsoleException {
        this.setObject(new BASHPolicyObject(bashPolicy));
    }

    public void setObject(BASHPolicyObject bashPolicyDetails) throws ConsoleException {
        if (bashPolicyDetails == null) {
            return;
        }
        this.objBASHPolicy = bashPolicyDetails;
        this.hppConfidenceSettingsPane.setObject(this.objBASHPolicy.getConfidenceSettingsObject());
        this.hppBASHNotificationsPane.setObject(this.objBASHPolicy.getNotificationsObject());
        this.hppSystemChangesPane.setObject(this.objBASHPolicy.getSystemChangesObject());
        this.hppNetworkSettingsPane.setObject(this.objBASHPolicy.getNetworkSettingsObject());
        this.updateControls();
    }

    private void init() {
        this.objBASHPolicy = new BASHPolicyObject();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getBASHConfigPanel());
        this.add(this.getHppConfidenceSettingsPane());
        this.add(this.getHppBASHNotificationsPane());
        this.add(this.getHppSystemChangesPane());
        this.add(this.getHppNetworkSettingsPane());
    }

    private JPanel getBASHConfigPanel() {
        String strTruScanHelpText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBASHConfigPane.truScanHelpText");
        HtmlEnabledJLabel jLblTruScanHelp = new HtmlEnabledJLabel(strTruScanHelpText, true);
        jLblTruScanHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
        jLblTruScanHelp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_hpp_scan_details_whatis_sonar");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)jLblTruScanHelp, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 0, 5, 0), 0, 0));
        return panel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_hpp_sonar_scan_details";
    }

    private HppConfidenceSettingsPane getHppConfidenceSettingsPane() {
        if (this.hppConfidenceSettingsPane == null) {
            this.hppConfidenceSettingsPane = new HppConfidenceSettingsPane();
        }
        return this.hppConfidenceSettingsPane;
    }

    private HppBASHNotificationsPane getHppBASHNotificationsPane() {
        if (this.hppBASHNotificationsPane == null) {
            this.hppBASHNotificationsPane = new HppBASHNotificationsPane();
        }
        return this.hppBASHNotificationsPane;
    }

    private HppSystemChangesPane getHppSystemChangesPane() {
        if (this.hppSystemChangesPane == null) {
            this.hppSystemChangesPane = new HppSystemChangesPane();
        }
        return this.hppSystemChangesPane;
    }

    private HppNetworkSettingsPane getHppNetworkSettingsPane() {
        if (this.hppNetworkSettingsPane == null) {
            this.hppNetworkSettingsPane = new HppNetworkSettingsPane();
        }
        return this.hppNetworkSettingsPane;
    }

    private void updateControls() {
        this.hppConfidenceSettingsPane.setPanelEnabled(true);
        this.hppBASHNotificationsPane.setPanelEnabled(true);
        this.hppSystemChangesPane.setPanelEnabled(true);
        this.hppNetworkSettingsPane.setPanelEnabled(true);
    }

    public void saveObject() throws ConsoleException {
        this.objBASHPolicy.setEnabled(true);
        this.objBASHPolicy.setLocked(true);
        this.hppConfidenceSettingsPane.saveObject();
        this.objBASHPolicy.setConfidenceSettingsObject(this.hppConfidenceSettingsPane.getModelObject());
        this.hppSystemChangesPane.saveObject();
        BASHSystemChangesObject systemChanges = this.hppSystemChangesPane.getModelObject();
        this.objBASHPolicy.setSystemChangesObject(systemChanges);
        this.hppBASHNotificationsPane.saveObject();
        this.objBASHPolicy.setNotificationsObject(this.hppBASHNotificationsPane.getModelObject());
        this.hppNetworkSettingsPane.saveObject();
        BASHNetworkSettingsObject networkSettings = this.hppNetworkSettingsPane.getModelObject();
        this.objBASHPolicy.setNetworkSettingsObject(networkSettings);
    }

    public BASHPolicyObject getModelObject() {
        return this.objBASHPolicy;
    }
}

