/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.globalscan;

import com.sygate.scm.common.configobject.schema.ApAdvancedScanSettings;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.AvScanSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.BloodhoundScanSettingPanel;
import com.sygate.scm.console.ui.policy.av.general.ChangePasswdDlg;
import com.sygate.scm.console.ui.policy.av.logicobject.AdvancedScanSettingsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GlobalScanOptionsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane scanLessSettingPane;
    private AvTemplatePane scanPane;
    private AvTemplatePane avScanPane;
    private BloodhoundScanSettingPanel bloodHoundPanel;
    private GeneralInfoObject generalInfoObj;
    private JCheckBox scanLessChk;
    private LockCheckBox lockScanLessChk;
    private JComboBox<String> trustedBox;
    private JCheckBox scanCheckBox;
    private JCheckBox notificationWhenLoggedOffBox;
    private JButton changePasswdBtn = new JButton();
    private String scanNetDrivePasswd;
    private boolean m_bPasswordChange = false;
    private ApFileScanDetailsObject fileScanObj;
    private AdvancedScanSettingsObject advancedScanObj;
    private AvScanPolicy scanPolicy;
    private AvScanSettings avScanSettings;

    public GlobalScanOptionsPanel() {
        this.initGUI();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_global_scan_options";
    }

    public void initGUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.setLayout(new BorderLayout());
        panel.add(this.getScanLessPanel());
        panel.add(this.getBloodHoundScanSettingPane());
        JPanel scanPanel = this.getScanPane();
        panel.add(scanPanel);
        panel.add(this.getScheduledScansAdvPane());
        this.add((Component)panel, "North");
    }

    public void setObject(GeneralInfoObject obj, ApFileScanDetailsObject fileScanObj, AvScanPolicy scanPolicy) {
        this.generalInfoObj = obj;
        this.fileScanObj = fileScanObj;
        this.scanPolicy = scanPolicy;
        this.updatePanel();
    }

    private void updatePanel() {
        Boolean b;
        boolean useScanNetDrivePassword = this.generalInfoObj.getUseScanNetDrivePassword();
        this.scanCheckBox.setSelected(useScanNetDrivePassword);
        this.changePasswdBtn.setEnabled(useScanNetDrivePassword);
        this.lockScanLessChk.setSelected(this.generalInfoObj.getLockEnabledScanLess());
        this.scanLessChk.setSelected(this.generalInfoObj.getEnabledScanLess());
        this.trustedBox.setSelectedIndex(this.generalInfoObj.getSymantecTrustedSign());
        this.advancedScanObj = this.fileScanObj.getApAdvancedScanSettings() == null ? new AdvancedScanSettingsObject(new ApAdvancedScanSettings()) : new AdvancedScanSettingsObject(this.fileScanObj.getApAdvancedScanSettings());
        this.bloodHoundPanel.setObject(this.advancedScanObj.getHeuristicsOptions());
        this.avScanSettings = this.scanPolicy.getOptAvScanSettings();
        if (this.avScanSettings == null) {
            this.avScanSettings = new AvScanSettings();
        }
        if ((b = this.avScanSettings.getOptNotificationWhenLoggedOff()) == null) {
            b = this.avScanSettings.getDefNotificationWhenLoggedOff();
        }
        this.notificationWhenLoggedOffBox.setSelected(b);
    }

    public void save() {
        this.saveData();
    }

    private void saveData() {
        this.generalInfoObj.setEnabledScanLess(this.scanLessChk.isSelected());
        this.generalInfoObj.setLockEnabledScanLess(this.lockScanLessChk.isSelected());
        this.generalInfoObj.setSymantecTrustedSign(this.trustedBox.getSelectedIndex());
        boolean bCurrentScanCheckBox = this.scanCheckBox.isSelected();
        this.generalInfoObj.setUseScanNetDrivePassword(bCurrentScanCheckBox);
        if (bCurrentScanCheckBox && this.m_bPasswordChange) {
            this.generalInfoObj.setScanNetDrivePassword(this.scanNetDrivePasswd == null ? this.generalInfoObj.getDefNetScanPassword() : Utility.calculateHash((String)this.scanNetDrivePasswd));
            try {
                this.generalInfoObj.setScanNetDrivePassword2(this.scanNetDrivePasswd == null ? this.generalInfoObj.getDefNetScanPassword2() : Utility.calculateHashLatest_DefaultSaltLength((String)this.scanNetDrivePasswd));
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "errorSettingnetworkScanPassword"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "error"), 0);
            }
        }
        this.advancedScanObj.setLockBloodhoundOptions(this.bloodHoundPanel.isLockEnabled());
        this.advancedScanObj.setEnableBloodhound(this.bloodHoundPanel.isBloodhoundEnabled());
        this.advancedScanObj.setBloodhoundLevel(this.bloodHoundPanel.getProtectionLevel());
        this.fileScanObj.setApAdvancedScanSettings(this.advancedScanObj);
        this.avScanSettings.setOptNotificationWhenLoggedOff(Boolean.valueOf(this.notificationWhenLoggedOffBox.isSelected()));
        this.scanPolicy.setOptAvScanSettings(this.avScanSettings);
    }

    private JPanel getBloodHoundScanSettingPane() {
        if (this.bloodHoundPanel == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.HeuristicScanSetting");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.HeuristicScanSettingDesc");
            this.bloodHoundPanel = new BloodhoundScanSettingPanel(title, desc, true);
        }
        return this.bloodHoundPanel;
    }

    private JPanel getScanPane() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.label.scan");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.label.scanDesc");
        this.scanPane = new AvTemplatePane(title, desc);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        this.scanCheckBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.checkbox.scan"));
        this.scanCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalScanOptionsPanel.this.enableAppropriate();
            }
        });
        c.insets = new Insets(3, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)this.scanCheckBox, c);
        this.changePasswdBtn = new JButton();
        this.changePasswdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.button.changePswd"));
        c.insets = new Insets(3, 45, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)this.changePasswdBtn, c);
        this.changePasswdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChangePasswdDlg dlg = new ChangePasswdDlg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.dialog.changePassword.title"));
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    GlobalScanOptionsPanel.this.m_bPasswordChange = true;
                    GlobalScanOptionsPanel.this.scanNetDrivePasswd = dlg.getNewPassword();
                }
                dlg.dispose();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)pane, "Before");
        this.scanPane.add(panel);
        return this.scanPane;
    }

    private void enableAppropriate() {
        this.changePasswdBtn.setEnabled(this.scanCheckBox.isSelected());
        this.m_bPasswordChange = true;
    }

    private JPanel getScheduledScansAdvPane() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "AvSchedScanTab.label.apSchedScanAdvTitle");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "AvSchedScanTab.label.apSchedScanAdvDesc");
        this.avScanPane = new AvTemplatePane(title, desc);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        this.notificationWhenLoggedOffBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "AvSchedScanTab.checkbox.notificationWhenLoggedOffBox"));
        c.insets = new Insets(3, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)this.notificationWhenLoggedOffBox, c);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)pane, "Before");
        this.avScanPane.add(panel);
        return this.avScanPane;
    }

    private JPanel getScanLessPanel() {
        if (this.scanLessSettingPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.scanlessSettings.title");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.scanlessSettings.desc");
            this.scanLessChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.scanless"));
            this.scanLessChk.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        GlobalScanOptionsPanel.this.trustedBox.setEnabled(true);
                    } else {
                        GlobalScanOptionsPanel.this.trustedBox.setEnabled(false);
                    }
                }
            });
            this.lockScanLessChk = new LockCheckBox(Boolean.FALSE);
            this.lockScanLessChk.setSelectedIcon(AvConstants.lockIcon);
            this.trustedBox = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.box.symantecAndCommunityTrusted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.box.symantecTrustedOnly")});
            JPanel techPanel = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            techPanel.setLayout(gridBag);
            techPanel.add((Component)this.lockScanLessChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            techPanel.add((Component)this.scanLessChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            techPanel.add(this.trustedBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 0, 0), 0, 0));
            techPanel.add((Component)this.getScanLessHelpLinkLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.help.scanleeHelpText")), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.enableAppropriateScanLessSettings();
            this.scanLessSettingPane = new AvTemplatePane(title, desc);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)techPanel, "Before");
            this.scanLessSettingPane.add(panel);
        }
        return this.scanLessSettingPane;
    }

    private void enableAppropriateScanLessSettings() {
        boolean isChecked = this.scanLessChk.isSelected();
        this.trustedBox.setEnabled(isChecked);
    }

    private HtmlEnabledJLabel getScanLessHelpLinkLabel(String securityText) {
        HtmlEnabledJLabel securityHelpLinkLabel = new HtmlEnabledJLabel(securityText, true);
        securityHelpLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
        securityHelpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_auto_protect_files_processes_scan_details_whatis_scanless");
            }
        });
        securityHelpLinkLabel.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return securityHelpLinkLabel;
    }
}

