/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.globalscan;

import com.sygate.scm.common.configobject.schema.ElamDriverOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ElamDriverOptionsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane elamDriverSettingPane;
    private AvTemplatePane alterDriverResultsPane;
    private JRadioButton unknownRBtn;
    private JRadioButton knownBadRBtn;
    private JCheckBox elamChk;
    private LockCheckBox lockElamChk;
    AvPolicyObject avPolicyObj = null;

    public ElamDriverOptionsPanel() {
        this.initGUI();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_elam_options";
    }

    public void initGUI() {
        JPanel panel = new JPanel();
        VerticalFlowLayout layout = new VerticalFlowLayout();
        panel.setLayout(layout);
        this.setLayout(new BorderLayout());
        panel.add(this.getElamDriverOptionsPanel());
        panel.add(this.getdriverSelectionPane());
        this.add((Component)panel, "North");
    }

    public void setObject(AvPolicyObject obj) {
        this.avPolicyObj = obj;
        this.updatePanel();
    }

    private void updatePanel() {
        this.elamChk.setSelected(this.avPolicyObj.getEnableElamDriver());
        this.lockElamChk.setSelected(this.avPolicyObj.getLockEnableElamDriver());
        int alterElamResults = this.avPolicyObj.getAlterElamDriverResult();
        if (alterElamResults == ElamDriverOptions.UNKNOWN) {
            this.unknownRBtn.setSelected(true);
        } else if (alterElamResults == ElamDriverOptions.KNOWNBAD) {
            this.knownBadRBtn.setSelected(true);
        }
        if (this.elamChk.isSelected()) {
            this.unknownRBtn.setEnabled(true);
            this.knownBadRBtn.setEnabled(true);
        } else {
            this.unknownRBtn.setEnabled(false);
            this.knownBadRBtn.setEnabled(false);
        }
    }

    public void save() {
        this.saveData();
    }

    private void saveData() {
        this.avPolicyObj.setEnableElamDriver(this.elamChk.isSelected());
        this.avPolicyObj.setLockEnableElamDriver(this.lockElamChk.isSelected());
        int alterElamResults = ElamDriverOptions.KNOWNBAD;
        if (this.unknownRBtn.isSelected()) {
            alterElamResults = ElamDriverOptions.UNKNOWN;
        } else if (this.knownBadRBtn.isSelected()) {
            alterElamResults = ElamDriverOptions.KNOWNBAD;
        }
        this.avPolicyObj.setAlterElamDriverResult(alterElamResults);
    }

    private JPanel getElamDriverOptionsPanel() {
        if (this.elamDriverSettingPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverDetailsPane.elam.title");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverDetailsPane.elam.desc");
            String optiondesc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverOptionsPane.elam.moredesc");
            this.elamChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverDetailsPane.checkbox.elamdriver"));
            this.elamChk.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ElamDriverOptionsPanel.this.unknownRBtn.setEnabled(true);
                        ElamDriverOptionsPanel.this.knownBadRBtn.setEnabled(true);
                    } else {
                        ElamDriverOptionsPanel.this.unknownRBtn.setEnabled(false);
                        ElamDriverOptionsPanel.this.knownBadRBtn.setEnabled(false);
                    }
                }
            });
            this.lockElamChk = new LockCheckBox(Boolean.FALSE);
            this.lockElamChk.setSelectedIcon(AvConstants.lockIcon);
            String strTruScanHelpText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverDetailsPane.elamHelpText");
            HtmlEnabledJLabel jLblTruScanHelp = new HtmlEnabledJLabel(strTruScanHelpText, true);
            jLblTruScanHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
            jLblTruScanHelp.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_elam_whatis_elam");
                }
            });
            DescriptionTextArea descLabel = new DescriptionTextArea(optiondesc, 60);
            JPanel techPanel = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            techPanel.setLayout(gridBag);
            techPanel.add((Component)this.lockElamChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            techPanel.add((Component)this.elamChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            techPanel.add((Component)jLblTruScanHelp, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 22, 17, new Insets(5, 0, 5, 0), 0, 0));
            techPanel.add((Component)descLabel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.elamDriverSettingPane = new AvTemplatePane(title, desc);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)techPanel, "Before");
            this.elamDriverSettingPane.add(p);
        }
        return this.elamDriverSettingPane;
    }

    private JPanel getdriverSelectionPane() {
        if (this.alterDriverResultsPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverOptionsPane.action.optionsTitle");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverOptionsPane.action.optionsDesc");
            this.alterDriverResultsPane = new AvTemplatePane(title, desc);
            this.unknownRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverOptionsPane.radio.unknown"));
            this.knownBadRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ElamDriverOptionsPane.radio.knownBad"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.unknownRBtn);
            group.add(this.knownBadRBtn);
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 27, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)this.unknownRBtn, c);
            c.gridx = 0;
            c.gridy = 1;
            pane.add((Component)this.knownBadRBtn, c);
            pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)pane, "Before");
            this.alterDriverResultsPane.add(p);
        }
        return this.alterDriverResultsPane;
    }

    public boolean valuesValid() {
        return true;
    }
}

