/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.general.CSChangePasswdDlg;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SharedInsightCachePane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane SICSettingsPane;
    private JCheckBox enableSIC;
    private JCheckBox requireSSL;
    private JLabel csHostName;
    private JTextField csTFHostName;
    private JLabel csPort;
    private JTextField csTFPort;
    private JLabel csUser;
    private JTextField csTFUser;
    private String csTFPasswd;
    private JButton changeScanCacheServerPasswdBtn = new JButton();
    private static int MAX_STRING_LENGTH = 255;
    private GeneralInfoObject generalInfoObj;

    public SharedInsightCachePane() {
        this.initGUI();
    }

    public void save() {
        this.saveData();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getSICSettingsPane());
    }

    private JPanel getSICSettingsPane() {
        if (this.SICSettingsPane == null) {
            String title = this.getRes("title.CacheServer");
            String desc = this.getRes("desc.CacheServer");
            this.SICSettingsPane = new AvTemplatePane(title, desc);
            this.enableSIC = new JCheckBox(this.getRes("checkbox.csEnable"));
            this.enableSIC.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SharedInsightCachePane.this.enableSIC.setFocusPainted(true);
                    SharedInsightCachePane.this.enableSICSetting();
                }
            });
            this.requireSSL = new JCheckBox(this.getRes("checkbox.csRequireSSL"));
            this.csHostName = new JLabel(this.getRes("label.csHostname"));
            this.csTFHostName = new JTextField(15);
            this.csTFHostName.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(255);
            nameDoc.setValidator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.:", true);
            this.csTFHostName.setDocument(nameDoc);
            this.csPort = new JLabel(this.getRes("label.csPort"));
            this.csTFPort = new JTextField();
            this.csTFPort.setColumns(5);
            this.csTFPort.setDocument(new NumberPlainDocument(65535L, true));
            this.csUser = new JLabel(this.getRes("label.csUsername"));
            this.csTFUser = new JTextField(15);
            this.csTFUser.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            RestrictedPlainDocument userDoc = new RestrictedPlainDocument(MAX_STRING_LENGTH);
            this.csTFUser.setDocument(userDoc);
            this.changeScanCacheServerPasswdBtn = new JButton();
            this.changeScanCacheServerPasswdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.button.changePswd"));
            this.changeScanCacheServerPasswdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CSChangePasswdDlg dlg = new CSChangePasswdDlg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.dialog.changePassword.title"));
                    dlg.allowNullPassword(true);
                    dlg.setVisible(true);
                    if (dlg.isOk()) {
                        SharedInsightCachePane.this.csTFPasswd = dlg.getNewPassword();
                    }
                    dlg.dispose();
                }
            });
            int yval = 0;
            int xval = 0;
            JPanel pane1 = new JPanel();
            pane1.setLayout(new GridBagLayout());
            pane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 0;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = xval;
            c.gridy = yval++;
            c.gridwidth = 4;
            pane1.add((Component)this.enableSIC, c);
            int leftinset = 20;
            int labeloffset = 2;
            c.insets = new Insets(0, 20, 0, 10);
            c.gridx = xval;
            c.gridy = yval++;
            c.gridwidth = 4;
            pane1.add((Component)this.requireSSL, c);
            c.insets = new Insets(0, 22, 0, 10);
            c.gridx = xval++;
            c.gridy = yval;
            c.gridwidth = 1;
            pane1.add((Component)this.csHostName, c);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = xval++;
            c.gridy = yval;
            pane1.add((Component)this.csTFHostName, c);
            c.gridx = xval++;
            c.gridy = yval;
            c.insets = new Insets(0, 20, 0, 10);
            pane1.add((Component)this.csPort, c);
            c.gridx = xval;
            c.gridy = yval++;
            c.insets = new Insets(0, 0, 0, 0);
            pane1.add((Component)this.csTFPort, c);
            xval = 0;
            c.gridx = xval++;
            c.gridy = yval;
            c.insets = new Insets(3, 22, 0, 10);
            c.weightx = 0.0;
            pane1.add((Component)this.csUser, c);
            c.gridx = xval;
            c.gridy = yval++;
            c.insets = new Insets(3, 0, 0, 0);
            pane1.add((Component)this.csTFUser, c);
            xval = 0;
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = xval;
            c.gridy = yval++;
            c.gridwidth = 4;
            pane1.add((Component)this.changeScanCacheServerPasswdBtn, c);
            xval = 0;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = xval;
            c.gridy = yval;
            pane1.add((Component)this.getScanCacheServerHelpLinkLabel(this.getRes("label.helpcache")), c);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)pane1, "Before");
            this.SICSettingsPane.add(mainPanel);
        }
        return this.SICSettingsPane;
    }

    private void updatePanel() {
        if (!LicenseObject.getInstance().isSBProduct()) {
            boolean networkSICEnabled = this.generalInfoObj.getScanCacheServerEnabled();
            this.enableSIC.setSelected(networkSICEnabled);
            this.enableSICSetting();
            this.requireSSL.setSelected(this.generalInfoObj.getScanCacheServerRequireSSL());
            this.csTFHostName.setText(this.generalInfoObj.getScanCacheServerHostname());
            this.csTFPort.setText(String.valueOf(this.generalInfoObj.getScanCacheServerPort()));
            this.csTFUser.setText(this.generalInfoObj.getScanCacheServerUsername());
            this.csTFPasswd = this.generalInfoObj.getScanCacheServerPassword();
        }
    }

    private void saveData() {
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.generalInfoObj.setScanCacheServerEnabled(this.enableSIC.isSelected());
            this.generalInfoObj.setScanCacheServerRequireSSL(this.requireSSL.isSelected());
            this.generalInfoObj.setScanCacheServerHostname(this.csTFHostName.getText());
            this.generalInfoObj.setScanCacheServerPort(Integer.parseInt(this.csTFPort.getText()));
            this.generalInfoObj.setScanCacheServerUsername(this.csTFUser.getText());
            this.generalInfoObj.setScanCacheServerPassword(this.csTFPasswd);
        }
    }

    private void enableSICSetting() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return;
        }
        this.enableNetworkSICSetting();
    }

    private void enableNetworkSICSetting() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return;
        }
        boolean enabled = this.enableSIC.isSelected();
        this.requireSSL.setEnabled(enabled);
        this.csHostName.setEnabled(enabled);
        this.csTFHostName.setEnabled(enabled);
        this.csPort.setEnabled(enabled);
        this.csTFPort.setEnabled(enabled);
        this.csUser.setEnabled(enabled);
        this.csTFUser.setEnabled(enabled);
        this.changeScanCacheServerPasswdBtn.setEnabled(enabled);
    }

    private HtmlEnabledJLabel getScanCacheServerHelpLinkLabel(String cacheServerText) {
        HtmlEnabledJLabel scanCacheServerHelpLinkLabel = new HtmlEnabledJLabel(cacheServerText, true);
        scanCacheServerHelpLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
        scanCacheServerHelpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_ads_scans_whatis_shared_insight_cache");
            }
        });
        scanCacheServerHelpLinkLabel.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return scanCacheServerHelpLinkLabel;
    }

    public boolean valuesValid() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        if (!this.enableSIC.isSelected()) {
            return true;
        }
        if (this.csTFHostName.getText() == null || this.csTFHostName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.hostnameEmptyError"), this.getRes("label.error"), 0);
            return false;
        }
        if (this.csTFPort.getText() == null || this.csTFPort.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.portEmptyError"), this.getRes("label.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_misc_shared_insight_cache";
    }

    public void setObject(GeneralInfoObject obj) {
        this.generalInfoObj = obj;
        this.updatePanel();
    }

    private String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", component + key);
    }

    private String getRes(String key) {
        return this.getRes("SharedInsightCachePane.", key);
    }
}

