/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NotificationsMsgDlg
extends DialogBase
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final int MAX_MESSAGE_LENGTH = 255;
    private JTextArea jTAMessage = null;
    private String description;
    private String helpConstant;
    private int allowedMaxMessageLength = 255;

    public NotificationsMsgDlg(String title, String desc, String message, String helpConstant, boolean isNonShared) {
        this(title, desc, message, 255, helpConstant, isNonShared);
    }

    public NotificationsMsgDlg(String title, String desc, String message, int maxMessageLength, String helpConstant, boolean isNonShared) {
        super(Manager.getFrame(), title, true);
        this.description = desc;
        this.helpConstant = helpConstant;
        if (maxMessageLength >= 0) {
            this.allowedMaxMessageLength = maxMessageLength;
        }
        this.initialize();
        this.initData(message);
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context) && !isNonShared) {
            this.jTAMessage.setEditable(false);
            this.resetOKButton(false);
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.helpConstant;
    }

    private JTextArea getTAMessage() {
        if (this.jTAMessage == null) {
            this.jTAMessage = new JTextArea(new RestrictedPlainDocument(this.allowedMaxMessageLength), "", 6, 40);
        }
        return this.jTAMessage;
    }

    public String getMessage() {
        return this.getTAMessage().getText();
    }

    private void initialize() {
        this.getContentPane().add(this.getInnerPanel());
        this.pack();
    }

    private JPanel getInnerPanel() {
        this.getTAMessage().setWrapStyleWord(true);
        this.getTAMessage().setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.getTAMessage());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.description), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 10, 15), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void initData(String message) {
        if (this.allowedMaxMessageLength > 0 && message != null && message.trim().length() > 0) {
            String msg = message;
            if (message.length() > this.allowedMaxMessageLength) {
                try {
                    msg = message.substring(0, this.allowedMaxMessageLength - 1);
                }
                catch (Exception e) {
                    ConsoleLogger.log(e);
                }
            }
            this.getTAMessage().setText(msg);
            this.getTAMessage().setCaretPosition(0);
        }
    }
}

