/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.configobject.schema.AvVirusDefOptions;
import com.sygate.scm.common.configobject.schema.MissingDefMessageToDisplay;
import com.sygate.scm.common.configobject.schema.PatternWarningMessage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.general.NotificationsMsgDlg;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class NotificationPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    public JPanel actionsPanel;
    public JPanel actionsOutDatedDaysPanel;
    public JPanel actionsRemediationAttemptsPane;
    public JCheckBox dispOutdatedMsgChk;
    public JCheckBox dispMissingDefMsgChk;
    public JSpinner daysSpin;
    public JSpinner attemptsSpin;
    public AlwaysEnabledButton outDatedMsgBtn;
    public AlwaysEnabledButton attemptsMsgBtn;
    public JLabel warnAfterOutdatedLbl;
    public JLabel warnAfterRemedLbl;
    public JLabel whenDefOutdated;
    public JLabel whenWithoutDef;
    public JLabel daysLbl;
    JLabel iconLabel;
    public JLabel attemptsLbl;
    private JPanel displayPane;
    private AvVirusDefOptions avVirusDefOptions;
    private GeneralInfoObject generalInfoObj;
    private JPanel popupSettingPanel;
    private JCheckBox popupChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.checkbox.popup"));
    private JRadioButton customRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.radiobutton.custom"));
    private JRadioButton defaultRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.radiobutton.default"));
    private JTextField customURLTf = new JTextField(37);
    private AlwaysEnabledButton customizeBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.button.customize"));
    private boolean isPolicyNonShared;

    public NotificationPane() {
        this.initGUI();
    }

    public void save() {
        this.saveData();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        BoxLayout pLayout = new BoxLayout(panel, 1);
        panel.setLayout(pLayout);
        this.setLayout(new BorderLayout());
        panel.add(this.getDisplayPane());
        this.add((Component)panel, "North");
    }

    private JPanel getDisplayPane() {
        if (this.displayPane != null) {
            return this.displayPane;
        }
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.panel.actionsLabel");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.actionsDesc");
        this.displayPane = new AvTemplatePane(title, desc);
        this.displayPane.add(this.getActionsPane());
        return this.displayPane;
    }

    private JPanel getActionsPane() {
        if (this.actionsPanel != null) {
            return this.actionsPanel;
        }
        this.actionsPanel = new JPanel();
        this.actionsPanel.setLayout(new BorderLayout());
        this.dispOutdatedMsgChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.checkbox.outdatedMessageWin"));
        this.dispMissingDefMsgChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.checkbox.runningWithoutVirusDefWin"));
        this.whenDefOutdated = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.whenDefOutdated"));
        this.whenWithoutDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.whenWithoutDef"));
        this.warnAfterOutdatedLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.warnAfter"));
        this.warnAfterRemedLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.warnAfter"));
        this.daysLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.days"));
        this.attemptsLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.attempts"));
        this.outDatedMsgBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.button.msgWarning"));
        this.attemptsMsgBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.button.msgWarning"));
        this.attemptsMsgBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationPane.this.addWarningMessage(e);
            }
        });
        this.outDatedMsgBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationPane.this.addWarningMessage(e);
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 23;
        gc.insets = new Insets(5, 20, 0, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 3;
        pane.add((Component)this.whenDefOutdated, gc);
        gc.insets = new Insets(5, 40, 0, 5);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 3;
        gc.fill = 0;
        gc.anchor = 17;
        pane.add((Component)this.getActionsOutdatedDayPane(), gc);
        gc.insets = new Insets(5, 60, 0, 5);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.dispOutdatedMsgChk, gc);
        gc.insets = new Insets(5, 10, 5, 10);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.outDatedMsgBtn, gc);
        gc.insets = new Insets(10, 20, 0, 5);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 3;
        gc.fill = 0;
        gc.anchor = 17;
        pane.add((Component)this.whenWithoutDef, gc);
        gc.insets = new Insets(5, 40, 0, 5);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 3;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.getActionsRemediationAttemptsPane(), gc);
        gc.insets = new Insets(5, 60, 0, 5);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 1;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.dispMissingDefMsgChk, gc);
        gc.insets = new Insets(5, 10, 0, 10);
        gc.gridx = 1;
        gc.gridy = 5;
        gc.gridwidth = 1;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.attemptsMsgBtn, gc);
        gc.insets = new Insets(5, 20, 5, 5);
        gc.gridx = 0;
        gc.gridy = 6;
        gc.gridwidth = 3;
        gc.anchor = 17;
        gc.fill = 0;
        pane.add((Component)this.getPopupSettingPanel(), gc);
        this.actionsPanel.add((Component)pane, "Before");
        return this.actionsPanel;
    }

    private JPanel getActionsRemediationAttemptsPane() {
        if (this.actionsRemediationAttemptsPane != null) {
            return this.actionsRemediationAttemptsPane;
        }
        this.actionsRemediationAttemptsPane = new JPanel();
        this.actionsRemediationAttemptsPane.setLayout(new GridBagLayout());
        this.attemptsSpin = new JSpinner(new SpinnerNumberModel(2, 1, 10, 1));
        UIUtilities.enableOnlyValidEdits(this.attemptsSpin);
        this.attemptsLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.attemptsWin"));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.anchor = 17;
        this.actionsRemediationAttemptsPane.add((Component)this.attemptsLbl, gc);
        gc.insets = new Insets(0, 5, 0, 0);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.anchor = 17;
        this.actionsRemediationAttemptsPane.add((Component)this.attemptsSpin, gc);
        this.iconLabel = this.createBadge();
        gc.gridx = 2;
        gc.gridy = 0;
        gc.insets = new Insets(0, 7, 0, 0);
        this.actionsRemediationAttemptsPane.add((Component)this.iconLabel, gc);
        return this.actionsRemediationAttemptsPane;
    }

    private JLabel createBadge() {
        this.iconLabel = new JLabel();
        this.iconLabel.setIcon(UIUtilities.DEPRECATED_LINUX_ICON);
        this.iconLabel.setHorizontalTextPosition(2);
        this.iconLabel.setToolTipText(UIUtilities.SETTING_NOT_REQUIRED_STARTING_14_3_RU3_TIP);
        return this.iconLabel;
    }

    private JPanel getActionsOutdatedDayPane() {
        if (this.actionsOutDatedDaysPanel != null) {
            return this.actionsOutDatedDaysPanel;
        }
        this.actionsOutDatedDaysPanel = new JPanel();
        this.actionsOutDatedDaysPanel.setLayout(new GridBagLayout());
        this.daysSpin = new JSpinner(new SpinnerNumberModel(90, 0, 99, 1));
        UIUtilities.enableOnlyValidEdits(this.daysSpin);
        this.daysLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.daysWin"));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.anchor = 17;
        this.actionsOutDatedDaysPanel.add((Component)this.daysLbl, gc);
        gc.insets = new Insets(0, 5, 0, 0);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.anchor = 17;
        this.actionsOutDatedDaysPanel.add((Component)this.daysSpin, gc);
        return this.actionsOutDatedDaysPanel;
    }

    private void updatePanel() {
        Boolean displayOutdatedMessage = this.avVirusDefOptions.getOptDisplayOutdatedMessage() != null ? this.avVirusDefOptions.getOptDisplayOutdatedMessage() : this.avVirusDefOptions.getDefDisplayOutdatedMessage();
        Long warnAfterDays = this.avVirusDefOptions.getOptWarnAfterDays() != null ? this.avVirusDefOptions.getOptWarnAfterDays() : this.avVirusDefOptions.getDefWarnAfterDays();
        Boolean displayMissingDefMessage = this.avVirusDefOptions.getOptDisplayMissingDefMessage() != null ? this.avVirusDefOptions.getOptDisplayMissingDefMessage() : this.avVirusDefOptions.getDefDisplayMissingDefMessage();
        Long displayAttempts = this.avVirusDefOptions.getOptDisplayAttempts() != null ? this.avVirusDefOptions.getOptDisplayAttempts() : this.avVirusDefOptions.getDefDisplayAttempts();
        this.dispOutdatedMsgChk.setSelected(displayOutdatedMessage);
        this.daysSpin.setValue(warnAfterDays);
        this.dispMissingDefMsgChk.setSelected(displayMissingDefMessage);
        this.attemptsSpin.setValue(displayAttempts);
        this.popupChkBox.setSelected(this.generalInfoObj.getDisplayErrorPopup());
        if (this.generalInfoObj.getDisplayDefaultSupportSite()) {
            this.defaultRBtn.setSelected(true);
        } else {
            this.customRBtn.setSelected(true);
        }
        this.customURLTf.setText(this.generalInfoObj.getCustomizedSupportSite());
        this.popupBtnClicked();
    }

    private void saveData() {
        this.avVirusDefOptions.setOptDisplayOutdatedMessage(Boolean.valueOf(this.dispOutdatedMsgChk.isSelected()));
        this.avVirusDefOptions.setOptDisplayMissingDefMessage(Boolean.valueOf(this.dispMissingDefMsgChk.isSelected()));
        Object value = this.daysSpin.getValue();
        Long dayValue = null;
        if (value != null) {
            if (value instanceof Integer) {
                dayValue = ((Integer)value).longValue();
            } else if (value instanceof Long) {
                dayValue = (Long)value;
            }
        }
        this.avVirusDefOptions.setOptWarnAfterDays(dayValue);
        value = this.attemptsSpin.getValue();
        Long attemptsValue = null;
        if (value != null) {
            if (value instanceof Integer) {
                attemptsValue = ((Integer)value).longValue();
            } else if (value instanceof Long) {
                attemptsValue = (Long)value;
            }
        }
        this.avVirusDefOptions.setOptDisplayAttempts(attemptsValue);
        this.generalInfoObj.setDisplayErrorPopup(this.popupChkBox.isSelected());
        this.generalInfoObj.setDisplayDefaultSupportSite(this.defaultRBtn.isSelected());
        this.generalInfoObj.setCustomizedSupportSite(this.customURLTf.getText());
    }

    private void addWarningMessage(ActionEvent e) {
        String message = "";
        String title = "";
        String desc = "";
        String helpConstant = null;
        NotificationsMsgDlg dlg = null;
        if ((JButton)e.getSource() == this.outDatedMsgBtn) {
            if (this.avVirusDefOptions != null && this.avVirusDefOptions.getOptPatternWarningMessage() != null) {
                message = this.avVirusDefOptions.getOptPatternWarningMessage().getOptContent();
            }
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.title.OutdatedWarningMsg");
            desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.label.OutdatedWarningMsg");
            helpConstant = "sesm_policies_dialog_av_general_notifications_warning_outdated";
            dlg = new NotificationsMsgDlg(title, desc, message, 178, helpConstant, this.isPolicyNonShared);
        } else {
            if (this.avVirusDefOptions != null && this.avVirusDefOptions.getOptMissingDefMessageToDisplay() != null) {
                message = this.avVirusDefOptions.getOptMissingDefMessageToDisplay().getOptContent();
            }
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.title.avDefAbsentWarningMsg");
            desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.label.avDefAbsentWarningMsg");
            helpConstant = "sesm_policies_dialog_av_general_notifications_warning_missing";
            dlg = new NotificationsMsgDlg(title, desc, message, helpConstant, this.isPolicyNonShared);
        }
        if (dlg.isOk()) {
            message = dlg.getMessage();
        }
        if (this.avVirusDefOptions == null) {
            return;
        }
        if ((JButton)e.getSource() == this.outDatedMsgBtn) {
            PatternWarningMessage cntOutOfDateMsg = new PatternWarningMessage();
            cntOutOfDateMsg.setOptContent(message);
            this.avVirusDefOptions.setOptPatternWarningMessage(cntOutOfDateMsg);
        } else {
            MissingDefMessageToDisplay cntAbsentMsg = new MissingDefMessageToDisplay();
            cntAbsentMsg.setOptContent(message);
            this.avVirusDefOptions.setOptMissingDefMessageToDisplay(cntAbsentMsg);
        }
        dlg.dispose();
    }

    private JPanel getPopupSettingPanel() {
        if (this.popupSettingPanel == null) {
            this.popupSettingPanel = new JPanel();
            ButtonGroup subPopupGp = new ButtonGroup();
            subPopupGp.add(this.defaultRBtn);
            subPopupGp.add(this.customRBtn);
            this.popupChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.popupBtnClicked();
                }
            });
            this.customRBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.customBtnClicked();
                }
            });
            this.defaultRBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.customBtnClicked();
                }
            });
            this.customizeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.customMessageBtnClicked();
                }
            });
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 0;
            gc.gridheight = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 17;
            gc.insets = new Insets(5, 0, 0, 10);
            gc.ipadx = 0;
            gc.ipady = 0;
            this.popupSettingPanel.setLayout(new GridBagLayout());
            this.popupSettingPanel.add((Component)this.popupChkBox, gc);
            gc.gridy = 1;
            gc.insets = new Insets(5, 20, 0, 0);
            this.popupSettingPanel.add((Component)this.defaultRBtn, gc);
            gc.gridy = 2;
            gc.gridwidth = -1;
            this.popupSettingPanel.add((Component)this.customRBtn, gc);
            gc.gridx = 1;
            gc.insets = new Insets(4, 0, 0, 10);
            gc.anchor = 16;
            this.popupSettingPanel.add((Component)this.customURLTf, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.insets = new Insets(5, 25, 0, 0);
            gc.gridy = 3;
            this.popupSettingPanel.add((Component)this.customizeBtn, gc);
            gc.gridwidth = -1;
        }
        return this.popupSettingPanel;
    }

    private void popupBtnClicked() {
        this.defaultRBtn.setEnabled(this.popupChkBox.isSelected());
        this.customRBtn.setEnabled(this.popupChkBox.isSelected());
        this.customizeBtn.setEnabled(this.popupChkBox.isSelected());
        this.customBtnClicked();
    }

    private void customBtnClicked() {
        this.customURLTf.setEnabled(this.customRBtn.isEnabled() && this.customRBtn.isSelected());
    }

    private void customMessageBtnClicked() {
        String helpConstant;
        String message;
        String desc;
        String fileName;
        MessageResources Res = MessageResources.getInstance();
        String title = Res.getString(fileName = "com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.button.customize");
        NotificationsMsgDlg dlg = new NotificationsMsgDlg(title, desc = "", message = this.generalInfoObj.getErrorMessage() != null ? this.generalInfoObj.getErrorMessage() : "", helpConstant = "sesm_policies_dialog_av_general_notifications_error_message", this.isPolicyNonShared);
        if (dlg.isOk()) {
            message = dlg.getMessage();
        }
        dlg.dispose();
        this.generalInfoObj.setErrorMessage(message);
    }

    public void setPolicyIsNonShared(boolean isPolicyNonShared) {
        this.isPolicyNonShared = isPolicyNonShared;
    }

    public boolean isPolicyNonShared() {
        return this.isPolicyNonShared;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_general_notifications";
    }

    public void setObject(GeneralInfoObject generalInfoObj, AvVirusDefOptions avVirusDefOptions) {
        this.generalInfoObj = generalInfoObj;
        this.avVirusDefOptions = avVirusDefOptions;
        this.updatePanel();
    }

    public boolean valuesValid() {
        if (this.customRBtn.isSelected() && (this.customURLTf.getText() == null || this.customURLTf.getText().trim().length() == 0)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.custom.error.message"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.error.title"), 0);
            return false;
        }
        return true;
    }
}

