/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.configobject.schema.AvVirusDefOptions;
import com.sygate.scm.common.configobject.schema.MissingDefMessageToDisplay;
import com.sygate.scm.common.configobject.schema.PatternWarningMessage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.general.NotificationsMsgDlg;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class MacNotificationPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JPanel actionsPanel;
    private JCheckBox dispOutdatedMsgChk;
    private JSpinner daysSpin;
    private JButton outDatedMsgBtn;
    private JLabel warnAfterOutdatedLbl;
    private JLabel daysLbl;
    private JPanel displayPane;
    private AvVirusDefOptions avVirusDefOptions;

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_general_notifications";
    }

    public MacNotificationPane() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        BoxLayout pLayout = new BoxLayout(panel, 1);
        panel.setLayout(pLayout);
        this.setLayout(new BorderLayout());
        panel.add(this.getDisplayPane());
        this.add((Component)panel, "North");
    }

    private JPanel getDisplayPane() {
        if (this.displayPane != null) {
            return this.displayPane;
        }
        this.displayPane = this.getActionsPane();
        return this.displayPane;
    }

    private JPanel getActionsPane() {
        if (this.actionsPanel != null) {
            return this.actionsPanel;
        }
        this.actionsPanel = new JPanel();
        this.actionsPanel.setLayout(new BorderLayout());
        this.dispOutdatedMsgChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.checkbox.outdatedMessage"));
        this.daysSpin = new JSpinner(new SpinnerNumberModel(90, 0, 99, 1));
        UIUtilities.enableOnlyValidEdits(this.daysSpin);
        this.warnAfterOutdatedLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.warnAfter"));
        this.daysLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.label.days"));
        this.outDatedMsgBtn = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationTab.button.msgWarning"));
        this.outDatedMsgBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacNotificationPane.this.addWarningMessage(e);
            }
        });
        this.dispOutdatedMsgChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacNotificationPane.this.enableOutDatedComponets();
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 23;
        gc.insets = new Insets(0, 20, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 5;
        pane.add((Component)this.dispOutdatedMsgChk, gc);
        gc.insets = new Insets(7, 40, 0, 0);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.fill = 0;
        pane.add((Component)this.warnAfterOutdatedLbl, gc);
        gc.insets = new Insets(0, 40, 0, 0);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.anchor = 17;
        pane.add((Component)this.daysSpin, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.insets = new Insets(0, 5, 0, 10);
        pane.add((Component)this.daysLbl, gc);
        gc.gridx = 4;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 10, 5, 0);
        gc.anchor = 13;
        gc.fill = 0;
        pane.add((Component)this.outDatedMsgBtn, gc);
        this.outDatedMsgBtn.setVisible(false);
        gc.gridx = 4;
        gc.gridy = 3;
        this.actionsPanel.add((Component)pane, "Before");
        return this.actionsPanel;
    }

    public void setObject(AvVirusDefOptions avVirusDefOptions) {
        this.avVirusDefOptions = avVirusDefOptions;
        this.updatePanel();
    }

    private void updatePanel() {
        Boolean displayOutdatedMessage = this.avVirusDefOptions.getOptDisplayOutdatedMessage() != null ? this.avVirusDefOptions.getOptDisplayOutdatedMessage() : this.avVirusDefOptions.getDefDisplayOutdatedMessage();
        Long warnAfterDays = this.avVirusDefOptions.getOptWarnAfterDays() != null ? this.avVirusDefOptions.getOptWarnAfterDays() : this.avVirusDefOptions.getDefWarnAfterDays();
        this.dispOutdatedMsgChk.setSelected(displayOutdatedMessage);
        this.daysSpin.setValue(warnAfterDays);
        this.enableOutDatedComponets();
    }

    public void save() {
        this.saveData();
    }

    public boolean valuesValid() {
        return true;
    }

    private void saveData() {
        this.avVirusDefOptions.setOptDisplayOutdatedMessage(Boolean.valueOf(this.dispOutdatedMsgChk.isSelected()));
        Object value = this.daysSpin.getValue();
        Long dayValue = null;
        if (value != null) {
            if (value instanceof Integer) {
                dayValue = ((Integer)value).longValue();
            } else if (value instanceof Long) {
                dayValue = (Long)value;
            }
        }
        this.avVirusDefOptions.setOptWarnAfterDays(dayValue);
    }

    private void addWarningMessage(ActionEvent e) {
        String message = "";
        String title = "";
        String desc = "";
        String helpConstant = null;
        NotificationsMsgDlg dlg = null;
        if ((JButton)e.getSource() == this.outDatedMsgBtn) {
            if (this.avVirusDefOptions != null && this.avVirusDefOptions.getOptPatternWarningMessage() != null) {
                message = this.avVirusDefOptions.getOptPatternWarningMessage().getOptContent();
            }
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.title.OutdatedWarningMsg");
            desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.label.OutdatedWarningMsg");
            helpConstant = "sesm_policies_dialog_av_general_notifications_warning_outdated";
            dlg = new NotificationsMsgDlg(title, desc, message, 178, helpConstant, false);
        } else {
            if (this.avVirusDefOptions != null && this.avVirusDefOptions.getOptMissingDefMessageToDisplay() != null) {
                message = this.avVirusDefOptions.getOptMissingDefMessageToDisplay().getOptContent();
            }
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.title.avDefAbsentWarningMsg");
            desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "NotificationMsgDlg.label.avDefAbsentWarningMsg");
            helpConstant = "sesm_policies_dialog_av_general_notifications_warning_missing";
            dlg = new NotificationsMsgDlg(title, desc, message, helpConstant, false);
        }
        if (dlg.isOk()) {
            message = dlg.getMessage();
        }
        if (this.avVirusDefOptions == null) {
            return;
        }
        if ((JButton)e.getSource() == this.outDatedMsgBtn) {
            PatternWarningMessage cntOutOfDateMsg = new PatternWarningMessage();
            cntOutOfDateMsg.setOptContent(message);
            this.avVirusDefOptions.setOptPatternWarningMessage(cntOutOfDateMsg);
        } else {
            MissingDefMessageToDisplay cntAbsentMsg = new MissingDefMessageToDisplay();
            cntAbsentMsg.setOptContent(message);
            this.avVirusDefOptions.setOptMissingDefMessageToDisplay(cntAbsentMsg);
        }
        dlg.dispose();
    }

    private void enableOutDatedComponets() {
        this.daysLbl.setEnabled(this.dispOutdatedMsgChk.isSelected());
        this.warnAfterOutdatedLbl.setEnabled(this.dispOutdatedMsgChk.isSelected());
        this.daysSpin.setEnabled(this.dispOutdatedMsgChk.isSelected());
        this.outDatedMsgBtn.setEnabled(this.dispOutdatedMsgChk.isSelected());
    }
}

