/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.ForwardedEvent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.LogHandlingObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledJComboBox;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ChkListCellRenderer;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class LogHandlingPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -2109803496710308933L;
    private static final int ONE_MINUTE = 60;
    private static final int ONE_DAY = 1440;
    private static final int ALL_EVENT_TYPE = -1;
    private static final HashMap<Integer, Integer> orderByType = new HashMap();
    public static final int FILE_FORWARDED_TO_QUARANTINE_SERVER_SETTING = 18;
    private JList<EventObject> logList = new JList();
    private DefaultListModel<EventObject> listModel = new DefaultListModel();
    private AlwaysEnabledJComboBox eventComboBox;
    private JSpinner aggregateSpinner;
    private JSpinner deleteSpinner;
    private LogHandlingObject logHandlingObj;
    private HashMap<Long, EventObject> events = new HashMap();
    private TreeSet<EventObject> eventsSorted = new TreeSet();
    private static final HashSet<Long> eventsNonSupportedLinux = new HashSet();
    private long SCAN_STARTED_ID = 3L;
    private long SCAN_STOPPED_ID = 2L;
    private JCheckBox lockLogAgeChk;
    private int platformType = 1;

    public LogHandlingPane(int platformType) {
        this.platformType = platformType;
        this.initGUI();
    }

    public void save() {
        Vector<ForwardedEvent> forwardEvent = this.logHandlingObj.getForwardedEvent();
        for (int i = 0; i < forwardEvent.size(); ++i) {
            boolean isForward;
            ForwardedEvent event = forwardEvent.get(i);
            EventObject eo = this.events.get(event.getEventID());
            if (eo == null || (isForward = eo.isForward()) == event.getOptForward()) continue;
            event.setOptForward(Boolean.valueOf(isForward));
        }
        this.logHandlingObj.setTimeBaseAggregationInterval((Integer)this.aggregateSpinner.getValue() * 60);
        this.logHandlingObj.setDeleteAfterMinutes((Integer)this.deleteSpinner.getValue() * 1440);
        this.logHandlingObj.setLockDeleteAfterMinutes(this.lockLogAgeChk.isSelected());
    }

    private void checkBoxSelectionChanged(ItemEvent e) {
        EventObject eventObj = (EventObject)e.getSource();
        if (eventObj.getEventId() == this.SCAN_STOPPED_ID) {
            EventObject othereventObj = this.events.get(this.SCAN_STARTED_ID);
            othereventObj.setSelected(eventObj.isSelected());
        } else if (eventObj.getEventId() == this.SCAN_STARTED_ID) {
            EventObject othereventObj = this.events.get(this.SCAN_STOPPED_ID);
            othereventObj.setSelected(eventObj.isSelected());
        }
    }

    private JPanel getEventAggregationPane() {
        String title = this.getRes("label.eventAggragation");
        String desc = this.getRes("label.eventAggragationDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)new JLabel(this.getRes("checkbox.send")), c);
        SpinnerNumberModel model1 = new SpinnerNumberModel(1, 0, 1440, 1);
        this.aggregateSpinner = new JSpinner(model1);
        UIUtilities.enableOnlyValidEdits(this.aggregateSpinner);
        c.gridx = 1;
        c.gridy = 0;
        pane.add((Component)this.aggregateSpinner, c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)new JLabel(this.getRes("label.minutes")), c);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)pane, "Before");
        panel.add(p);
        return panel;
    }

    private JPanel getEventFilterPane() {
        String title = this.getRes("label.logFilter");
        String desc = this.getRes("label.logFilterDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        panel.add(this.getEventPane());
        return panel;
    }

    private JPanel getLogPane() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "LogHandlingTab.label.log");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "LogHandlingTab.label.logDesc");
        AvTemplatePane panel = new AvTemplatePane(title, desc);
        JPanel deletePane = new JPanel();
        deletePane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.insets = new Insets(5, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.lockLogAgeChk = new LockCheckBox(Boolean.FALSE);
        this.lockLogAgeChk.setSelectedIcon(AvConstants.lockIcon);
        deletePane.add((Component)this.lockLogAgeChk, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        deletePane.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "LogHandlingTab.label.delete")), c);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 9999, 1);
        this.deleteSpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.deleteSpinner);
        c.gridx = 2;
        c.gridy = 0;
        deletePane.add((Component)this.deleteSpinner, c);
        c.gridx = 3;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 0);
        deletePane.add((Component)new JLabel(this.getRes("label.days")), c);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)deletePane, "Before");
        panel.add(pane);
        return panel;
    }

    private JPanel getEventPane() {
        JPanel showPane = new JPanel();
        showPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        showPane.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "LogHandlingTab.label.show")), c);
        this.eventComboBox = new AlwaysEnabledJComboBox((ComboBoxModel<Object>)this.getEventTypeModel());
        this.eventComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogHandlingPane.this.updateListModel();
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        showPane.add((Component)this.eventComboBox, c);
        this.logList.setModel(this.listModel);
        this.logList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = LogHandlingPane.this.logList.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox cBox = LogHandlingPane.this.logList.getModel().getElementAt(index);
                    cBox.doClick();
                    LogHandlingPane.this.logList.updateUI();
                }
            }
        });
        this.logList.setCellRenderer(new ChkListCellRenderer());
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.logList);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        showPane.add((Component)scrollPane, c);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)showPane, "North");
        return panel;
    }

    private void updateListModel() {
        this.listModel.clear();
        int eventType = ((EventTypeObject)this.eventComboBox.getSelectedItem()).getType();
        for (EventObject obj : this.eventsSorted) {
            if (Long.valueOf(obj.getEventId()) == 18L || 3 == this.platformType && eventsNonSupportedLinux.contains(obj.getEventId()) || eventType != -1 && eventType != obj.getEventType()) continue;
            this.listModel.addElement(obj);
        }
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            int size = this.logList.getModel() != null ? this.logList.getModel().getSize() : 0;
            for (int i = 0; i < size; ++i) {
                this.logList.getModel().getElementAt(i).setEnabled(false);
            }
        }
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getEventFilterPane());
        this.add(this.getLogPane());
        this.add(this.getEventAggregationPane());
    }

    private DefaultComboBoxModel<Object> getEventTypeModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(new EventTypeObject(-1, this.getRes("combobox.allEvents")));
        model.addElement(new EventTypeObject(ForwardedEvent.SCAN_INFECTION, this.getRes("combobox.scanInfectEvents")));
        model.addElement(new EventTypeObject(ForwardedEvent.VIRUS_DEF, this.getRes("combobox.virusDefEvents")));
        if (3 != this.platformType) {
            model.addElement(new EventTypeObject(ForwardedEvent.CONFIG, this.getRes("combobox.configEvents")));
        }
        model.addElement(new EventTypeObject(ForwardedEvent.STARTUP, this.getRes("combobox.startupEvents")));
        return model;
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "LogHandlingTab." + key);
    }

    public void setObject(LogHandlingObject logHandlingObj) {
        this.logHandlingObj = logHandlingObj;
        Vector<ForwardedEvent> processedEvents = logHandlingObj.getForwardedEvent();
        for (int i = 0; i < processedEvents.size(); ++i) {
            ForwardedEvent event = processedEvents.get(i);
            Integer eventType = event.getOptEventType();
            if (eventType == null) {
                eventType = event.getDefEventType();
            }
            boolean isForward = Utility.getBooleanValue((Boolean)event.getOptForward(), (Boolean)event.getDefForward());
            if (event.getEventID() == 71L) continue;
            EventObject eventObj = new EventObject(event.getEventID(), eventType, isForward);
            if (event.getEventID() == this.SCAN_STOPPED_ID || event.getEventID() == this.SCAN_STARTED_ID) {
                eventObj.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        LogHandlingPane.this.checkBoxSelectionChanged(e);
                    }
                });
            }
            this.events.put(event.getEventID(), eventObj);
            this.eventsSorted.add(eventObj);
        }
        this.updateListModel();
        this.aggregateSpinner.setValue(logHandlingObj.getTimeBaseAggregationInterval() / 60);
        this.deleteSpinner.setValue(logHandlingObj.getDeleteAfterMinutes() / 1440);
        this.lockLogAgeChk.setSelected(logHandlingObj.getLockDeleteAfterMinutes());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "sesm_policies_dialog_av_general_log_handling";
        }
        return "sesm_policies_dialog_av_general_log_handling";
    }

    public void setReadOnly() {
        Iterator<EventObject> values = this.eventsSorted.iterator();
        while (values.hasNext()) {
            values.next().setEnabled(false);
        }
    }

    static {
        orderByType.put(ForwardedEvent.SCAN_INFECTION, 1);
        orderByType.put(ForwardedEvent.VIRUS_DEF, 2);
        orderByType.put(ForwardedEvent.CONFIG, 3);
        orderByType.put(ForwardedEvent.STARTUP, 4);
        eventsNonSupportedLinux.add(4L);
        eventsNonSupportedLinux.add(22L);
        eventsNonSupportedLinux.add(23L);
        eventsNonSupportedLinux.add(24L);
        eventsNonSupportedLinux.add(71L);
        eventsNonSupportedLinux.add(76L);
        eventsNonSupportedLinux.add(77L);
        eventsNonSupportedLinux.add(55L);
        eventsNonSupportedLinux.add(12L);
        eventsNonSupportedLinux.add(57L);
        eventsNonSupportedLinux.add(58L);
        eventsNonSupportedLinux.add(18L);
        eventsNonSupportedLinux.add(20L);
        eventsNonSupportedLinux.add(19L);
        eventsNonSupportedLinux.add(47L);
        eventsNonSupportedLinux.add(48L);
        eventsNonSupportedLinux.add(49L);
        eventsNonSupportedLinux.add(50L);
        eventsNonSupportedLinux.add(40L);
    }

    private static class EventTypeObject {
        private int type;
        private String name;

        public EventTypeObject(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }

    private class EventObject
    extends JCheckBox
    implements Comparable<Object> {
        private static final long serialVersionUID = 3660990452714213179L;
        private long eventId;
        private int eventType;

        public EventObject(long eventId, int eventType, boolean isForward) {
            this.eventId = eventId;
            this.eventType = eventType;
            this.setText(LogHandlingPane.this.getRes("checkbox." + eventId));
            this.setSelected(isForward);
            this.setOpaque(false);
        }

        @Override
        public int compareTo(Object o) {
            EventObject eventObj = (EventObject)o;
            Integer order = orderByType.get(this.eventType);
            Integer orderObj = orderByType.get(eventObj.getEventType());
            if (order > orderObj) {
                return 1;
            }
            if (order < orderObj) {
                return -1;
            }
            return this.getText().compareTo(eventObj.getText());
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean isForward() {
            return this.isSelected();
        }

        public long getEventId() {
            return this.eventId;
        }

        public int getEventType() {
            return this.eventType;
        }
    }
}

