/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.configobject.schema.HeuristicsOptions;
import com.sygate.scm.common.configobject.schema.LinuxAvScanPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.BloodhoundScanSettingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LinuxGlobalPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private LinuxAvScanPolicy scanPolicy;
    private JCheckBox tcpModeChk;
    private JCheckBox monitorModeChk;
    protected AvTemplatePane tcpModePanel;
    protected AvTemplatePane monitorModePanel;
    private BloodhoundScanSettingPanel bloodhoundPane;

    public LinuxGlobalPanel() {
        this.initGUI();
    }

    public void setObject(LinuxAvScanPolicy incomingScanPolicy) {
        if (incomingScanPolicy == null) {
            return;
        }
        this.scanPolicy = incomingScanPolicy;
        this.tcpModeChk.setSelected(Optional.ofNullable(this.scanPolicy.getOptTcpMode()).orElseGet(() -> this.scanPolicy.getDefTcpMode()));
        this.monitorModeChk.setSelected(Optional.ofNullable(this.scanPolicy.getOptMonitorMode()).orElseGet(() -> this.scanPolicy.getDefMonitorMode()));
        if (this.scanPolicy.getOptHeuristicsOptions() == null) {
            HeuristicsOptions options = new HeuristicsOptions();
            this.scanPolicy.setOptHeuristicsOptions(options);
        }
        this.bloodhoundPane.setObject(this.scanPolicy.getOptHeuristicsOptions());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "linux_sesm_policies_dialog_av_global_scan_options";
    }

    public void save() {
        this.saveData();
    }

    private void initGUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.setLayout(new BorderLayout());
        panel.add(this.getTcpModePanel());
        panel.add(this.getMonitorModePanel());
        panel.add(this.getBloodHoundScanSettingPane());
        this.add((Component)panel, "North");
    }

    protected Component getTcpModePanel() {
        if (this.tcpModePanel == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.tcpMode.title");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.tcpMode.desc");
            JPanel techPanel = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            techPanel.setLayout(gridBag);
            this.tcpModeChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.checkbox.tcpMode"));
            techPanel.add((Component)this.tcpModeChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.tcpModePanel = new AvTemplatePane(title, desc);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)techPanel, "Before");
            this.tcpModePanel.add(panel);
        }
        return this.tcpModePanel;
    }

    protected Component getMonitorModePanel() {
        if (this.monitorModePanel == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.monitorMode.title");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.monitorMode.desc");
            JPanel techPanel = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            techPanel.setLayout(gridBag);
            this.monitorModeChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LinuxGlobalScanOptions.checkbox.monitorMode"));
            techPanel.add((Component)this.monitorModeChk, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.monitorModePanel = new AvTemplatePane(title, desc);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)techPanel, "Before");
            this.monitorModePanel.add(panel);
        }
        return this.monitorModePanel;
    }

    private JPanel getBloodHoundScanSettingPane() {
        if (this.bloodhoundPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.HeuristicScanSetting");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.HeuristicScanSettingDesc");
            this.bloodhoundPane = new BloodhoundScanSettingPanel(title, desc, false);
        }
        return this.bloodhoundPane;
    }

    private void saveData() {
        this.scanPolicy.setOptTcpMode(Boolean.valueOf(this.tcpModeChk.isSelected()));
        this.scanPolicy.setOptMonitorMode(Boolean.valueOf(this.monitorModeChk.isSelected()));
        this.scanPolicy.getOptHeuristicsOptions().setOptEnableBloodhound(Boolean.valueOf(this.bloodhoundPane.isBloodhoundEnabled()));
        this.scanPolicy.getOptHeuristicsOptions().setOptBloodhoundLevel(Integer.valueOf(this.bloodhoundPane.getProtectionLevel()));
    }
}

