/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.configobject.schema.AvGeneral;
import com.sygate.scm.common.configobject.schema.AvVirusDefOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.general.CommonImagePane;
import com.sygate.scm.console.ui.policy.av.general.GeneralInfoPane;
import com.sygate.scm.console.ui.policy.av.general.LogHandlingPane;
import com.sygate.scm.console.ui.policy.av.general.NotificationPane;
import com.sygate.scm.console.ui.policy.av.general.SharedInsightCachePane;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LogHandlingObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import javax.swing.JTabbedPane;

public class GeneralTabPane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private GeneralInfoPane generalInfoPane;
    private LogHandlingPane logHandlingPane;
    private AvGeneral avGeneral;
    private GeneralInfoObject generalInfoObj;
    private LogHandlingObject logHandlingObj;
    private NotificationPane notificationPane;
    private CommonImagePane commonImagePane;
    private SharedInsightCachePane sharedInsightCachePane;
    AvVirusDefOptions avVirusDefOptions;
    private boolean isPolicyNonShared;
    private int platformType = 1;

    public GeneralTabPane(int platformType) {
        this.platformType = platformType;
    }

    public void setPolicyIsNonShared(boolean isPolicyNonShared) {
        this.isPolicyNonShared = isPolicyNonShared;
    }

    public void setReadOnly() {
        this.logHandlingPane.setReadOnly();
    }

    public void setGeneralObject(AvGeneral avGeneral) {
        if (avGeneral == null) {
            avGeneral = new AvGeneral();
        }
        this.avGeneral = avGeneral;
        this.updateValues();
    }

    public void save() {
        this.generalInfoPane.save();
        this.logHandlingPane.save();
        this.notificationPane.save();
        this.commonImagePane.save();
        this.sharedInsightCachePane.save();
        this.avGeneral.setGeneralInfo(this.generalInfoObj.getSchemaObject());
        this.avGeneral.setLogHandling(this.logHandlingObj.getSchemaObject());
        this.avGeneral.setAvVirusDefOptions(this.avVirusDefOptions);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    private void updateValues() {
        this.generalInfoPane = new GeneralInfoPane();
        this.logHandlingPane = new LogHandlingPane(this.platformType);
        this.notificationPane = new NotificationPane();
        this.commonImagePane = new CommonImagePane();
        this.sharedInsightCachePane = new SharedInsightCachePane();
        this.generalInfoObj = new GeneralInfoObject(this.avGeneral.getGeneralInfo());
        this.generalInfoPane.setObject(this.generalInfoObj);
        this.logHandlingObj = new LogHandlingObject(this.avGeneral.getLogHandling());
        this.logHandlingPane.setObject(this.logHandlingObj);
        this.avVirusDefOptions = this.avGeneral.getAvVirusDefOptions();
        if (this.avVirusDefOptions == null) {
            this.avVirusDefOptions = new AvVirusDefOptions();
        }
        this.notificationPane.setPolicyIsNonShared(this.isPolicyNonShared);
        this.notificationPane.setObject(this.generalInfoObj, this.avVirusDefOptions);
        this.commonImagePane.setObject(this.generalInfoObj);
        this.sharedInsightCachePane.setObject(this.generalInfoObj);
        if (1 == this.platformType) {
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.general"), UIUtilities.createScrollPaneWithoutBoard(this.generalInfoPane));
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.logHandling"), UIUtilities.createScrollPaneWithoutBoard(this.logHandlingPane));
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.notification"), UIUtilities.createScrollPaneWithoutBoard(this.notificationPane));
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.commonImage"), UIUtilities.createScrollPaneWithoutBoard(this.commonImagePane));
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.sharedInsightCache"), UIUtilities.createScrollPaneWithoutBoard(this.sharedInsightCachePane));
            this.commonImagePane.addHierarchyListener(new HierarchyListenerImpl());
            this.sharedInsightCachePane.addHierarchyListener(new HierarchyListenerImpl());
        } else if (3 == this.platformType) {
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralTab.title.logHandling"), UIUtilities.createScrollPaneWithoutBoard(this.logHandlingPane));
        }
    }

    public boolean valuesValid() {
        if (!this.notificationPane.valuesValid()) {
            return false;
        }
        return this.sharedInsightCachePane.valuesValid();
    }
}

