/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class GeneralInfoPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String[] ALERT_OPTIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.alertList.enable"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.alertList.disable"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.alertList.noAction")};
    private GeneralInfoObject generalInfoObj;
    private JLabel wscAlertLabel;
    private JLabel wscMsgLabel;
    private JLabel wscWarnLabel;
    private JLabel wscDayLabel;
    private final JCheckBox showIconCheckBox = new JCheckBox();
    private JComboBox<String> alertCmBox;
    private SpinnerNumberModel spinModel;
    private JCheckBox wscCoexistCheckBox;
    private JPanel wscPane;
    private JPanel listPane;
    private JPanel homepagePane;
    private JPanel homepageAddressPane;
    private JTextField homepageAddress;
    private LockCheckBox homepageLock;
    private final JButton changePasswdBtn = new JButton();

    public GeneralInfoPane() {
        this.initGUI();
    }

    public void save() {
        this.saveData();
    }

    private JPanel getHomepagePane() {
        if (this.homepagePane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.homepage");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.homepageDesc");
            this.homepagePane = new AvTemplatePane(title, desc);
            this.homepagePane.add(this.getHomepageAddressPane());
        }
        return this.homepagePane;
    }

    private JPanel getHomepageAddressPane() {
        if (this.homepageAddressPane == null) {
            this.homepageAddressPane = new JPanel(new GridBagLayout());
            if (this.homepageAddress == null) {
                this.homepageAddress = new JTextField(50);
                this.homepageAddress.setDocument(new RestrictedPlainDocument(234));
            }
            if (this.homepageLock == null) {
                this.homepageLock = new LockCheckBox(Boolean.FALSE);
                this.homepageLock.setSelectedIcon(AvConstants.lockIcon);
            }
            GridBagConstraints c1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.homepageAddressPane.add((Component)this.homepageLock, c1);
            GridBagConstraints c2 = new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.homepageAddressPane.add((Component)this.homepageAddress, c2);
        }
        return this.homepageAddressPane;
    }

    private JPanel getWscPane() {
        if (this.wscPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wsc");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscHow");
            this.wscPane = new AvTemplatePane(title, desc);
            this.wscPane.add(this.getListPane());
        }
        return this.wscPane;
    }

    private JPanel getListPane() {
        if (this.listPane != null) {
            return this.listPane;
        }
        this.listPane = new JPanel();
        this.listPane.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        pane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(13, 20, 0, 0);
        pane.add((Component)this.wscAlertLabel, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(3, 20, 0, 0);
        DefaultComboBoxModel<String> alertModel = new DefaultComboBoxModel<String>(ALERT_OPTIONS);
        this.alertCmBox = new JComboBox<String>(alertModel);
        pane.add(this.alertCmBox, c);
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(13, 20, 0, 0);
        pane.add((Component)this.wscMsgLabel, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(5, 20, 0, 0);
        pane.add((Component)this.wscWarnLabel, c);
        c.gridx = 1;
        c.gridy = 5;
        c.insets = new Insets(3, 5, 0, 0);
        this.spinModel = new SpinnerNumberModel(1, 1, 30, 1);
        JSpinner spinner = new JSpinner(this.spinModel);
        UIUtilities.enableOnlyValidEdits(spinner);
        pane.add((Component)spinner, c);
        c.gridx = 2;
        c.gridy = 5;
        c.insets = new Insets(5, 7, 0, 0);
        pane.add((Component)this.wscDayLabel, c);
        c.gridx = 0;
        c.gridy = 6;
        c.insets = new Insets(13, 20, 0, 0);
        pane.add((Component)this.wscCoexistCheckBox, c);
        this.listPane.add((Component)pane, "Before");
        return this.listPane;
    }

    private void initGUI() {
        this.showIconCheckBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.checkbox.showIcon"));
        this.wscAlertLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscAlert"));
        this.wscMsgLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscMsg"));
        this.wscWarnLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscWarn"));
        this.wscDayLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscDay"));
        this.wscCoexistCheckBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "GeneralInfoTab.label.wscCoexist"));
        this.changePasswdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "ClientPermissionTab.button.changePswd"));
        JPanel panel = new JPanel();
        BoxLayout pLayout = new BoxLayout(panel, 1);
        panel.setLayout(pLayout);
        this.setLayout(new BorderLayout());
        panel.add(this.getWscPane());
        panel.add(this.getHomepagePane());
        this.add((Component)panel, "North");
    }

    private void updatePanel() {
        this.spinModel.setValue(this.generalInfoObj.getOptWSCDefsUpToDate());
        this.homepageLock.setSelected(this.generalInfoObj.getOptLockHomepageAddress());
        this.homepageAddress.setText(this.generalInfoObj.getOptHomepageAddress());
        this.alertCmBox.setSelectedIndex(this.generalInfoObj.getOptWSCAVAlert());
        this.wscCoexistCheckBox.setSelected(this.generalInfoObj.getCoexistance());
    }

    private void saveData() {
        this.generalInfoObj.setOptWSCAVAlert(this.alertCmBox.getSelectedIndex());
        this.generalInfoObj.setDefWSCDefsUpToDate(this.spinModel.getNumber().intValue());
        this.generalInfoObj.setOptHomepageAddress(this.homepageAddress.getText().trim());
        this.generalInfoObj.setOptLockHomepageAddress(this.homepageLock.isSelected());
        this.generalInfoObj.setCoexistance(this.wscCoexistCheckBox.isSelected());
    }

    public void setObject(GeneralInfoObject obj) {
        this.generalInfoObj = obj;
        this.updatePanel();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_general_general_info";
    }
}

