/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.general;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CommonImagePane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane CIESettingsPane;
    private JCheckBox enableCIEForAPScan;
    private JCheckBox enableCIEForOtherScan;
    private GeneralInfoObject generalInfoObj;

    public CommonImagePane() {
        this.initGUI();
    }

    public void save() {
        this.saveData();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getCIESettingsPane());
    }

    private JPanel getCIESettingsPane() {
        if (this.CIESettingsPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "CommonImageAttributesTab.label.title");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "CommonImageAttributesTab.label.desc");
            this.CIESettingsPane = new AvTemplatePane(title, desc);
            this.enableCIEForAPScan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "CommonImageAttributesTab.checkbox.enableCIEForAPScan"));
            this.enableCIEForAPScan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CommonImagePane.this.enableCIEForAPScan.setFocusPainted(true);
                }
            });
            this.enableCIEForOtherScan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "CommonImageAttributesTab.checkbox.enableCIEForOtherScan"));
            JPanel subPane = new JPanel();
            subPane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            subPane.add((Component)this.enableCIEForAPScan, c);
            ++c.gridy;
            subPane.add((Component)this.enableCIEForOtherScan, c);
            ++c.gridy;
            subPane.add((Component)this.getCIEHelpLinkLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.general.avgeneral", "CommonImageAttributesTab.help.commonImagesHelpText")), c);
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.add((Component)subPane, "Before");
            this.CIESettingsPane.add(pane);
        }
        return this.CIESettingsPane;
    }

    private JLabel getCIEHelpLinkLabel(String securityText) {
        HtmlEnabledJLabel securityHelpLinkLabel = new HtmlEnabledJLabel(securityText, true);
        securityHelpLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
        securityHelpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_general_whatis_virtual_image_exception");
            }
        });
        securityHelpLinkLabel.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return securityHelpLinkLabel;
    }

    private void updatePanel() {
        this.enableCIEForAPScan.setSelected(this.generalInfoObj.getEnabledCIEForAPScan());
        this.enableCIEForOtherScan.setSelected(this.generalInfoObj.getEnabledCIEForOtherScan());
    }

    private void saveData() {
        this.generalInfoObj.setEnabledCIEForAPScan(this.enableCIEForAPScan.isSelected());
        this.generalInfoObj.setEnabledCIEForOtherScan(this.enableCIEForOtherScan.isSelected());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_general_virtual_image_exception";
    }

    public void setObject(GeneralInfoObject obj) {
        this.generalInfoObj = obj;
        this.updatePanel();
    }
}

