/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.util.LockCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleRiskActionsPanel
extends JPanel {
    private static final long serialVersionUID = -7775846986345951824L;
    private LockCheckBox lockFirstActionChk;
    private LockCheckBox lockIfFirstFailChk;
    private JComboBox<ActionType> firstActionCombo;
    private JComboBox<ActionType> ifFirstFailCombo;
    private DefaultComboBoxModel<ActionType> firstActionModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel<ActionType> ifFirstFailModel = new DefaultComboBoxModel();
    private ApAction action;
    private boolean hideLocks;

    public SimpleRiskActionsPanel(boolean hideLocks) {
        this.setupPanel();
        this.hideLocks = hideLocks;
        this.setLocksVisibility();
    }

    public void setObject(ApAction action) {
        if (action == null) {
            action = new ApAction();
        }
        this.action = action;
        this.updatePanel();
    }

    public ApAction save() {
        ActionType firstActionType = (ActionType)((Object)this.firstActionCombo.getSelectedItem());
        this.action.setFirstAction(firstActionType.action);
        ActionType secondActionType = (ActionType)((Object)this.ifFirstFailCombo.getSelectedItem());
        this.action.setSecondAction(secondActionType.action);
        this.action.setOptLockFirstAction(Boolean.valueOf(this.lockFirstActionChk.isSelected()));
        this.action.setOptLockSecondAction(Boolean.valueOf(this.lockIfFirstFailChk.isSelected()));
        return this.action;
    }

    public void enableAppropriate(boolean enable) {
        this.firstActionCombo.setEnabled(enable);
        this.ifFirstFailCombo.setEnabled(enable);
        this.lockFirstActionChk.setEnabled(enable);
        this.lockIfFirstFailChk.setEnabled(enable);
    }

    private void setLocksVisibility() {
        this.lockFirstActionChk.setVisible(!this.hideLocks);
        this.lockIfFirstFailChk.setVisible(!this.hideLocks);
    }

    protected void updatePanel() {
        Boolean lockAction = this.action.getOptLockFirstAction();
        if (lockAction == null) {
            lockAction = this.action.getDefLockFirstAction();
        }
        this.lockFirstActionChk.setSelected(lockAction);
        lockAction = this.action.getOptLockSecondAction();
        if (lockAction == null) {
            lockAction = this.action.getDefLockSecondAction();
        }
        this.lockIfFirstFailChk.setSelected(lockAction);
        Integer numericActionValue = this.action.getFirstAction();
        if (numericActionValue != null) {
            this.firstActionModel.setSelectedItem((Object)ActionType.getActionType(numericActionValue));
        }
        if ((numericActionValue = this.action.getSecondAction()) != null) {
            this.ifFirstFailModel.setSelectedItem((Object)ActionType.getActionType(numericActionValue));
        }
    }

    private void setupComponents() {
        int i;
        this.lockFirstActionChk = new LockCheckBox(Boolean.FALSE);
        this.lockFirstActionChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockIfFirstFailChk = new LockCheckBox(Boolean.FALSE);
        this.lockIfFirstFailChk.setSelectedIcon(AvConstants.lockIcon);
        ActionType[] values = this.getPossbileFirstActionTypes();
        for (i = 0; i < values.length; ++i) {
            this.firstActionModel.addElement(values[i]);
        }
        values = this.getPossibleSecondActionTypes(ActionType.CLEAN);
        for (i = 0; i < values.length; ++i) {
            this.ifFirstFailModel.addElement(values[i]);
        }
        this.ifFirstFailCombo = new JComboBox<ActionType>(this.ifFirstFailModel);
        this.firstActionCombo = new JComboBox<ActionType>(this.firstActionModel);
        this.firstActionCombo.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                ActionType selectedType = (ActionType)((Object)((Object)this.firstActionCombo.getSelectedItem()));
                ActionType[] types = this.getPossibleSecondActionTypes(selectedType);
                if (types == null || ActionType.LOG_ONLY.equals((Object)selectedType)) {
                    this.ifFirstFailCombo.setEnabled(false);
                } else {
                    this.ifFirstFailCombo.setEnabled(true);
                }
                if (types != null && types.length > 0) {
                    this.ifFirstFailModel.removeAllElements();
                    for (ActionType type : types) {
                        this.ifFirstFailModel.addElement(type);
                    }
                }
            }
        });
    }

    protected ActionType[] getPossbileFirstActionTypes() {
        ActionType[] values = new ActionType[]{ActionType.CLEAN, ActionType.DELETE, ActionType.LOG_ONLY};
        return values;
    }

    protected ActionType[] getPossibleSecondActionTypes(ActionType actionType) {
        ActionType[] types = null;
        switch (actionType) {
            case CLEAN: {
                types = new ActionType[]{ActionType.QUARANTINE, ActionType.DELETE, ActionType.LOG_ONLY};
                break;
            }
            case QUARANTINE: {
                break;
            }
            case DELETE: 
            case LOG_ONLY: {
                types = new ActionType[]{ActionType.LOG_ONLY};
                break;
            }
            default: {
                types = ActionType.values();
            }
        }
        return types;
    }

    private void setupPanel() {
        this.setupComponents();
        JPanel actionPane = new JPanel();
        actionPane.setLayout(new GridBagLayout());
        JLabel firstLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstAction"));
        JLabel ifFirstFailLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstActionFail"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 1;
        actionPane.add((Component)firstLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        actionPane.add((Component)this.lockFirstActionChk, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 2;
        c.gridy = 1;
        actionPane.add(this.firstActionCombo, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 2;
        actionPane.add((Component)ifFirstFailLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        actionPane.add((Component)this.lockIfFirstFailChk, c);
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        actionPane.add(this.ifFirstFailCombo, c);
        this.setLayout(new BorderLayout());
        this.add((Component)actionPane, "Before");
    }

    private static enum ActionType {
        CLEAN(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.clean"), ApAction.CLEAN),
        QUARANTINE(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.quarantine"), ApAction.QUARANTINE),
        DELETE(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.delete"), ApAction.DELETE),
        LOG_ONLY(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.logOnly"), ApAction.LOG_ONLY);

        private String actionText;
        private Integer action;

        private ActionType(String actionText, Integer action) {
            this.actionText = actionText;
            this.action = action;
        }

        private static ActionType getActionType(Integer action) {
            for (ActionType type : ActionType.values()) {
                if (!type.action.equals(action)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.actionText;
        }
    }
}

