/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.configobject.schema.Extension;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.ExtSelectDialog;
import com.sygate.scm.console.ui.policy.av.logicobject.FileTypesObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FileTypesPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean includeSmartScan;
    private boolean showLock;
    private boolean deprecateLinux;
    private JCheckBox includeChk;
    private LockCheckBox lockFileTypesChk;
    private JRadioButton scanAllRadio;
    private JRadioButton scanSelectedRadio;
    private AlwaysEnabledButton selectExtBtn;
    private JLabel iconLabel;
    private FileTypesObject fileTypesObj;
    private Vector<Extension> customExts;
    private int platFormType;

    public FileTypesPane(boolean includeSmartScan, boolean showLock, int platFormType, boolean deprecateLinux) {
        this.includeSmartScan = includeSmartScan;
        this.showLock = showLock;
        this.platFormType = platFormType;
        this.deprecateLinux = deprecateLinux;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "Before");
    }

    public FileTypesPane(boolean includeSmartScan, boolean showLock, int platFormType) {
        this(includeSmartScan, showLock, platFormType, false);
    }

    public FileTypesPane(boolean includeSmartScan, boolean showLock) {
        this(includeSmartScan, showLock, 1, false);
    }

    public void setObject(FileTypesObject fileTypesObj) {
        this.fileTypesObj = fileTypesObj;
        this.customExts = fileTypesObj.getExtension();
        this.updatePanel();
        this.enableAppropriate();
    }

    public void save() {
        this.saveData();
    }

    private JPanel getPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        JLabel fileTypeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.label.fileTypes"));
        this.scanAllRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.radio.scanAll"));
        this.scanAllRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FileTypesPane.this.enableAppropriate();
            }
        });
        this.scanSelectedRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.radio.scanSelected"));
        this.scanSelectedRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FileTypesPane.this.enableAppropriate();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.scanAllRadio);
        group.add(this.scanSelectedRadio);
        this.selectExtBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.button.selectExt"));
        this.selectExtBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtSelectDialog esd = new ExtSelectDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.title.fileExtensions"));
                esd.setPlatFormType(FileTypesPane.this.platFormType);
                esd.setObject(FileTypesPane.this.customExts);
                esd.setVisible(true);
                if (esd.isOk()) {
                    FileTypesPane.this.customExts = new Vector<Extension>(esd.getObject());
                }
            }
        });
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        pane.add((Component)fileTypeLabel, c);
        if (this.showLock) {
            c.gridx = 0;
            c.gridy = 1;
            c.insets = new Insets(5, 0, 0, 0);
            this.lockFileTypesChk = new LockCheckBox(Boolean.FALSE);
            this.lockFileTypesChk.setSelectedIcon(AvConstants.lockIcon);
            pane.add((Component)this.lockFileTypesChk, c);
        }
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)this.scanAllRadio, c);
        c.gridx = 1;
        c.gridy = 2;
        pane.add((Component)this.scanSelectedRadio, c);
        if (this.deprecateLinux && this.platFormType == 3) {
            this.iconLabel = this.createLinuxBadge();
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(5, 5, 0, 0);
            pane.add((Component)this.iconLabel, c);
        }
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(5, 25, 0, 0);
        pane.add((Component)this.selectExtBtn, c);
        this.includeChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.checkbox.includeSmartScan"));
        if (this.includeSmartScan) {
            c.gridx = 1;
            c.gridy = 3;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.includeChk, c);
        }
        return pane;
    }

    private JLabel createLinuxBadge() {
        this.iconLabel = new JLabel();
        this.iconLabel.setIcon(UIUtilities.DEPRECATED_LINUX_ICON);
        this.iconLabel.setHorizontalTextPosition(2);
        this.iconLabel.setToolTipText(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP);
        return this.iconLabel;
    }

    private void enableAllComponents(boolean enable) {
        this.includeChk.setEnabled(enable);
        this.scanAllRadio.setEnabled(enable);
        this.scanSelectedRadio.setEnabled(enable);
        this.selectExtBtn.setEnabled(enable);
    }

    private void enableAppropriate() {
        this.enableAppropriate(true);
    }

    public void enableAppropriate(boolean allEnabled) {
        this.enableAllComponents(allEnabled);
        this.selectExtBtn.setEnabled(allEnabled && this.scanSelectedRadio.isSelected());
        this.includeChk.setEnabled(allEnabled && this.scanSelectedRadio.isSelected());
    }

    private void updatePanel() {
        if (this.showLock) {
            this.lockFileTypesChk.setSelected(this.fileTypesObj.getLockFileTypes());
        }
        this.scanAllRadio.setSelected(this.fileTypesObj.getScanAllTypes());
        this.scanSelectedRadio.setSelected(!this.fileTypesObj.getScanAllTypes());
        if (this.includeSmartScan) {
            this.includeChk.setSelected(this.fileTypesObj.getSmartScan());
        }
    }

    private void saveData() {
        if (this.showLock) {
            this.fileTypesObj.setLockFileTypes(this.lockFileTypesChk.isSelected());
        }
        this.fileTypesObj.setScanAllTypes(this.scanAllRadio.isSelected());
        if (this.includeSmartScan) {
            this.fileTypesObj.setSmartScan(this.includeChk.isSelected());
        }
        if (!this.scanAllRadio.isSelected()) {
            LinkedHashMap<String, Extension> extensionsMap = new LinkedHashMap<String, Extension>(this.customExts.size());
            for (Extension extension : this.customExts) {
                extensionsMap.put(extension.getContent(), extension);
            }
            for (Extension extension : this.fileTypesObj.getExtension()) {
                if (extensionsMap.containsKey(extension.getContent())) {
                    extensionsMap.remove(extension.getContent());
                    continue;
                }
                this.fileTypesObj.getSchemaObject().removeExtension(extension);
            }
            for (Map.Entry entry : extensionsMap.entrySet()) {
                this.fileTypesObj.getSchemaObject().addExtension((Extension)entry.getValue());
            }
        }
    }
}

