/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.Extension;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class ExtSelectDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] DEFAULT_EXTS = new String[]{"386", "ACCD?", "ACM", "ACV", "ADT", "AX", "BAT", "BIN", "BTM", "CLA", "CMD", "COM", "CPL", "CSC", "CSH", "DLL", "DOC", "DOC?", "DOT", "DOT?", "DRV", "EXE", "HLP", "HTA", "HTM", "HTML", "HTT", "INF", "INI", "JPEG", "JPG", "JS", "JSE", "JTD", "MDB", "MP?", "MSO", "OBD", "OBT", "OCX", "OV?", "PART", "PDF", "PIF", "PL", "PM", "POT", "POT?", "PP?", "PP??", "RTF", "SCR", "SH", "SHB", "SHS", "SMM", "SYS", "TMP", "VBE", "VBS", "VSD", "VSS", "VST", "VXD", "WSF", "WSH", "XL?", "XL??", "XPS"};
    private static final String[] PROGRAM_EXTS = new String[]{"386", "BAT", "BIN", "BTM", "CLA", "CMD", "COM", "CSC", "DLL", "DRV", "EXE", "OCX", "OV?", "PIF", "SYS", "VXD"};
    private static final String[] DOC_EXTS = new String[]{"ACCD?", "CSH", "DOC", "DOC?", "DOT", "DOT?", "HLP", "HTA", "HTM", "HTML", "HTT", "INF", "INI", "JPEG", "JPG", "JS", "JSE", "JTD", "MDB", "MP?", "MSO", "OBD", "OBT", "PDF", "PL", "PM", "POT", "POT?", "PP?", "PP??", "PPT", "RTF", "SH", "SHB", "SHS", "SMM", "VBE", "VBS", "VSD", "VSS", "VST", "WSF", "WSH", "XL?", "XL??", "XPS"};
    private List<Extension> selectedExts;
    private JButton addExtButton;
    private JButton removeExtButton;
    private JButton defaultExtButton;
    private JButton addProgButton;
    private JButton addDocButton;
    private DefaultListModel<String> listModel;
    private JList<String> extList;
    private JTextField extField;

    public ExtSelectDialog(String title) {
        super(title, true, true);
    }

    public void setObject(List<Extension> selectedExts) {
        this.selectedExts = selectedExts;
        this.updateListModel();
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "ExtSelectDialog." + key);
    }

    private void updateListModel() {
        int i;
        String[] exts;
        if (this.selectedExts == null || this.selectedExts.size() == 0) {
            exts = DEFAULT_EXTS;
        } else {
            exts = new String[this.selectedExts.size()];
            for (i = 0; i < exts.length; ++i) {
                exts[i] = this.selectedExts.get(i).getContent();
            }
        }
        this.listModel.removeAllElements();
        for (i = 0; i < exts.length; ++i) {
            this.listModel.addElement(exts[i]);
        }
    }

    public List<Extension> getObject() {
        return this.getExtensionList(this.listModel.toArray());
    }

    private List<Extension> getExtensionList(Object[] arr) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (int i = 0; i < arr.length; ++i) {
            Extension e = new Extension();
            e.setContent((String)arr[i]);
            result.add(e);
        }
        return result;
    }

    private void setupComponents() {
        this.extField = new JTextField(8);
        this.extField.setDocument(new ExtAlphaNumbericWildCardDocument(this.extField, 12));
        this.addExtButton = new JButton(this.getRes("button.add"));
        this.addExtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newExt = ExtSelectDialog.this.extField.getText().trim();
                if (newExt.length() > 0) {
                    if (ExtSelectDialog.this.listModel.contains(newExt)) {
                        JOptionPane.showMessageDialog(null, ExtSelectDialog.this.getRes("error.nodupext"), ExtSelectDialog.this.getRes("error.dupext"), 0);
                    } else {
                        boolean found = false;
                        Object[] arExt = new String[ExtSelectDialog.this.listModel.size()];
                        ExtSelectDialog.this.listModel.copyInto(arExt);
                        for (int index = 0; index < arExt.length; ++index) {
                            if (!newExt.equalsIgnoreCase((String)arExt[index])) continue;
                            JOptionPane.showMessageDialog(null, ExtSelectDialog.this.getRes("error.nodupext"), ExtSelectDialog.this.getRes("error.dupext"), 0);
                            found = true;
                            break;
                        }
                        if (!found) {
                            ExtSelectDialog.this.listModel.add(0, newExt.toUpperCase());
                            ExtSelectDialog.this.extField.setText("");
                            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)ExtSelectDialog.this.extField, true));
                        }
                    }
                }
            }
        });
        this.removeExtButton = new JButton(this.getRes("button.remove"));
        this.removeExtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selected = ExtSelectDialog.this.extList.getSelectedValuesList().toArray();
                for (int i = 0; i < selected.length; ++i) {
                    ExtSelectDialog.this.listModel.removeElement(selected[i]);
                }
            }
        });
        this.defaultExtButton = new JButton(this.getRes("button.useDefaults"));
        this.defaultExtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtSelectDialog.this.setDefaultExts();
                ExtSelectDialog.this.extList.setSelectionInterval(0, ExtSelectDialog.this.listModel.size() - 1);
            }
        });
        this.addProgButton = new JButton(this.getRes("button.commonProgs"));
        this.addProgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < PROGRAM_EXTS.length; ++i) {
                    if (ExtSelectDialog.this.listModel.contains(PROGRAM_EXTS[i])) continue;
                    ExtSelectDialog.this.listModel.addElement(PROGRAM_EXTS[i]);
                }
                ExtSelectDialog.this.extList.setSelectionInterval(0, ExtSelectDialog.this.listModel.size() - 1);
            }
        });
        this.addDocButton = new JButton(this.getRes("button.commonDocs"));
        this.addDocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < DOC_EXTS.length; ++i) {
                    if (ExtSelectDialog.this.listModel.contains(DOC_EXTS[i])) continue;
                    ExtSelectDialog.this.listModel.addElement(DOC_EXTS[i]);
                }
                ExtSelectDialog.this.extList.setSelectionInterval(0, ExtSelectDialog.this.listModel.size() - 1);
            }
        });
        this.listModel = new DefaultListModel();
        this.setDefaultExts();
        this.extList = new JList<String>(this.listModel);
        this.extList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExtSelectDialog.this.enableAppropriate();
            }
        });
        this.enableAppropriate();
    }

    private void setDefaultExts() {
        this.listModel.removeAllElements();
        for (int i = 0; i < DEFAULT_EXTS.length; ++i) {
            this.listModel.addElement(DEFAULT_EXTS[i]);
        }
    }

    private void enableAppropriate() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return;
        }
        this.removeExtButton.setEnabled(this.extList.getSelectedIndices().length > 0);
    }

    @Override
    protected JPanel getContentPanel() {
        this.setupComponents();
        GridBagLayout layout = new GridBagLayout();
        JPanel leftPanel = new JPanel(layout);
        leftPanel.setBorder(BorderFactory.createTitledBorder(this.getRes("label.title")));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 11;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 0, 5);
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.extList);
        leftPanel.add((Component)scrollPane, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        leftPanel.add((Component)this.removeExtButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets.bottom = 5;
        constraints.anchor = 10;
        leftPanel.add((Component)this.extField, constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.0;
        leftPanel.add((Component)this.addExtButton, constraints);
        JPanel rightPanel = new JPanel(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 0;
        constraints.anchor = 11;
        rightPanel.add((Component)this.defaultExtButton, constraints);
        constraints.gridy = 1;
        rightPanel.add((Component)this.addProgButton, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        rightPanel.add((Component)this.addDocButton, constraints);
        JPanel mainPanel = new JPanel(new GridLayout(1, 2));
        mainPanel.add(leftPanel);
        mainPanel.add(rightPanel);
        return mainPanel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == super.getPlatFormType()) {
            return "sesm_policies_dialog_av_auto_protect_file_extensions";
        }
        return "sesm_policies_dialog_av_auto_protect_file_extensions";
    }

    @Override
    protected boolean isValidate() {
        if (this.getObject().size() <= 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.extensionListNotNull"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.error"), 0);
            return false;
        }
        return true;
    }

    private static class ExtAlphaNumbericWildCardDocument
    extends RestrictedPlainDocument {
        private static final long serialVersionUID = 1L;

        public ExtAlphaNumbericWildCardDocument(JTextField owner, int maxChars) {
            super(maxChars);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                super.insertString(offs, str, a);
                return;
            }
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isLetterOrDigit(chars[i]) || chars[i] == '?') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

