/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.logicobject.DriveTypesObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DriveTypesLocalPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean showLock;
    private int platformType;
    private JCheckBox chkCDRom;
    private JCheckBox chkFloppy;
    private LockCheckBox lockCheckBoxCDRom;
    private LockCheckBox lockCheckBoxFloppy;
    private DriveTypesObject driveTypesObj;

    public DriveTypesLocalPane(boolean showLock, int platformType) {
        this.showLock = showLock;
        this.platformType = platformType;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "Before");
    }

    public void setObject(DriveTypesObject driveTypesObj) {
        this.driveTypesObj = driveTypesObj;
        this.updatePanel();
        this.enableAppropriate();
    }

    public void save() {
        this.saveData();
    }

    private JPanel getPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        JLabel driveTypeLocalLabel = null;
        String labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileTypesPane.label.driveTypes");
        if (this.platformType == 3) {
            driveTypeLocalLabel = UIUtilities.getDeprecatedOnLinuxLabel(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP);
            driveTypeLocalLabel.setHorizontalTextPosition(2);
            driveTypeLocalLabel.setText(labelText);
        } else {
            driveTypeLocalLabel = new JLabel(labelText);
        }
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        pane.add((Component)driveTypeLocalLabel, c);
        if (this.showLock) {
            c.gridx = 0;
            c.gridy = 1;
            this.lockCheckBoxCDRom = new LockCheckBox(Boolean.FALSE);
            this.lockCheckBoxCDRom.setSelectedIcon(AvConstants.lockIcon);
        }
        c.gridx = 1;
        c.gridy = 1;
        this.chkCDRom = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.cdrom"));
        c.gridx = 0;
        c.gridy = 2;
        if (this.showLock) {
            this.lockCheckBoxFloppy = new LockCheckBox(Boolean.FALSE);
            this.lockCheckBoxFloppy.setSelectedIcon(AvConstants.lockIcon);
            pane.add((Component)this.lockCheckBoxFloppy, c);
        }
        c.gridx = 1;
        c.gridy = 2;
        this.chkFloppy = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.RemovableMedia"));
        pane.add((Component)this.chkFloppy, c);
        return pane;
    }

    private void enableAllComponents(boolean enable) {
        this.chkCDRom.setEnabled(enable);
        this.chkFloppy.setEnabled(enable);
    }

    private void enableAppropriate() {
        this.enableAppropriate(true);
    }

    public void enableAppropriate(boolean allEnabled) {
        this.enableAllComponents(allEnabled);
    }

    private void updatePanel() {
        if (this.showLock) {
            this.lockCheckBoxCDRom.setSelected(this.driveTypesObj.getLockEnableCDRom());
            this.lockCheckBoxFloppy.setSelected(this.driveTypesObj.getLockEnableFloppy());
        }
        this.chkCDRom.setSelected(this.driveTypesObj.getEnableCDRom());
        this.chkFloppy.setSelected(this.driveTypesObj.getEnableFloppy());
    }

    private void saveData() {
        if (this.showLock) {
            this.driveTypesObj.setLockEnableCDRom(this.lockCheckBoxFloppy.isSelected());
            this.driveTypesObj.setLockEnableFloppy(this.lockCheckBoxFloppy.isSelected());
        }
        this.driveTypesObj.setEnableCDRom(this.chkFloppy.isSelected());
        this.driveTypesObj.setEnableFloppy(this.chkFloppy.isSelected());
    }
}

