/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.common.FolderPrefixPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DirectoryEditDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private JRadioButton allRadioButton;
    private JRadioButton selectedRadioButton;
    private FolderPrefixPanel folderPanel;

    public DirectoryEditDialog(String title) {
        super(title, true, true);
    }

    public void setObject(String dirs) {
        this.folderPanel.setObject(dirs);
        String[] dirArray = dirs.split(";");
        boolean selectAllRadioButton = dirArray.length > 0 && dirArray[0].equals("[AllDrives]");
        this.allRadioButton.setSelected(selectAllRadioButton);
        this.selectedRadioButton.setSelected(!selectAllRadioButton);
        if (selectAllRadioButton) {
            this.allRadioButton.requestFocusInWindow();
        } else {
            this.selectedRadioButton.requestFocusInWindow();
        }
        if (this.isReadOnly()) {
            this.folderPanel.enableFolderSelection(false);
        } else {
            this.folderPanel.enableFolderSelection(!selectAllRadioButton);
        }
    }

    protected String getContentSensitiveToken() {
        return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details_edit_dir";
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "DirectoryEditDialog." + key);
    }

    public String getObject() {
        return this.allRadioButton.isSelected() ? "[AllDrives]" : this.folderPanel.getObject();
    }

    private void setupComponents() {
        this.allRadioButton = new JRadioButton(this.getRes("radio.allDir"));
        this.selectedRadioButton = new JRadioButton(this.getRes("radio.selectedDir"));
        UIUtilities.groupButtons(this.allRadioButton, this.selectedRadioButton);
        this.folderPanel = new FolderPrefixPanel(false);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (DirectoryEditDialog.this.isReadOnly()) {
                        DirectoryEditDialog.this.folderPanel.enableFolderSelection(false);
                    } else {
                        DirectoryEditDialog.this.folderPanel.enableFolderSelection(!DirectoryEditDialog.this.allRadioButton.isSelected());
                    }
                }
            }
        };
        this.allRadioButton.addItemListener(itemListener);
        this.selectedRadioButton.addItemListener(itemListener);
    }

    @Override
    protected JPanel getContentPanel() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.editDirTitle"), this.getRes("label.editDirDesc"));
        this.setupComponents();
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.allRadioButton, c);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.selectedRadioButton, c);
        c.fill = 1;
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        p.add((Component)this.folderPanel, c);
        p.setPreferredSize(new Dimension(800, 500));
        result.add(p);
        return result;
    }

    @Override
    protected boolean isValidate() {
        boolean isValid = true;
        if (this.selectedRadioButton.isSelected() && this.folderPanel.getObject().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.getRes("noSelectionError.message"), this.getRes("noSelectionError.title"), 0);
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_scan_scan_details_edit_directories";
    }
}

