/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CompressedFilesPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MIN_SCAN_DEPTH = 1;
    private static final int MAX_SCAN_DEPTH = 10;
    private static final int MAX_SCAN_DEPTH_LINUX = 3;
    private CompressedFilesObject compressedFilesObj;
    private JSpinner spinner;
    private SpinnerNumberModel levelModel;
    private JCheckBox scanInsideChk;
    private LockCheckBox lockScanInsideChk;
    private JTextArea expendLabel;
    private boolean isAdminDefinedScan = false;
    private int platFormType = 1;

    public CompressedFilesPane(boolean isAdminDefinedScan, int platFormType) {
        this.isAdminDefinedScan = isAdminDefinedScan;
        this.platFormType = platFormType;
        this.setLayout(new BorderLayout());
        JPanel compressedFilesPane = this.getPanel();
        compressedFilesPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                List<Component> compsList = UIUtilities.getAllComponents((Container)event.getSource());
                for (Component comp : compsList) {
                    if (!(comp instanceof JCheckBox)) continue;
                    ((JCheckBox)comp).setFocusPainted(false);
                }
            }
        });
        this.add((Component)compressedFilesPane, "West");
    }

    private void enableAllComponents(boolean enable) {
        this.spinner.setEnabled(enable);
        this.scanInsideChk.setEnabled(enable);
    }

    private void enableAppropriate() {
        this.enableAppropriate(true);
    }

    public void enableAppropriate(boolean allEnabled) {
        this.scanInsideChk.setFocusPainted(true);
        this.enableAllComponents(allEnabled);
        this.spinner.setEnabled(allEnabled && this.scanInsideChk.isSelected());
        this.expendLabel.setEnabled(allEnabled && this.scanInsideChk.isSelected());
    }

    public void setObject(CompressedFilesObject compressedFilesObj) {
        this.compressedFilesObj = compressedFilesObj;
        this.updatePanel();
        this.enableAppropriate();
    }

    public void save() {
        this.saveData();
    }

    private JPanel getPanel() {
        JPanel pane = new JPanel();
        pane.putClientProperty("cssClass", "compressedFilesPaneBase");
        pane.setLayout(new GridBagLayout());
        this.lockScanInsideChk = new LockCheckBox(Boolean.FALSE);
        this.lockScanInsideChk.putClientProperty("cssClass", "compressedFilesPaneLockScanInsideChk");
        this.lockScanInsideChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockScanInsideChk.setVisible(!this.isAdminDefinedScan);
        this.lockScanInsideChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CompressedFilesPane.this.lockScanInsideChk.setFocusPainted(true);
            }
        });
        pane.add((Component)this.lockScanInsideChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.scanInsideChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "CompressedFilesPane.checkbox.insideCompressedFile"));
        this.scanInsideChk.putClientProperty("cssClass", "compressedFilesPaneScanInsideChk");
        this.scanInsideChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CompressedFilesPane.this.enableAppropriate();
            }
        });
        pane.add((Component)this.scanInsideChk, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.expendLabel = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "CompressedFilesPane.label.expandLabel"));
        this.expendLabel.putClientProperty("cssClass", "compressedFilesPaneExpendLabel");
        this.expendLabel.setEditable(false);
        this.expendLabel.setFocusable(false);
        this.expendLabel.setWrapStyleWord(true);
        this.expendLabel.setLineWrap(false);
        this.expendLabel.setOpaque(false);
        this.levelModel = new SpinnerNumberModel(1, 1, 10, 1);
        if (3 == this.platFormType) {
            this.levelModel = new SpinnerNumberModel(1, 1, 3, 1);
        }
        this.spinner = new JSpinner(this.levelModel);
        UIUtilities.enableOnlyValidEdits(this.spinner);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CompressedFilesPane.this.levelModel.getNumber().intValue() < 1) {
                    // empty if block
                }
            }
        });
        JPanel expandPanel = new JPanel(new GridBagLayout());
        expandPanel.putClientProperty("cssClass", "compressedFilesPaneExpandPanel");
        expandPanel.add((Component)this.expendLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 25, 0, 0), 0, 0));
        expandPanel.add((Component)this.spinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 30), 10, 0));
        pane.add((Component)expandPanel, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return pane;
    }

    private void updatePanel() {
        this.lockScanInsideChk.setSelected(this.compressedFilesObj.getLockScanInsideCompressedFiles());
        this.scanInsideChk.setSelected(this.compressedFilesObj.getScanInsideCompressedFiles());
        this.levelModel.setValue(this.compressedFilesObj.getExpandLevels());
    }

    private void saveData() {
        this.compressedFilesObj.setLockScanInsideCompressedFiles(this.lockScanInsideChk.isSelected());
        this.compressedFilesObj.setScanInsideCompressedFiles(this.scanInsideChk.isSelected());
        Number level = this.levelModel.getNumber();
        this.compressedFilesObj.setExpandLevels(level.intValue());
    }
}

