/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObjectManager;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.common.configobject.schema.SecurityRiskItem;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.i18n.LocaleManipulationUtility;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CloudLockPanel;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.hi.library.HiObjectManager;
import com.sygate.scm.util.AVUtility;
import com.sygate.scm.util.DynaCatManipulationUtility;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CommonActionsPanel
extends JPanel {
    private static final String COOKIE_ITEM_NAME = "2:15";
    private static final long serialVersionUID = 1587499633163685511L;
    private static final String ACTIONS_FOR = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.table.column.header.actionsFor");
    private static final String INDENT = "    ";
    private static final String[] ACTION_TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.clean"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.quarantine"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.delete"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.logOnly")};
    private static int DEFAULT_VIRUS_ACTION_INDEX = 0;
    private static int DEFAULT_VIRUS_FAIL_ACTION_INDEX = 1;
    private static int DEFAULT_SECURITY_ACTION_INDEX = 1;
    private static int DEFAULT_SECURITY_FAIL_ACTION_INDEX = 3;
    private static int CLEAN_INDEX = 0;
    private static int QUARANTINE_INDEX = 1;
    private static int DELETE_INDEX = 2;
    private static int LOG_ONLY_INDEX = 3;
    private static Hashtable<String, Integer> mapActionTypeToIndex = new Hashtable(4);
    private static Hashtable<Integer, String> mapIndexToActionType;
    private JLabel actionTitleLabel;
    private AvTemplatePane actionPane;
    protected LockCheckBox lockBackupChk;
    protected LockCheckBox lockTerminateChk;
    protected LockCheckBox lockStopChk;
    protected JCheckBox backupChk;
    protected JCheckBox terminateChk;
    protected JCheckBox stopChk;
    private JList<ListModelObject> groupList;
    private DefaultListModel<ListModelObject> groupListModel = new DefaultListModel();
    private ApActionsObject apActionsObj;
    private JPanel actionsCardPanel = new JPanel();
    private CardLayout cl = new CardLayout();
    private Map<String, RiskActionsPanel> itemPanels = new HashMap<String, RiskActionsPanel>();
    private boolean actionsChanged = false;
    private ApActions newApActions;
    protected boolean isAdminDefinedScan = false;
    protected boolean showRemediationControls;
    protected int platformType = 1;

    public CommonActionsPanel(boolean showRemediationControls) {
        this.showRemediationControls = showRemediationControls;
        this.setupPanel();
    }

    public CommonActionsPanel(boolean showRemediationControls, boolean isDisplayLocks) {
        this.showRemediationControls = showRemediationControls;
        this.isAdminDefinedScan = isDisplayLocks;
        this.setupPanel();
    }

    public void setupPanel() {
        VerticalFlowLayout thisLayout = new VerticalFlowLayout();
        this.setLayout(thisLayout);
        this.add(this.getActionPane());
        if (this.showRemediationControls) {
            this.initRemediationComponents();
            this.add(this.getRemediationPane());
        }
    }

    public int getPlatformType() {
        return this.platformType;
    }

    public void save() {
        this.saveData();
    }

    protected JPanel getRemediationPane() {
        return new JPanel();
    }

    private void initRemediationComponents() {
        this.lockBackupChk = new LockCheckBox(Boolean.FALSE);
        this.lockBackupChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockTerminateChk = new LockCheckBox(Boolean.FALSE);
        this.lockTerminateChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockStopChk = new LockCheckBox(Boolean.FALSE);
        this.lockStopChk.setSelectedIcon(AvConstants.lockIcon);
        this.backupChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.backup"));
        this.terminateChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.terminate"));
        this.stopChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.stop"));
        this.setLocksVisible();
    }

    private void setLocksVisible() {
        this.lockBackupChk.setVisible(!this.isAdminDefinedScan);
        this.lockTerminateChk.setVisible(!this.isAdminDefinedScan);
        this.lockStopChk.setVisible(!this.isAdminDefinedScan);
    }

    private AvTemplatePane getActionPane() {
        if (this.actionPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.label.actions");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.label.actionsDesc");
            this.actionPane = new AvTemplatePane(title, desc);
            this.actionPane.add(this.getTablePane());
        }
        return this.actionPane;
    }

    private JPanel getTablePane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getDetectionPane(), "Before");
        panel.add((Component)this.actionsCardPanel, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        return panel;
    }

    private JPanel getDetectionPane() {
        JPanel titlePane = new JPanel();
        titlePane.setLayout(new BorderLayout());
        JLabel actionsForLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.table.column.header.detection"));
        titlePane.add((Component)actionsForLabel, "Center");
        Border innerBorder = BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND);
        Border outterBorder = BorderFactory.createEmptyBorder(0, 20, 0, 20);
        titlePane.setBorder(BorderFactory.createCompoundBorder(innerBorder, outterBorder));
        this.groupList = new JList<ListModelObject>(this.groupListModel);
        this.groupList.setBackground(this.getBackground());
        this.groupList.setSelectionMode(1);
        this.groupList.setCellRenderer(new DetectionListRenderer());
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ex) {
                if (!ex.getValueIsAdjusting()) {
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning() && CommonActionsPanel.this.groupList.getSelectedValue() == null) {
                        return;
                    }
                    String key = CommonActionsPanel.this.groupList.getSelectedValue().getKey();
                    CommonActionsPanel.this.cl.show(CommonActionsPanel.this.actionsCardPanel, key);
                    CommonActionsPanel.this.actionsCardPanel.revalidate();
                }
            }
        });
        JPanel detectionPane = new JPanel();
        detectionPane.setLayout(new VerticalFlowLayout());
        detectionPane.add(this.groupList);
        innerBorder = BorderFactory.createMatteBorder(0, 1, 1, 1, UIColorUtilities.CONTROL_BACKGROUND);
        outterBorder = BorderFactory.createEmptyBorder(0, 20, 0, 20);
        detectionPane.setBorder(BorderFactory.createCompoundBorder(innerBorder, outterBorder));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)titlePane, "North");
        panel.add((Component)detectionPane, "Center");
        return panel;
    }

    private void initDetectionPane() throws ConsoleException {
        SecurityRiskGroup group;
        this.actionsCardPanel.setLayout(this.cl);
        ApActions apActions = this.apActionsObj.getSchemaObject();
        this.newApActions = new ApActions();
        HashMap<String, SecurityRiskGroup> existingGroups = new HashMap<String, SecurityRiskGroup>();
        HashMap<String, SecurityRiskItem> existingItems = new HashMap<String, SecurityRiskItem>();
        AVUtility aVUtility = AVUtility.getInstance();
        aVUtility.checkSecurityRisksAction(apActions, "MacroVirusAction", true);
        aVUtility.checkSecurityRisksAction(apActions, "NonMacroVirusAction", true);
        aVUtility.checkSecurityRisksAction(apActions, "SecurityRisksAction", true);
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            group = apActions.getSecurityRiskGroup(i);
            SecurityRiskGroup newGroup = (SecurityRiskGroup)group.clone();
            this.newApActions.addSecurityRiskGroup(newGroup);
            String groupKey = newGroup.getName();
            String uberCatName = DynaCatManipulationUtility.checkSecurityGroupLegacy((String)groupKey);
            if (uberCatName != null) {
                newGroup.setName(uberCatName);
                groupKey = uberCatName;
            }
            existingGroups.put(groupKey, newGroup);
            for (int j = 0; j < newGroup.getSecurityRiskItemCount(); ++j) {
                SecurityRiskItem risk = newGroup.getSecurityRiskItem(j);
                String riskKey = risk.getName();
                String dynaCatName = DynaCatManipulationUtility.checkSecurityItemLegacy((String)riskKey);
                if (dynaCatName != null) {
                    risk.setName(dynaCatName);
                    riskKey = dynaCatName;
                }
                existingItems.put(riskKey, risk);
            }
        }
        String oldGroupKey = null;
        group = null;
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(LocaleManipulationUtility.getLocaleCultureID((Locale)Locale.getDefault())));
        SemTable logSemTable = GUIManager.getSemTable(1400, rpc, -1, -1);
        int rowCount = logSemTable.getSemTableRowCount();
        int uberCategoryIndex = 0;
        String[] uberCategories = DynaCatManipulationUtility.getDynaUberCategories();
        String groupKey = null;
        for (int i = 0; i < rowCount; ++i) {
            SemTableRow virusCategoryRow = logSemTable.getSemTableRow(i);
            groupKey = virusCategoryRow.getSemTableValue(0).getValue();
            if ("0".equals(groupKey)) continue;
            if (!groupKey.equals(oldGroupKey)) {
                while (uberCategoryIndex < uberCategories.length && Integer.parseInt(groupKey) > Integer.parseInt(uberCategories[uberCategoryIndex])) {
                    group = this.addSecurityRiskGroup(uberCategories[uberCategoryIndex++], this.newApActions, existingGroups);
                }
                if (uberCategoryIndex == uberCategories.length) break;
                oldGroupKey = groupKey;
                group = this.addSecurityRiskGroup(groupKey, this.newApActions, existingGroups);
                ++uberCategoryIndex;
            }
            String riskKey = virusCategoryRow.getSemTableValue(1).getValue();
            if ("1".equals(groupKey) && !"0".equals(riskKey)) continue;
            String riskName = virusCategoryRow.getSemTableValue(2).getValue();
            this.addSecurityRiskItem(riskKey, riskName, groupKey, group, existingItems);
        }
        while (uberCategoryIndex < uberCategories.length) {
            group = this.addSecurityRiskGroup(uberCategories[uberCategoryIndex], this.newApActions, existingGroups);
            ++uberCategoryIndex;
        }
        for (RiskActionsPanel rap : this.itemPanels.values()) {
            if (!(rap instanceof GroupRiskActionsPanel)) continue;
            ((GroupRiskActionsPanel)rap).initializeChildren();
        }
    }

    private SecurityRiskGroup addSecurityRiskGroup(String groupKey, ApActions apActions, Map<String, SecurityRiskGroup> existingGroups) {
        String groupName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.ubercategory." + groupKey);
        SecurityRiskGroup group = null;
        if (existingGroups.containsKey(groupKey)) {
            group = existingGroups.get(groupKey);
        } else {
            group = new SecurityRiskGroup();
            group.setName(groupKey);
            group.setApAction(DynaCatManipulationUtility.getApAction((SecurityRiskGroup)group));
            apActions.addSecurityRiskGroup(group);
            existingGroups.put(groupKey, group);
        }
        GroupRiskActionsPanel rap = new GroupRiskActionsPanel(groupName, groupKey);
        rap.setObject(group);
        this.actionsCardPanel.add(groupKey, rap);
        this.itemPanels.put(groupKey, rap);
        this.groupListModel.addElement(new ListModelObject(groupKey, groupName));
        return group;
    }

    private SecurityRiskItem addSecurityRiskItem(String riskKey, String riskName, String groupKey, SecurityRiskGroup group, Map<String, SecurityRiskItem> existingItems) {
        SecurityRiskItem item = null;
        String itemKey = groupKey + ":" + riskKey;
        if (existingItems.containsKey(itemKey)) {
            item = existingItems.get(itemKey);
        } else {
            item = new SecurityRiskItem();
            item.setName(itemKey);
            item.setOptApAction(DynaCatManipulationUtility.getApAction((SecurityRiskItem)item));
            group.addSecurityRiskItem(item);
            existingItems.put(itemKey, item);
        }
        ItemRiskActionsPanel rap = new ItemRiskActionsPanel(riskName, itemKey, groupKey);
        rap.setObject(item);
        if (DynaCatManipulationUtility.isSecurityItemAvaliable((String)itemKey, (int)this.platformType)) {
            this.actionsCardPanel.add(itemKey, rap);
            this.itemPanels.put(itemKey, rap);
            this.groupListModel.addElement(new ListModelObject(itemKey, INDENT + riskName));
        }
        return item;
    }

    private static boolean isCloudEnrolled() {
        return CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    }

    private void updatePanel() throws ConsoleException {
        this.initDetectionPane();
        this.groupList.setSelectedIndex(0);
        if (this.showRemediationControls) {
            this.lockBackupChk.setSelected(this.apActionsObj.getLockBackUpFileBeforeRepair());
            this.lockTerminateChk.setSelected(this.apActionsObj.getLockTerminateProcessesAutomatically());
            this.lockStopChk.setSelected(this.apActionsObj.getLockStopServicesAutomatically());
            this.backupChk.setSelected(this.apActionsObj.getBackUpFileBeforeRepair());
            this.terminateChk.setSelected(this.apActionsObj.getTerminateProcessesAutomatically());
            this.stopChk.setSelected(this.apActionsObj.getStopServicesAutomatically());
        }
    }

    private void saveData() {
        for (RiskActionsPanel panel : this.itemPanels.values()) {
            panel.save();
        }
        if (this.showRemediationControls) {
            this.apActionsObj.setLockBackUpFileBeforeRepair(this.lockBackupChk.isSelected());
            this.apActionsObj.setLockStopServicesAutomatically(this.lockStopChk.isSelected());
            this.apActionsObj.setLockTerminateProcessesAutomatically(this.lockTerminateChk.isSelected());
            this.apActionsObj.setBackUpFileBeforeRepair(this.backupChk.isSelected());
            this.apActionsObj.setStopServicesAutomatically(this.stopChk.isSelected());
            this.apActionsObj.setTerminateProcessesAutomatically(this.terminateChk.isSelected());
        }
        ApActions apActions = this.apActionsObj.getSchemaObject();
        if (this.actionsChanged && this.newApActions != null) {
            int i;
            ArrayList<String> ids = new ArrayList<String>();
            Vector<SecurityRiskGroup> deletingVec = new Vector<SecurityRiskGroup>();
            for (i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
                SecurityRiskGroup group = apActions.getSecurityRiskGroup(i);
                deletingVec.add(group);
                ids.add(group.getI());
            }
            for (i = 0; i < deletingVec.size(); ++i) {
                apActions.removeSecurityRiskGroup((SecurityRiskGroup)deletingVec.get(i));
            }
            for (i = 0; i < this.newApActions.getSecurityRiskGroupCount(); ++i) {
                SecurityRiskGroup riskGroup = this.newApActions.getSecurityRiskGroup(i);
                String oldI = riskGroup.getI();
                apActions.addSecurityRiskGroup(riskGroup);
                if (!ids.contains(oldI)) continue;
                riskGroup.setI(oldI);
                apActions.removeObsoleteItem(new ObsoleteItem(oldI));
            }
        }
    }

    public void setObject(ApActionsObject apActionsObj) throws ConsoleException {
        this.apActionsObj = apActionsObj;
        this.updatePanel();
    }

    public static ApActions getDefaultApActions() throws ParserConfigurationException, SAXException, IOException, ValidationException {
        ApActions apActionsFromTemplate = null;
        if (apActionsFromTemplate == null) {
            AbstractSchema.registerObjectManager((String)"hi", (ObjectManager)new HiObjectManager());
            BufferedInputStream in = new BufferedInputStream(Template.class.getResourceAsStream("default_shared_policies_template.xml"));
            Template temp = TemplateManager.getTemplate((InputStream)in);
            IOUtilities.closeInputStream((InputStream)in);
            SchemaContainer container = (SchemaContainer)AbstractSchema.readXML((String)temp.getXML());
            Vector subContainerList = container.getChildren();
            for (AbstractSchema next : subContainerList) {
                ConfigObject conObj;
                SchemaContainer con;
                Vector childrean;
                if (!(next instanceof SchemaContainer) || (childrean = (con = (SchemaContainer)next).getChildren()).size() <= 0 || !((conObj = (ConfigObject)childrean.get(0)) instanceof AdminDefinedScan)) continue;
                AdminDefinedScan tempAdminDefinedScan = (AdminDefinedScan)conObj;
                apActionsFromTemplate = tempAdminDefinedScan.getOptApActions();
                break;
            }
        }
        return apActionsFromTemplate;
    }

    static {
        mapActionTypeToIndex.put(ACTION_TYPES[CLEAN_INDEX], ApAction.CLEAN);
        mapActionTypeToIndex.put(ACTION_TYPES[QUARANTINE_INDEX], ApAction.QUARANTINE);
        mapActionTypeToIndex.put(ACTION_TYPES[DELETE_INDEX], ApAction.DELETE);
        mapActionTypeToIndex.put(ACTION_TYPES[LOG_ONLY_INDEX], ApAction.LOG_ONLY);
        mapIndexToActionType = new Hashtable(4);
        mapIndexToActionType.put(ApAction.CLEAN, ACTION_TYPES[CLEAN_INDEX]);
        mapIndexToActionType.put(ApAction.QUARANTINE, ACTION_TYPES[QUARANTINE_INDEX]);
        mapIndexToActionType.put(ApAction.DELETE, ACTION_TYPES[DELETE_INDEX]);
        mapIndexToActionType.put(ApAction.LOG_ONLY, ACTION_TYPES[LOG_ONLY_INDEX]);
    }

    private static class ListModelObject {
        private String key;
        private String displayName;

        public ListModelObject(String key, String displayName) {
            this.key = key;
            this.displayName = displayName;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static class DetectionListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 2026331740115052950L;

        public DetectionListRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            if (isSelected) {
                this.setBackground(UIColorUtilities.DEFAULT_SELECTION_BACKGROUND);
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private abstract class RiskActionsPanel
    extends JPanel {
        private static final long serialVersionUID = -7775846986345951824L;
        protected String title;
        protected String key;
        protected JCheckBox overrideChk;
        protected LockCheckBox lockOverrideChk;
        protected LockCheckBox lockFirstActionChk;
        protected LockCheckBox lockIfFirstFailChk;
        protected JComboBox<String> firstActionCombo;
        protected ItemListener firstActionListener;
        protected JComboBox<String> ifFirstFailCombo;
        protected DefaultComboBoxModel<String> firstActionModel = new DefaultComboBoxModel();
        protected DefaultComboBoxModel<String> ifFirstFailModel = new DefaultComboBoxModel();
        protected ApAction action;

        protected RiskActionsPanel(String title, String key) {
            this.title = title;
            this.key = key;
            this.setupPanel();
        }

        protected boolean getOverride() {
            return this.overrideChk.isSelected();
        }

        protected int getFirstAction() {
            return this.firstActionCombo.getSelectedIndex();
        }

        protected int getSecondAction() {
            return this.ifFirstFailCombo.getSelectedIndex();
        }

        protected void setFirstAction(int index) {
            if (this.key.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                return;
            }
            if (index == this.firstActionModel.getSize()) {
                this.firstActionModel.addElement(ACTION_TYPES[CLEAN_INDEX]);
            }
            this.firstActionCombo.setSelectedIndex(index);
        }

        protected void setSecondAction(int index) {
            if (this.key.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                return;
            }
            if (index == this.ifFirstFailModel.getSize()) {
                this.ifFirstFailModel.addElement(ACTION_TYPES[CLEAN_INDEX]);
            }
            this.ifFirstFailCombo.setSelectedIndex(index);
        }

        protected void setLockFirstAction(boolean selected) {
            this.lockFirstActionChk.setSelected(selected);
        }

        protected void setLockSecondAction(boolean selected) {
            this.lockIfFirstFailChk.setSelected(selected);
        }

        protected boolean getLockFirstAction() {
            return this.lockFirstActionChk.isSelected();
        }

        protected boolean getLockSecondAction() {
            return this.lockIfFirstFailChk.isSelected();
        }

        protected void setAppropriateActions(String itemName) {
            if (itemName.equals("CookieAction") || itemName.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                this.firstActionModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                this.firstActionModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
                this.ifFirstFailModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                this.ifFirstFailModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
            } else if (!(itemName.equals("MacroVirusAction") || itemName.equals("NonMacroVirusAction") || DynaCatManipulationUtility.isMalwareCategory((String)itemName))) {
                this.firstActionModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                this.ifFirstFailModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
            }
        }

        protected void setObject(ApAction action) {
            if (action == null) {
                action = new ApAction();
            }
            this.action = action;
            this.updatePanel();
            this.enableAppropriate();
            this.removeFirstSelectionFromIfFirstFail();
            this.setLocksVisible();
        }

        protected void setLocksVisible() {
            if (CommonActionsPanel.this.isAdminDefinedScan) {
                this.lockOverrideChk.setVisible(!CommonActionsPanel.this.isAdminDefinedScan);
            }
            this.lockFirstActionChk.setVisible(!CommonActionsPanel.this.isAdminDefinedScan);
            this.lockIfFirstFailChk.setVisible(!CommonActionsPanel.this.isAdminDefinedScan);
        }

        protected void enableAppropriate() {
            if (this.key == CommonActionsPanel.COOKIE_ITEM_NAME) {
                this.setAppropriateActions(this.key);
            }
        }

        protected void save() {
            Boolean optLockFirstAction;
            boolean itemOverrideFlag = true;
            if (this instanceof ItemRiskActionsPanel) {
                itemOverrideFlag = ((ItemRiskActionsPanel)this).overrideChk.isSelected();
            }
            if ((optLockFirstAction = this.action.getOptLockFirstAction()) == null) {
                optLockFirstAction = this.action.getDefLockFirstAction();
            }
            if (itemOverrideFlag && optLockFirstAction.booleanValue() != this.lockFirstActionChk.isSelected()) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.action.setOptLockFirstAction(Boolean.valueOf(this.lockFirstActionChk.isSelected()));
            if (itemOverrideFlag && !this.action.getFirstAction().equals(mapActionTypeToIndex.get(this.firstActionCombo.getSelectedItem()))) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.action.setFirstAction(mapActionTypeToIndex.get(this.firstActionCombo.getSelectedItem()));
            Boolean optLockSecondAction = this.action.getOptLockSecondAction();
            if (optLockSecondAction == null) {
                optLockSecondAction = this.action.getDefLockSecondAction();
            }
            if (itemOverrideFlag && optLockSecondAction.booleanValue() != this.lockIfFirstFailChk.isSelected()) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.action.setOptLockSecondAction(Boolean.valueOf(this.lockIfFirstFailChk.isSelected()));
            if (itemOverrideFlag && !this.action.getSecondAction().equals(mapActionTypeToIndex.get(this.ifFirstFailCombo.getSelectedItem()))) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.action.setSecondAction(mapActionTypeToIndex.get(this.ifFirstFailCombo.getSelectedItem()));
        }

        protected void updatePanel() {
            Boolean b = this.action.getOptLockFirstAction();
            if (b == null) {
                b = this.action.getDefLockFirstAction();
            }
            this.lockFirstActionChk.setSelected(b);
            b = this.action.getOptLockSecondAction();
            if (b == null) {
                b = this.action.getDefLockSecondAction();
            }
            this.lockIfFirstFailChk.setSelected(b);
            this.firstActionCombo.removeItemListener(this.firstActionListener);
            this.setDefaultActions();
            this.firstActionCombo.addItemListener(this.firstActionListener);
            Integer i = this.action.getFirstAction();
            if (i != null) {
                this.firstActionModel.setSelectedItem(mapIndexToActionType.get(i));
            }
            if ((i = this.action.getSecondAction()) != null) {
                this.ifFirstFailModel.setSelectedItem(mapIndexToActionType.get(i));
            }
            this.removeFirstSelectionFromIfFirstFail();
        }

        private void setupComponents() {
            this.lockOverrideChk = new LockCheckBox(Boolean.FALSE);
            this.lockOverrideChk.setSelectedIcon(AvConstants.lockIcon);
            this.overrideChk = this.key != null && this.key.startsWith("1:") ? new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.override.malware")) : (this.key != null && this.key.startsWith("2:") ? new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.override.securityrisks")) : new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.checkbox.override")));
            this.overrideChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    RiskActionsPanel.this.enableAppropriate();
                }
            });
            this.lockFirstActionChk = new LockCheckBox(Boolean.FALSE);
            this.lockFirstActionChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockIfFirstFailChk = new LockCheckBox(Boolean.FALSE);
            this.lockIfFirstFailChk.setSelectedIcon(AvConstants.lockIcon);
            if (this.key != null && this.key.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                this.ifFirstFailModel.addElement(ACTION_TYPES[LOG_ONLY_INDEX]);
                this.firstActionModel.addElement(ACTION_TYPES[DELETE_INDEX]);
                this.firstActionModel.addElement(ACTION_TYPES[LOG_ONLY_INDEX]);
            } else {
                int i;
                for (i = 0; i < ACTION_TYPES.length; ++i) {
                    this.ifFirstFailModel.addElement(ACTION_TYPES[i]);
                }
                for (i = 0; i < ACTION_TYPES.length; ++i) {
                    this.firstActionModel.addElement(ACTION_TYPES[i]);
                }
            }
            this.ifFirstFailCombo = new JComboBox<String>(this.ifFirstFailModel);
            this.firstActionCombo = new JComboBox<String>(this.firstActionModel);
            this.firstActionListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ex) {
                    if (ex.getStateChange() == 1) {
                        RiskActionsPanel.this.removeFirstSelectionFromIfFirstFail();
                    }
                }
            };
            this.firstActionCombo.addItemListener(this.firstActionListener);
        }

        private void removeFirstSelectionFromIfFirstFail() {
            if (this.key.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                return;
            }
            Object selectedItem = this.ifFirstFailModel.getSelectedItem();
            this.ifFirstFailCombo.removeAllItems();
            for (int i = 0; i < ACTION_TYPES.length; ++i) {
                this.ifFirstFailModel.addElement(ACTION_TYPES[i]);
            }
            if (!(this.key.equals("MacroVirusAction") || this.key.equals("NonMacroVirusAction") || DynaCatManipulationUtility.isMalwareCategory((String)this.key))) {
                this.ifFirstFailModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
            }
            this.ifFirstFailModel.removeElement(this.firstActionModel.getSelectedItem());
            if (this.firstActionModel.getSelectedItem() != selectedItem) {
                this.ifFirstFailModel.setSelectedItem(selectedItem);
            } else {
                int defaultIndex = DEFAULT_VIRUS_FAIL_ACTION_INDEX;
                if (!(this.key.equals("MacroVirusAction") || this.key.equals("NonMacroVirusAction") || DynaCatManipulationUtility.isMalwareCategory((String)this.key))) {
                    defaultIndex = DEFAULT_SECURITY_FAIL_ACTION_INDEX;
                }
                if (this.ifFirstFailModel.getIndexOf(ACTION_TYPES[defaultIndex]) != -1) {
                    this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[defaultIndex]);
                } else if (!(this.key.equals("MacroVirusAction") || this.key.equals("NonMacroVirusAction") || DynaCatManipulationUtility.isMalwareCategory((String)this.key))) {
                    this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[QUARANTINE_INDEX]);
                } else {
                    this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[ACTION_TYPES.length - 1]);
                }
            }
            if (this.firstActionModel.getSelectedItem().equals(ACTION_TYPES[LOG_ONLY_INDEX])) {
                this.ifFirstFailCombo.setEnabled(false);
            } else if (this.overrideChk.isSelected()) {
                this.ifFirstFailCombo.setEnabled(true);
            }
        }

        private void setupPanel() {
            this.setupComponents();
            JPanel titlePane = new JPanel();
            titlePane.setLayout(new BorderLayout());
            CommonActionsPanel.this.actionTitleLabel = new JLabel();
            CommonActionsPanel.this.actionTitleLabel.setText(ACTIONS_FOR + CommonActionsPanel.INDENT + this.title);
            titlePane.add((Component)CommonActionsPanel.this.actionTitleLabel, "Center");
            MatteBorder innerBorder = BorderFactory.createMatteBorder(1, 0, 1, 1, UIColorUtilities.CONTROL_BACKGROUND);
            Border outterBorder = BorderFactory.createEmptyBorder(0, 20, 0, 20);
            titlePane.setBorder(BorderFactory.createCompoundBorder(innerBorder, outterBorder));
            JPanel actionPane = new JPanel();
            actionPane.setLayout(new GridBagLayout());
            DescriptionTextArea area = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ActionsPane.label.provideDesc"));
            JLabel firstLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstAction"));
            JLabel ifFirstFailLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstActionFail"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(20, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 5;
            actionPane.add((Component)area, c);
            c.insets = new Insets(10, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            actionPane.add((Component)this.lockOverrideChk, c);
            c.gridwidth = 3;
            c.gridx = 1;
            c.gridy = 1;
            actionPane.add((Component)this.overrideChk, c);
            c.gridwidth = 1;
            c.insets = new Insets(10, 5, 0, 0);
            c.gridx = 1;
            c.gridy = 2;
            actionPane.add((Component)firstLabel, c);
            if (this.isPlatformSupportCloud()) {
                c.gridx = 2;
                c.gridy = 2;
                actionPane.add((Component)new CloudLockPanel(this.lockFirstActionChk), c);
            }
            c.insets = new Insets(10, 5, 0, 0);
            c.gridx = 3;
            c.gridy = 2;
            actionPane.add(this.firstActionCombo, c);
            c.insets = new Insets(10, 5, 0, 0);
            c.gridx = 1;
            c.gridy = 3;
            actionPane.add((Component)ifFirstFailLabel, c);
            if (this.isPlatformSupportCloud()) {
                c.gridx = 2;
                c.gridy = 3;
                actionPane.add((Component)new CloudLockPanel(this.lockIfFirstFailChk), c);
            }
            c.gridx = 3;
            c.gridy = 3;
            c.insets = new Insets(10, 5, 0, 0);
            actionPane.add(this.ifFirstFailCombo, c);
            actionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.add((Component)actionPane, "Before");
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            p1.add((Component)pane, "North");
            innerBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, UIColorUtilities.CONTROL_BACKGROUND);
            outterBorder = BorderFactory.createEmptyBorder(0, 20, 0, 0);
            p1.setBorder(BorderFactory.createCompoundBorder(innerBorder, outterBorder));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)titlePane, "North");
            panel.add((Component)p1, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            if (this.isPlatformSupportCloud() && CommonActionsPanel.isCloudEnrolled()) {
                String tooltip = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled");
                this.firstActionCombo.setToolTipText(tooltip);
                this.ifFirstFailCombo.setToolTipText(tooltip);
                firstLabel.setToolTipText(tooltip);
                ifFirstFailLabel.setToolTipText(tooltip);
            }
        }

        private void setDefaultActions() {
            if (this.key.equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                this.firstActionModel.setSelectedItem(ACTION_TYPES[DELETE_INDEX]);
                this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[LOG_ONLY_INDEX]);
                this.firstActionModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                this.firstActionModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
                this.ifFirstFailModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                this.ifFirstFailModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
            } else if (!(this.key.equals("MacroVirusAction") || this.key.equals("NonMacroVirusAction") || DynaCatManipulationUtility.isMalwareCategory((String)this.key))) {
                this.firstActionModel.setSelectedItem(ACTION_TYPES[DEFAULT_SECURITY_ACTION_INDEX]);
                this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[DEFAULT_SECURITY_FAIL_ACTION_INDEX]);
            } else {
                this.firstActionModel.setSelectedItem(ACTION_TYPES[DEFAULT_VIRUS_ACTION_INDEX]);
                this.ifFirstFailModel.setSelectedItem(ACTION_TYPES[DEFAULT_VIRUS_FAIL_ACTION_INDEX]);
            }
        }

        private boolean isPlatformSupportCloud() {
            return 1 == CommonActionsPanel.this.platformType;
        }
    }

    private class ItemRiskActionsPanel
    extends RiskActionsPanel {
        private static final long serialVersionUID = 2584853260185712856L;
        private SecurityRiskItem item;
        private String parentKey;

        public ItemRiskActionsPanel(String title, String key, String parentKey) {
            super(title, key);
            this.parentKey = parentKey;
        }

        @Override
        protected void save() {
            super.save();
            Boolean optLockOverrideSecurityRiskAction = this.item.getOptLockOverrideSecurityRiskAction();
            if (optLockOverrideSecurityRiskAction == null) {
                optLockOverrideSecurityRiskAction = this.item.getDefLockOverrideSecurityRiskAction();
            }
            if (optLockOverrideSecurityRiskAction.booleanValue() != this.lockOverrideChk.isSelected()) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.item.setOptLockOverrideSecurityRiskAction(Boolean.valueOf(this.lockOverrideChk.isSelected()));
            Boolean optOverrideSecurityRiskAction = this.item.getOptOverrideSecurityRiskAction();
            if (optOverrideSecurityRiskAction == null) {
                optOverrideSecurityRiskAction = false;
            }
            if (optOverrideSecurityRiskAction.booleanValue() != this.overrideChk.isSelected()) {
                CommonActionsPanel.this.actionsChanged = true;
            }
            this.item.setOptOverrideSecurityRiskAction(Boolean.valueOf(this.overrideChk.isSelected()));
        }

        @Override
        protected void updatePanel() {
            Boolean b = this.item.getOptLockOverrideSecurityRiskAction();
            if (b == null) {
                b = this.item.getDefLockOverrideSecurityRiskAction();
            }
            this.lockOverrideChk.setSelected(b);
            b = this.item.getOptOverrideSecurityRiskAction();
            if (b == null) {
                b = this.item.getDefOverrideSecurityRiskAction();
            }
            this.overrideChk.setSelected(b);
            this.enableAppropriate();
            super.updatePanel();
        }

        @Override
        protected void enableAppropriate() {
            boolean override = this.overrideChk.isSelected();
            this.lockFirstActionChk.setEnabled(override);
            this.firstActionCombo.setEnabled(override);
            this.lockIfFirstFailChk.setEnabled(override);
            this.ifFirstFailCombo.setEnabled(override && !this.firstActionModel.getSelectedItem().equals(ACTION_TYPES[LOG_ONLY_INDEX]));
            if (!override) {
                RiskActionsPanel parentPanel = CommonActionsPanel.this.itemPanels.get(this.parentKey);
                if (parentPanel != null) {
                    if (this.item.getName().equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                        this.firstActionModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                        this.firstActionModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
                        this.setFirstAction(DELETE_INDEX);
                        this.setSecondAction(LOG_ONLY_INDEX);
                        this.ifFirstFailCombo.setEnabled(false);
                    } else {
                        this.setFirstAction(parentPanel.getFirstAction());
                        this.setSecondAction(parentPanel.getSecondAction());
                    }
                    this.setLockFirstAction(parentPanel.getLockFirstAction());
                    this.setLockSecondAction(parentPanel.getLockSecondAction());
                }
            } else {
                RiskActionsPanel parentPanel = CommonActionsPanel.this.itemPanels.get(this.parentKey);
                if (parentPanel != null && this.item.getName().equals(CommonActionsPanel.COOKIE_ITEM_NAME)) {
                    this.firstActionModel.removeElement(ACTION_TYPES[CLEAN_INDEX]);
                    this.firstActionModel.removeElement(ACTION_TYPES[QUARANTINE_INDEX]);
                    this.ifFirstFailCombo.setEnabled(false);
                }
            }
        }

        public void setObject(SecurityRiskItem item) {
            this.item = item;
            this.setAppropriateActions(item.getName());
            super.setObject(item.getOptApAction());
        }
    }

    private class GroupRiskActionsPanel
    extends RiskActionsPanel {
        private static final long serialVersionUID = 1L;
        private SecurityRiskGroup group;

        public GroupRiskActionsPanel(String title, String key) {
            super(title, key);
        }

        public void initializeChildren() {
            this.propateChangeToChildren();
        }

        private void propateChangeToChildren() {
            for (int j = 0; j < this.group.getSecurityRiskItemCount(); ++j) {
                SecurityRiskItem risk = this.group.getSecurityRiskItem(j);
                String riskKey = risk.getName();
                RiskActionsPanel rap = CommonActionsPanel.this.itemPanels.get(riskKey);
                if (rap == null || rap.getOverride()) continue;
                rap.setFirstAction(this.firstActionCombo.getSelectedIndex());
                rap.setSecondAction(this.ifFirstFailCombo.getSelectedIndex());
                rap.setLockFirstAction(this.lockFirstActionChk.isSelected());
                rap.setLockSecondAction(this.lockIfFirstFailChk.isSelected());
            }
        }

        public void setObject(SecurityRiskGroup group) {
            this.group = group;
            this.lockOverrideChk.setVisible(false);
            this.overrideChk.setVisible(false);
            this.overrideChk.setSelected(true);
            this.setAppropriateActions(group.getName());
            super.setObject(group.getApAction());
            this.firstActionCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GroupRiskActionsPanel.this.propateChangeToChildren();
                }
            });
            this.ifFirstFailCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GroupRiskActionsPanel.this.propateChangeToChildren();
                }
            });
            this.lockFirstActionChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GroupRiskActionsPanel.this.propateChangeToChildren();
                }
            });
            this.lockIfFirstFailChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    GroupRiskActionsPanel.this.propateChangeToChildren();
                }
            });
        }
    }
}

