/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.configobject.schema.HeuristicsOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CloudLockPanel;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.CloudUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BloodhoundScanSettingPanel
extends AvTemplatePane {
    private static final long serialVersionUID = 1L;
    private static final String[] PROTECTION_LEVEL = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.list.protectionLevel.automatic"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.list.protectionLevel.aggressive")};
    private HeuristicsOptions options;
    private final boolean hasLock;
    private LockCheckBox lockEnableBloodhoundChk;
    private JCheckBox enableBloodhoundChk;
    private JComboBox<String> protectionLevelComboBx;

    public BloodhoundScanSettingPanel(String title, String desc, boolean hasLock) {
        super(title, desc);
        this.hasLock = hasLock;
        this.initGui();
    }

    public void setObject(HeuristicsOptions incomingOptions) {
        this.options = incomingOptions == null ? new HeuristicsOptions() : incomingOptions;
        if (this.hasLock) {
            this.lockEnableBloodhoundChk.setSelected(Optional.ofNullable(this.options.getOptLockBloodhoundOptions()).orElseGet(() -> this.options.getDefLockBloodhoundOptions()));
        }
        this.enableBloodhoundChk.setSelected(Optional.ofNullable(this.options.getOptEnableBloodhound()).orElseGet(() -> this.options.getDefEnableBloodhound()));
        int bloodhoundLevel = Optional.ofNullable(this.options.getOptBloodhoundLevel()).orElseGet(() -> this.options.getDefBloodhoundLevel());
        int index = bloodhoundLevel > 1 ? bloodhoundLevel - 2 : bloodhoundLevel - 1;
        this.protectionLevelComboBx.setSelectedIndex(index);
        this.enableBloodhoundChkSelected();
    }

    public void saveData() {
        if (this.hasLock) {
            this.options.setOptLockBloodhoundOptions(Boolean.valueOf(this.isLockEnabled()));
        }
        this.options.setOptEnableBloodhound(Boolean.valueOf(this.isBloodhoundEnabled()));
        this.options.setOptBloodhoundLevel(Integer.valueOf(this.getProtectionLevel()));
    }

    public boolean isLockEnabled() {
        return this.hasLock ? this.lockEnableBloodhoundChk.isSelected() : this.options.getDefLockBloodhoundOptions().booleanValue();
    }

    public boolean isBloodhoundEnabled() {
        return this.enableBloodhoundChk.isSelected();
    }

    public int getProtectionLevel() {
        return this.protectionLevelComboBx.getSelectedIndex() + 2;
    }

    private void initGui() {
        if (this.hasLock) {
            this.lockEnableBloodhoundChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableBloodhoundChk.setSelectedIcon(AvConstants.lockIcon);
        }
        this.enableBloodhoundChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.enableBloodhound"));
        this.enableBloodhoundChk.addActionListener(e -> this.enableBloodhoundChkSelected());
        DefaultComboBoxModel<String> protectionLevelModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < PROTECTION_LEVEL.length; ++i) {
            protectionLevelModel.addElement(PROTECTION_LEVEL[i]);
        }
        this.protectionLevelComboBx = new JComboBox(protectionLevelModel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        JPanel pane = new JPanel(new GridBagLayout());
        if (this.hasLock) {
            pane.add((Component)new CloudLockPanel(this.lockEnableBloodhoundChk), c);
        }
        c.gridx = 1;
        c.gridy = 0;
        pane.add((Component)this.enableBloodhoundChk, c);
        if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) {
            this.enableBloodhoundChk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            this.protectionLevelComboBx.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        c.insets = new Insets(5, 30, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        pane.add((Component)this.getBloodHoundHelpLinkLabel(this.getRes("label.help")), c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 3;
        pane.add(this.protectionLevelComboBx, c);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)pane, "Before");
        this.add(panel);
    }

    private void enableBloodhoundChkSelected() {
        this.protectionLevelComboBx.setEnabled(this.enableBloodhoundChk.isSelected());
    }

    private HtmlEnabledJLabel getBloodHoundHelpLinkLabel(String bloodhoundText) {
        HtmlEnabledJLabel bloodHoundHelpLinkLabel = new HtmlEnabledJLabel(bloodhoundText, true);
        bloodHoundHelpLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
        bloodHoundHelpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_ads_scans_whatis_bloodhound");
            }
        });
        bloodHoundHelpLinkLabel.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return bloodHoundHelpLinkLabel;
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanPane." + key);
    }
}

