/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.common;

import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class AvTemplatePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private VerticalFlowLayout layout = new VerticalFlowLayout();
    private JComponent comp = null;

    public AvTemplatePane(String title, String desc) {
        this(title, desc, false);
    }

    public AvTemplatePane(String title, String desc, JLabel label) {
        this.comp = label;
        this.initialize(title, desc, false);
    }

    public AvTemplatePane(String title, String desc, boolean hasBorder, JComponent comp) {
        this.comp = comp;
        this.initialize(title, desc, hasBorder);
    }

    public AvTemplatePane(String title, String desc, boolean hasBorder) {
        this.initialize(title, desc, hasBorder);
    }

    public AvTemplatePane(String title, String desc, boolean hasBorder, int columns) {
        this.initialize(title, desc, hasBorder, columns);
    }

    public void addParagraph(String newDesc) {
        this.add(Box.createVerticalStrut(5));
        if (newDesc != null) {
            DescriptionTextArea descLabel = new DescriptionTextArea(newDesc);
            descLabel.setForeground(UIColorUtilities.SOFT_FOREGROUND);
            this.add(descLabel);
        }
    }

    public void initialize(String title, String desc, boolean hasBorder) {
        this.initialize(title, desc, hasBorder, 40);
    }

    public void initialize(String title, String desc, boolean hasBorder, int columns) {
        this.setLayout(this.layout);
        JPanel titleDescPanel = new JPanel();
        titleDescPanel.setLayout(new GridBagLayout());
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(UIFontUtilities.BOLD_FONT);
        titleLabel.putClientProperty("cssClass", "avTemplatePanelTitleLabel");
        titleDescPanel.add((Component)titleLabel, UiUtilities.getGridBagConstraints((int)0, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)23, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0));
        if (desc != null) {
            DescriptionTextArea descLabel = new DescriptionTextArea(desc, columns);
            descLabel.setForeground(UIColorUtilities.SOFT_FOREGROUND);
            titleDescPanel.add((Component)descLabel, UiUtilities.getGridBagConstraints((int)0, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)25, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0));
        }
        if (desc != null && this.comp != null) {
            JPanel pan = new JPanel();
            pan.add(this.comp);
            pan.setAlignmentX(0.5f);
            titleDescPanel.add((Component)pan, UiUtilities.getGridBagConstraints((int)1, (int)0, (int)1, (int)2, (double)1.0, (double)1.0, (int)22, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0));
        }
        this.add(titleDescPanel);
        JSeparator js = new JSeparator(0);
        js.putClientProperty("cssClass", "avTemplatePaneldashLine");
        this.add(js);
        if (hasBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 20));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        }
    }
}

