/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.DetectionNotificationPane;
import com.sygate.scm.console.ui.policy.av.ap.EmailMsgPane;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.policy.av.logicobject.EmailMessagesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MailNotificationObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class WebMailNotificationPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private DetectionNotificationPane detectionNotificationPane;
    private EmailMsgPane emailMsgPane;
    private AvTemplatePane progressPane;
    private LockCheckBox lockDisplayProgressChk;
    private JCheckBox displayProgressChk;
    private LockCheckBox lockDisplayTrayIconChk;
    private JCheckBox displayTrayIconChk;
    private MailNotificationObject notificationObj;

    public WebMailNotificationPane() {
        this.init();
    }

    public boolean valuesValid() {
        if (!this.emailMsgPane.valuesValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.label.webmail"))) {
            return false;
        }
        return this.detectionNotificationPane.valuesValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.label.webmail"));
    }

    public void setObject(MailNotificationObject notificationObj) {
        this.notificationObj = notificationObj;
        this.updatePanel();
    }

    public void save() {
        this.saveData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_internet_email_notifications";
    }

    private void init() {
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getDetectionNotificationPane());
        this.add(this.getEmailMsgPane());
        this.add(this.getProgressPane());
    }

    private EmailMsgPane getEmailMsgPane() {
        if (this.emailMsgPane == null) {
            this.emailMsgPane = new EmailMsgPane(1);
        }
        return this.emailMsgPane;
    }

    private DetectionNotificationPane getDetectionNotificationPane() {
        if (this.detectionNotificationPane == null) {
            this.detectionNotificationPane = new DetectionNotificationPane();
        }
        return this.detectionNotificationPane;
    }

    private JPanel getProgressPane() {
        if (this.progressPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.label.progressNotifications");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.label.progressNotificationsDesc");
            this.progressPane = new AvTemplatePane(title, desc);
            this.lockDisplayProgressChk = new LockCheckBox(Boolean.FALSE);
            this.lockDisplayProgressChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockDisplayTrayIconChk = new LockCheckBox(Boolean.FALSE);
            this.lockDisplayTrayIconChk.setSelectedIcon(AvConstants.lockIcon);
            this.displayProgressChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.checkbox.displayProgressIndicator"));
            this.displayTrayIconChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailNotificationPane.checkbox.displayTrayIcon"));
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)this.lockDisplayProgressChk, c);
            c.gridx = 1;
            c.gridy = 0;
            pane.add((Component)this.displayProgressChk, c);
            c.gridx = 0;
            c.gridy = 1;
            pane.add((Component)this.lockDisplayTrayIconChk, c);
            c.gridx = 1;
            c.gridy = 1;
            pane.add((Component)this.displayTrayIconChk, c);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)pane, "Before");
            this.progressPane.add(p);
        }
        return this.progressPane;
    }

    private void updatePanel() {
        this.detectionNotificationPane.setObject(this.notificationObj.getDetectionNotificationObj());
        this.emailMsgPane.setObject(this.notificationObj.getEmailMessagesObject());
        this.lockDisplayProgressChk.setSelected(this.notificationObj.getLockDisplaySendProgress());
        this.displayProgressChk.setSelected(this.notificationObj.getDisplaySendProgress());
        this.lockDisplayTrayIconChk.setSelected(this.notificationObj.getLockDisplaySystemTrayIcon());
        this.displayTrayIconChk.setSelected(this.notificationObj.getDisplaySystemTrayIcon());
    }

    private void saveData() {
        DetectionNotificationObject detectionNotificationObj = this.getDetectionNotificationPane().save();
        this.notificationObj.setDetectionNotificationObj(detectionNotificationObj);
        EmailMessagesObject emailMsgObj = this.getEmailMsgPane().save();
        this.notificationObj.setEmailMessagesObject(emailMsgObj);
        this.notificationObj.setLockDisplaySendProgress(this.lockDisplayProgressChk.isSelected());
        this.notificationObj.setDisplaySendProgress(this.displayProgressChk.isSelected());
        this.notificationObj.setLockDisplaySystemTrayIcon(this.lockDisplayTrayIconChk.isSelected());
        this.notificationObj.setDisplaySystemTrayIcon(this.displayTrayIconChk.isSelected());
    }
}

