/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.SafeProcessExclusionList;
import com.sygate.scm.common.configobject.schema.SafeProcessName;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.logicobject.SafeProcessExclusionObject;
import com.sygate.scm.console.ui.policy.av.logicobject.SafeProcessNameObject;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.dialog.FilenameVerifierDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SafeProcessExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.column.LabelFileName")};
    private JPanel jPanel = null;
    private JPanel tablePanel = null;
    private JTable exclusionTable;
    private SortableTableModel model;
    private transient ListSelectionListener tableSelectionListener;
    private transient MouseListener tableMouseListener;
    private JScrollPane scrollPane;
    private DescriptionTextArea description;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JPopupMenu actionPopup;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel buttonPanel;
    private SafeProcessExclusionObject logicObject;

    public SafeProcessExclusionDialog(JFrame parent, String title, Vector<SafeProcessName> list) {
        super(parent, title, true);
        this.logicObject = new SafeProcessExclusionObject(list);
        this.init();
    }

    public SafeProcessExclusionList getCustomProcessList() {
        return this.logicObject.getCustomProcessList();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_processes_scan_details_safeprocess_exclusionlist";
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJPanel());
        this.pack();
        UiUtilities.centerComponent((Component)this);
        if (this.isReadOnly()) {
            UIUtilities.setContainerStatus(this.getJPanel(), false);
            this.resetOKButton(false);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getTablePanel(), "Center");
            this.jPanel.add((Component)this.getButtonPanel(), "South");
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            if (this.getExclusionTable().getRowCount() > 0) {
                this.exclusionTable.setRowSelectionInterval(0, 0);
            }
        }
        return this.jPanel;
    }

    private JPanel getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new BorderLayout());
            this.tablePanel.add((Component)this.getDescription(), "North");
            this.tablePanel.add((Component)this.getScrollPane(), "Center");
            this.tablePanel.add((Component)this.getEditButtonPanel(), "South");
            this.tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.tablePanel;
    }

    private DescriptionTextArea getDescription() {
        if (this.description == null) {
            this.description = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.description"));
            this.description.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 0));
        }
        return this.description;
    }

    private JPanel getEditButtonPanel() {
        if (this.buttonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SafeProcessExclusionDialog.this.addSafeProcessName();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SafeProcessExclusionDialog.this.deleteSafeProcessName();
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SafeProcessExclusionDialog.this.editSafeProcessName();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.buttonPanel = new ButtonPane(buttons, 1);
        }
        return this.buttonPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(22, 31);
            UiUtilities.setupScrollPane((JScrollPane)this.scrollPane, (JTable)this.getExclusionTable());
        }
        return this.scrollPane;
    }

    private JTable getExclusionTable() {
        if (this.exclusionTable == null) {
            this.exclusionTable = new StripesTable();
            this.exclusionTable.setModel(this.getTableModel());
            this.exclusionTable.getSelectionModel().setSelectionMode(0);
            this.exclusionTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.exclusionTable.addMouseListener(this.getTableMouseListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.exclusionTable);
        }
        return this.exclusionTable;
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel();
            this.model.setColumnNames(columnNames);
            this.setDataIntoTableModel();
        }
        return this.model;
    }

    private void setDataIntoTableModel() {
        this.model.setDataVector(this.logicObject.getRows());
    }

    private ListSelectionListener getTableSelectionListener() {
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        SafeProcessExclusionDialog.this.setButtonEnabled();
                    }
                }
            };
        }
        return this.tableSelectionListener;
    }

    private void setButtonEnabled() {
        boolean isEnabled;
        int selIndex = this.getExclusionTable().getSelectedRow();
        boolean bl = isEnabled = selIndex != -1;
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(isEnabled);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(isEnabled);
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEnabled(isEnabled);
        }
        if (this.editAction != null) {
            this.editAction.setEnabled(isEnabled);
        }
    }

    private MouseListener getTableMouseListener() {
        if (this.tableMouseListener == null) {
            this.tableMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int colNumber = SafeProcessExclusionDialog.this.getExclusionTable().columnAtPoint(e.getPoint());
                    int rowNumber = SafeProcessExclusionDialog.this.getExclusionTable().rowAtPoint(e.getPoint());
                    if (e.getModifiers() == 4) {
                        SafeProcessExclusionDialog.this.getExclusionTable().setRowSelectionInterval(rowNumber, rowNumber);
                        SafeProcessExclusionDialog.this.getExclusionTable().setColumnSelectionInterval(colNumber, colNumber);
                        SafeProcessExclusionDialog.this.getActionPopup().show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() == 2) {
                        SafeProcessExclusionDialog.this.editSafeProcessName();
                    }
                }
            };
        }
        return this.tableMouseListener;
    }

    private JPopupMenu getActionPopup() {
        if (this.actionPopup == null) {
            this.actionPopup = new JPopupMenu();
            this.actionPopup.add(this.addAction);
            this.actionPopup.add(this.deleteAction);
            this.actionPopup.add(this.editAction);
        }
        this.setButtonEnabled();
        return this.actionPopup;
    }

    private void addSafeProcessName() {
        String newName = this.showEditDialog("");
        if (newName == null) {
            return;
        }
        this.addSafeProcessName(newName);
    }

    private void addSafeProcessName(String newName) {
        try {
            SafeProcessNameObject item = this.logicObject.addSafeProcessName(newName);
            this.getTableModel().insertRow(0, item);
            this.model.sortTable(-1);
            this.setSelection(item);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.badData"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.title"), 0);
        }
        catch (SafeProcessExclusionObject.DuplicateObjectException doe) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.duplicate"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.title"), 0);
        }
    }

    private void editSafeProcessName() {
        int index = this.getExclusionTable().getSelectedRow();
        if (index == -1) {
            return;
        }
        SafeProcessNameObject item = (SafeProcessNameObject)this.getTableModel().getDataVector().get(index);
        String newName = this.showEditDialog(item.getSafeProcessName().getFileName());
        if (newName == null) {
            return;
        }
        this.editSafeProcessName(item, newName);
    }

    private void editSafeProcessName(SafeProcessNameObject item, String newName) {
        try {
            this.logicObject.editSafeProcessName(item.getSafeProcessName(), newName);
            this.getTableModel().sortTable(-1);
            this.setSelection(item);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.badData"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.title"), 0);
        }
        catch (SafeProcessExclusionObject.DuplicateObjectException doe) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.duplicate"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "SafeProcessExclusionDialog.err.title"), 0);
        }
    }

    private void deleteSafeProcessName() {
        int index = this.getExclusionTable().getSelectedRow();
        if (index == -1) {
            return;
        }
        SafeProcessNameObject item = (SafeProcessNameObject)this.getTableModel().getDataVector().get(index);
        if (item != null) {
            this.logicObject.deleteSafeProcessName(item.getSafeProcessName().getFileName());
        }
        this.getTableModel().removeRow(index);
        if (this.getExclusionTable().getRowCount() > 0) {
            this.getExclusionTable().setRowSelectionInterval(0, 0);
        }
    }

    private String showEditDialog(String current) {
        FilenameVerifierDialog hDialog = new FilenameVerifierDialog(current);
        hDialog.setVisible(true);
        if (hDialog.isOk()) {
            return hDialog.getContents();
        }
        return null;
    }

    private void setSelection(SafeProcessNameObject spno) {
        SafeProcessNameObject currObj;
        if (spno == null) {
            return;
        }
        int rowSelected = this.getExclusionTable().getSelectedRow();
        SafeProcessNameObject safeProcessNameObject = currObj = rowSelected < 0 ? null : (SafeProcessNameObject)this.model.getRow(rowSelected);
        if (spno.equals(currObj)) {
            return;
        }
        this.exclusionTable.getSelectionModel().clearSelection();
        int count = this.model.getRowCount();
        for (int i = 0; i < count; ++i) {
            currObj = (SafeProcessNameObject)this.model.getRow(i);
            if (!spno.equals(currObj)) continue;
            this.exclusionTable.setRowSelectionInterval(i, i);
            return;
        }
    }
}

