/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.RiskTracer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RiskTracerDlg
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final long MIN_MS = 1L;
    private static final long MAX_MS = 30000L;
    AvTemplatePane contentPane;
    JPanel settingPane;
    LockCheckBox lockEnableChk;
    JCheckBox enableChk;
    JCheckBox resolveChk;
    JCheckBox pollChk;
    JTextField intervalTxtField;
    private RiskTracer riskTracer;

    public RiskTracerDlg(String title, RiskTracer riskTracer) {
        super(title, true, true);
        this.riskTracer = riskTracer;
        this.updatePanel();
        this.enableAppropriate();
    }

    @Override
    protected JPanel getContentPanel() {
        if (this.contentPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.label.riskTracer");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.label.riskTracerDesc");
            this.contentPane = new AvTemplatePane(title, desc);
            this.contentPane.add(this.getSettingPane());
        }
        return this.contentPane;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_processes_advanced_risk_tracer";
    }

    @Override
    protected boolean isValidate() {
        if (this.pollChk.isSelected() && (this.intervalTxtField.getText() == null || this.intervalTxtField.getText().trim().length() == 0 || Long.parseLong(this.intervalTxtField.getText().trim()) < 1L || Long.parseLong(this.intervalTxtField.getText().trim()) > 30000L)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.label.intervalEmptyError"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.label.error"), 0);
            return false;
        }
        return super.isValidate();
    }

    @Override
    protected void commit() {
        this.riskTracer.setOptLockRiskTracerOptions(Boolean.valueOf(this.lockEnableChk.isSelected()));
        this.riskTracer.setOptEnable(Boolean.valueOf(this.enableChk.isSelected()));
        this.riskTracer.setOptResolveSourceIPAddr(Boolean.valueOf(this.resolveChk.isSelected()));
        this.riskTracer.setOptPollForNetworkSession(Boolean.valueOf(this.pollChk.isSelected()));
        if (this.pollChk.isSelected()) {
            this.riskTracer.setOptPollNetworkEveryMilliSec(Long.valueOf(Long.parseLong(this.intervalTxtField.getText())));
        }
    }

    private JPanel getSettingPane() {
        if (this.settingPane == null) {
            this.settingPane = new JPanel();
            this.settingPane.setLayout(new BorderLayout());
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.lockEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableChk.setSelectedIcon(AvConstants.lockIcon);
            pane.add((Component)this.lockEnableChk, c);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 0;
            this.enableChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.checkbox.enable"));
            this.enableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RiskTracerDlg.this.enableAppropriate();
                }
            });
            pane.add((Component)this.enableChk, c);
            this.resolveChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.checkbox.resolve"));
            this.pollChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.checkbox.poll"));
            this.pollChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RiskTracerDlg.this.enableAppropriate();
                }
            });
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.resolveChk, c);
            c.gridx = 1;
            c.gridy = 2;
            pane.add((Component)this.pollChk, c);
            JLabel msLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "RiskTracerDlg.label.milliseconds"));
            this.intervalTxtField = new JTextField(10);
            this.intervalTxtField.setAlignmentX(11.0f);
            this.intervalTxtField.setDocument(new NumberPlainDocument(30000L, true));
            this.intervalTxtField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    RiskTracerDlg.this.validateMS();
                }
            });
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 3;
            c.insets = new Insets(5, 40, 0, 0);
            pane.add((Component)this.intervalTxtField, c);
            c.gridx = 2;
            c.gridy = 3;
            c.insets = new Insets(5, 5, 0, 0);
            pane.add((Component)msLabel, c);
            this.settingPane.add((Component)pane, "Before");
        }
        return this.settingPane;
    }

    private void validateMS() {
        String msText = this.intervalTxtField.getText();
        if (msText == null || msText.length() == 0) {
            return;
        }
        long ms = Long.parseLong(msText);
        if (ms < 1L) {
            this.intervalTxtField.setText(String.valueOf(1L));
            this.intervalTxtField.requestFocus();
        }
        if (ms > 30000L) {
            this.intervalTxtField.setText(String.valueOf(30000L));
            this.intervalTxtField.requestFocus();
        }
    }

    private void enableAppropriate() {
        boolean allEnable = this.enableChk.isSelected();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            allEnable = false;
        }
        this.resolveChk.setEnabled(allEnable);
        this.pollChk.setEnabled(allEnable);
        this.intervalTxtField.setEnabled(allEnable && this.pollChk.isSelected());
    }

    private void updatePanel() {
        Boolean b = this.riskTracer.getOptLockRiskTracerOptions();
        if (b == null) {
            b = this.riskTracer.getDefLockRiskTracerOptions();
        }
        this.lockEnableChk.setSelected(b);
        b = this.riskTracer.getOptEnable();
        if (b == null) {
            b = this.riskTracer.getDefEnable();
        }
        this.enableChk.setSelected(b);
        b = this.riskTracer.getOptResolveSourceIPAddr();
        if (b == null) {
            b = this.riskTracer.getDefResolveSourceIPAddr();
        }
        this.resolveChk.setSelected(b);
        b = this.riskTracer.getOptPollForNetworkSession();
        if (b == null) {
            b = this.riskTracer.getDefPollForNetworkSession();
        }
        this.pollChk.setSelected(b);
        if (this.pollChk.isSelected()) {
            Long l = this.riskTracer.getOptPollNetworkEveryMilliSec();
            if (l == null) {
                l = this.riskTracer.getDefPollNetworkEveryMilliSec();
            }
            this.intervalTxtField.setText(String.valueOf(l));
        }
    }
}

